package org.eclipse.jst.common.navigator.internal.java;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.common.navigator.internal.views.filters.NavigatorExtensionFilter;

public class NonSharedProjectFilter  extends NavigatorExtensionFilter {

	/*
	 * @see ViewerFilter
	 */
	public boolean select(CommonViewer aViewer, Object aParentElement, Object anElement) {
		if (anElement instanceof IProject)
			return isSharedProject((IProject)anElement);
		
		if (anElement instanceof IJavaProject)
			return isSharedProject(((IJavaProject)anElement).getProject());

		return true;
	}
	
	private boolean isSharedProject(IProject project) {
		return !project.isAccessible() || RepositoryProvider.isShared(project);
	}
}