/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - Initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.server.geronimo.core.internal.model;

import org.eclipse.jst.server.geronimo.core.internal.xml.IMemento;
import org.eclipse.jst.server.geronimo.core.internal.xml.XMLMemento;
/**
 * Sample resource-ref definition
 * 
 *   <resource-ref>
 *        <ref-name>jdbc/DataSource</naming:ref-name>
 *        <resource-link>SystemDatasource</naming:resource-link>
 *   </resource-ref>
 * 
 */
public class ResourceRef {
	
	public static final String RESOURCE_REF = "resource-ref";
	public static final String RESOURCE_REF_QUALIFIED = "naming:resource-ref";
	private static final String RESOURCE_LINK = "resource-link";
	private static final String RESOURCE_LINK_QUALIFIED = "naming:resource-link";
	private static final String REF_NAME = "ref-name";
	private static final String REF_NAME_QUALIFIED = "naming:ref-name";
	private static final String TARGET_NAME = "target-name";
	private static final String TARGET_NAME_QUALIFIED = "naming:target-name";

	private XMLMemento memento;

	public static ResourceRef createResourceRef(WebAppDeploymentPlan deployPlan, String refName, String resourceLink, String targetName)
	{
		XMLMemento refMemento=(XMLMemento)deployPlan.getRootMemento().createChild(RESOURCE_REF);
		ResourceRef ref=new ResourceRef(refMemento);
		ref.setRefName(refName);
		if(resourceLink!=null)
			ref.setResourceLink(resourceLink);
		if(targetName!=null)
			ref.setTargetName(targetName);
		return ref;
	}	
	

	public String getRefName() {
		// Load the ref name
		IMemento refName=memento.getChild(REF_NAME);
		// could not find, look for a qualified ref name
		if(refName==null)
			refName=memento.getChild(REF_NAME_QUALIFIED);
		
		String data;
		if(refName==null)
			data="";
		else
			data=refName.getTextData();
		return data;
	}

	public void setRefName(String refNameText) {
		// Load the ref name
		IMemento refName=memento.getChild(REF_NAME);
		// could not find, look for a qualified ref name
		if(refName==null)
			refName=memento.getChild(REF_NAME_QUALIFIED);
		// still could not find, create a new ref name
		if(refName==null)
			refName=memento.createChild(REF_NAME);
			
		if(refName instanceof XMLMemento)
		{
			XMLMemento xmlRefName=(XMLMemento)refName;

			if(refNameText==null || refNameText.length()==0)
				memento.removeChild(xmlRefName);
			else
				xmlRefName.setTextData(refNameText);
		}
		else
			throw new IllegalStateException();
	}

	public String getResourceLink() {
		// Load the resource link
		IMemento resourceLink=memento.getChild(RESOURCE_LINK);
		// could not find, look for a qualified resource link
		if(resourceLink==null)
			resourceLink=memento.getChild(RESOURCE_LINK_QUALIFIED);
		
		String data;
		if(resourceLink==null)
			data="";
		else
			data=resourceLink.getTextData();
		return data;
	}

	public void setResourceLink(String resourceLinkText) {
		// Load the resource link
		IMemento resourceLink=memento.getChild(RESOURCE_LINK);
		// could not find, look for a qualified resource link
		if(resourceLink==null)
			resourceLink=memento.getChild(RESOURCE_LINK_QUALIFIED);
		// still could not find, create a new resource link
		if(resourceLink==null)
			resourceLink=memento.createChild(RESOURCE_LINK);
					
		if(resourceLink instanceof XMLMemento)
		{
			XMLMemento xmlResourceLink=(XMLMemento)resourceLink;

			if(resourceLinkText==null || resourceLinkText.length()==0)
				memento.removeChild(xmlResourceLink);
			else
				xmlResourceLink.setTextData(resourceLinkText);
		}
		else
			throw new IllegalStateException();
	}

	public String getTargetName() {
		// Load the ref name
		IMemento targetName=memento.getChild(TARGET_NAME);
		// could not find, look for a qualified ref name
		if(targetName==null)
			targetName=memento.getChild(TARGET_NAME_QUALIFIED);
		
		String data;
		if(targetName==null)
			data="";
		else
			data=targetName.getTextData();
		return data;
	}

	public void setTargetName(String targetNameText) {
		// Load the ref name
		IMemento targetName=memento.getChild(TARGET_NAME);
		// could not find, look for a qualified ref name
		if(targetName==null)
			targetName=memento.getChild(TARGET_NAME_QUALIFIED);
		// still could not find, create a new ref name
		if(targetName==null)
			targetName=memento.createChild(TARGET_NAME);
			
		if(targetName instanceof XMLMemento)
		{
			XMLMemento xmlTargetName=(XMLMemento)targetName;

			if(targetNameText==null || targetNameText.length()==0)
				memento.removeChild(xmlTargetName);
			else
				xmlTargetName.setTextData(targetNameText);
		}
		else
			throw new IllegalStateException();
	}


	
	public ResourceRef(XMLMemento source)
	{
		memento=source;
	}	

	public boolean equals(Object otherObject)
	{
		if(!(otherObject.getClass().equals(this.getClass())))
			return false;
		ResourceRef other=(ResourceRef)otherObject;
		return (this.getRefName().equals(other.getRefName())
			 && this.getResourceLink().equals(other.getResourceLink()));
		
	}

	public XMLMemento getMemento() {
		return memento;
	}
	
	public String toString()
	{
		return "ResourceRef: "+memento.getName();
	}
}
