/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;

public class NewIndexAction extends Action {

   private static final String INDEX_TEMPLATE = "IndexTemplate.ddl"; //$NON-NLS-1$
   private static final String TITLE = ServerExtensionsPlugin.getString("NEW_INDEX"); //$NON-NLS-1$    

   /**
    * Launch SQL Editor with template content
    */
   public void run(IAction action) {
      try {
         init();   //initialize database, connection , and schema
         launchSQLEditor(INDEX_TEMPLATE, TITLE);
      }
      catch (Exception e) {
         ServerExtensionsPlugin.getDefault().writeLog(IStatus.ERROR, 0, e.getMessage(), e);
      }
   }
   
}
