/*
 *+------------------------------------------------------------------------+
 *| Licensed Materials - Property of IBM                                   |
 *| (C) Copyright IBM Corp. 2005.  All Rights Reserved.                    |
 *|                                                                        |
 *| US Government Users Restricted Rights - Use, duplication or disclosure |
 *| restricted by GSA ADP Schedule Contract with IBM Corp.                 |
 *+------------------------------------------------------------------------+
 */
package org.eclipse.wst.rdb.server.internal.ui.wizards;

import java.util.List;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.shared.NewCWJDBCPage;

/**
 * @author ledunnel
 */
public class NewConnectionJDBCConfigurationWizardPage extends NewCWJDBCPage {

    public NewConnectionJDBCConfigurationWizardPage(String name,
            int contentOptions, List existingConnectionNamesList) {
        super(name, contentOptions, existingConnectionNamesList);
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage = null;
        performTestConnection(false, true);
        if (isFinalConnection()) {
            nextPage = super.getNextPage();
        }
        return nextPage;
    }

    public boolean canFlipToNextPage() {
        return isPageComplete();
    }

}