/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderMemberFetcher;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteOperation;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.IElementCollector;

public class FetchMembersOperation
extends RemoteOperation {
    IElementCollector collector;
    RemoteFolderFilter filter = new RemoteFolderFilter();
    static /* synthetic */ Class class$0;

    public FetchMembersOperation(IWorkbenchPart part, ICVSRemoteFolder folder, IElementCollector collector) {
        super(part, new ICVSRemoteResource[]{folder});
        this.collector = collector;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        ICVSRemoteFolder remote = this.getRemoteFolder();
        Class<?> clazz = remote.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.team.internal.ccvs.core.resources.RemoteFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz2 = class$0 = clazz3;
        }
        if (clazz.equals(clazz2)) {
            monitor = Policy.monitorFor(monitor);
            boolean isRoot = remote.getName().equals("");
            monitor.beginTask(null, 100 + (isRoot ? 30 : 0));
            InternalRemoteFolderMemberFetcher fetcher = new InternalRemoteFolderMemberFetcher((RemoteFolder)remote, remote.getTag());
            fetcher.fetchMembers(Policy.subMonitorFor(monitor, 100));
            if (!isRoot) return;
            ICVSRemoteResource[] modules = CVSUIPlugin.getPlugin().getRepositoryManager().getRepositoryRootFor(remote.getRepository()).getDefinedModules(remote.getTag(), Policy.subMonitorFor(monitor, 25));
            this.collector.add((Object[])this.filter.filter(modules), Policy.subMonitorFor(monitor, 5));
            return;
        }
        monitor = Policy.monitorFor(monitor);
        try {
            try {
                monitor.beginTask(null, 100);
                Object[] children = remote.members(Policy.subMonitorFor(monitor, 95));
                this.collector.add(children, Policy.subMonitorFor(monitor, 5));
            }
            catch (TeamException e) {
                throw CVSException.wrapException((CoreException)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        monitor.done();
    }

    protected String getTaskName() {
        return NLS.bind((String)CVSUIMessages.FetchMembersOperation_0, (Object[])new String[]{this.getRemoteFolder().getName()});
    }

    private ICVSRemoteFolder getRemoteFolder() {
        return (ICVSRemoteFolder)this.getRemoteResources()[0];
    }

    public void setFilter(RemoteFolderFilter filter) {
        this.filter = filter;
    }

    public static class RemoteFolderFilter {
        public ICVSRemoteResource[] filter(ICVSRemoteResource[] resource) {
            return resource;
        }
    }

    public class InternalRemoteFolderMemberFetcher
    extends RemoteFolderMemberFetcher {
        long sendIncrement = 100L;
        List unsent = new ArrayList();
        long intervalStart;

        protected InternalRemoteFolderMemberFetcher(RemoteFolder parentFolder, CVSTag tag) {
            super(parentFolder, tag);
        }

        protected void parentDoesNotExist() {
            super.parentDoesNotExist();
            FetchMembersOperation.this.collector.add(new Object[0], this.getProgressMonitor());
        }

        protected RemoteFolder recordFolder(String name) {
            RemoteFolder folder = super.recordFolder(name);
            this.unsent.add(folder);
            if (this.isTimeToSend()) {
                this.sendFolders();
            }
            return folder;
        }

        private boolean isTimeToSend() {
            long currentTime = System.currentTimeMillis();
            return currentTime - this.intervalStart > this.sendIncrement || (long)this.unsent.size() > this.sendIncrement;
        }

        protected IStatus performUpdate(IProgressMonitor progress, CVSTag tag) throws CVSException {
            this.intervalStart = System.currentTimeMillis();
            IStatus status = super.performUpdate(progress, tag);
            this.sendFolders();
            return status;
        }

        protected void updateFileRevisions(ICVSFile[] files, IProgressMonitor monitor) throws CVSException {
            super.updateFileRevisions(files, monitor);
            this.sendFiles();
        }

        private void sendFolders() {
            this.updateParentFolderChildren();
            FetchMembersOperation.this.collector.add((Object[])FetchMembersOperation.this.filter.filter((ICVSRemoteResource[])this.unsent.toArray(new ICVSRemoteFolder[this.unsent.size()])), this.getProgressMonitor());
            this.unsent.clear();
            this.intervalStart = System.currentTimeMillis();
        }

        private void sendFiles() {
            FetchMembersOperation.this.collector.add((Object[])this.getFiles(), this.getProgressMonitor());
            this.unsent.clear();
        }

        private IProgressMonitor getProgressMonitor() {
            return null;
        }
    }
}

