/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.webservices.WebServiceClientGenerator;
import org.eclipse.jst.j2ee.internal.webservices.WebServicesClientDataHelper;
import org.eclipse.jst.ws.internal.axis.consumption.core.command.WSDL2JavaCommand;
import org.eclipse.jst.ws.internal.axis.consumption.ui.command.AddAxisJARToBuildPathCommand;
import org.eclipse.jst.ws.internal.axis.consumption.ui.command.AxisClientDefaultingCommand;
import org.eclipse.jst.ws.internal.axis.consumption.ui.command.CopyClientWSDLCommand;
import org.eclipse.jst.ws.internal.axis.consumption.ui.command.DefaultsForClientJavaWSDLCommand;
import org.eclipse.jst.ws.internal.axis.consumption.ui.env.J2EEEnvironment;
import org.eclipse.jst.ws.internal.axis.consumption.ui.task.AddJarsToProjectBuildPathTask;
import org.eclipse.jst.ws.internal.axis.consumption.ui.task.CopyAxisJarCommand;
import org.eclipse.jst.ws.internal.axis.consumption.ui.task.DefaultsForHTTPBasicAuthCommand;
import org.eclipse.jst.ws.internal.axis.consumption.ui.task.RefreshProjectCommand;
import org.eclipse.jst.ws.internal.axis.consumption.ui.task.Stub2BeanCommand;
import org.eclipse.jst.ws.internal.axis.consumption.ui.task.ValidateWSDLCommand;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.WSDLUtils;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.BuildProjectCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class AxisClientGenerator
extends WebServiceClientGenerator {
    private String pluginId_ = "org.eclipse.jst.ws.axis.consumption.ui";

    public IStatus genWebServiceClientArtifacts(WebServicesClientDataHelper dataModel) {
        String wsdlURL = dataModel.getWSDLUrl();
        String project = dataModel.getProjectName();
        String outputWSDLFilePathName = dataModel.getOutputWSDLFileName();
        String serviceQName = dataModel.getServiceQName();
        dataModel.shouldDeploy();
        SimpleStatus status = new SimpleStatus("");
        AxisClientDefaultingCommand axisClientDefaultingCommand = new AxisClientDefaultingCommand("");
        axisClientDefaultingCommand.setWsdlURL(wsdlURL);
        axisClientDefaultingCommand.setWebServicesParser((WebServicesParser)new WebServicesParserExt());
        axisClientDefaultingCommand.setClientProject(ProjectUtilities.getProject((String)project));
        axisClientDefaultingCommand.setTestProxySelected(false);
        axisClientDefaultingCommand.setIsClientScenario(true);
        axisClientDefaultingCommand.setGenerateProxy(true);
        J2EEEnvironment j2eeEnvironment = new J2EEEnvironment();
        status = axisClientDefaultingCommand.execute(j2eeEnvironment);
        if (status.getSeverity() != 0) {
            return EnvironmentUtils.convertStatusToIStatus((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, (String)this.pluginId_);
        }
        boolean isWebProject = ResourceUtils.isWebProject((IProject)axisClientDefaultingCommand.getClientProject());
        DefaultsForHTTPBasicAuthCommand httpCommand = new DefaultsForHTTPBasicAuthCommand();
        httpCommand.setJavaWSDLParam(axisClientDefaultingCommand.getJavaWSDLParam());
        httpCommand.setWsdlServiceURL(axisClientDefaultingCommand.getWsdlURL());
        httpCommand.setWebServicesParser(axisClientDefaultingCommand.getWebServicesParser());
        status = httpCommand.execute(j2eeEnvironment);
        if (status.getSeverity() != 0) {
            return EnvironmentUtils.convertStatusToIStatus((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, (String)this.pluginId_);
        }
        if (isWebProject) {
            CopyAxisJarCommand axjCommand = new CopyAxisJarCommand("");
            axjCommand.setProject(axisClientDefaultingCommand.getClientProject());
            status = axjCommand.execute(j2eeEnvironment);
            if (status.getSeverity() != 0) {
                return EnvironmentUtils.convertStatusToIStatus((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, (String)this.pluginId_);
            }
        } else {
            AddAxisJARToBuildPathCommand addAxisCommand = new AddAxisJARToBuildPathCommand();
            addAxisCommand.setProject(axisClientDefaultingCommand.getClientProject());
            status = addAxisCommand.execute(j2eeEnvironment);
            if (status.getSeverity() != 0) {
                return EnvironmentUtils.convertStatusToIStatus((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, (String)this.pluginId_);
            }
        }
        AddJarsToProjectBuildPathTask addJarsCommand = new AddJarsToProjectBuildPathTask();
        addJarsCommand.setProject(axisClientDefaultingCommand.getClientProject());
        status = addJarsCommand.execute(j2eeEnvironment);
        if (status.getSeverity() != 0) {
            return EnvironmentUtils.convertStatusToIStatus((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, (String)this.pluginId_);
        }
        DefaultsForClientJavaWSDLCommand defClientCommand = new DefaultsForClientJavaWSDLCommand("");
        defClientCommand.setJavaWSDLParam(axisClientDefaultingCommand.getJavaWSDLParam());
        defClientCommand.setProxyProject(axisClientDefaultingCommand.getClientProject());
        defClientCommand.setWSDLServiceURL(axisClientDefaultingCommand.getWsdlURL());
        status = defClientCommand.execute(j2eeEnvironment);
        if (status.getSeverity() != 0) {
            return EnvironmentUtils.convertStatusToIStatus((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, (String)this.pluginId_);
        }
        ValidateWSDLCommand valWSDLCommand = new ValidateWSDLCommand();
        valWSDLCommand.setWsdlURI(axisClientDefaultingCommand.getWsdlURL());
        valWSDLCommand.setWebServicesParser(axisClientDefaultingCommand.getWebServicesParser());
        status = valWSDLCommand.execute(j2eeEnvironment);
        if (status.getSeverity() != 0) {
            return EnvironmentUtils.convertStatusToIStatus((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, (String)this.pluginId_);
        }
        WSDL2JavaCommand w2jCommand = new WSDL2JavaCommand();
        w2jCommand.setJavaWSDLParam(axisClientDefaultingCommand.getJavaWSDLParam());
        w2jCommand.setWsdlURI(axisClientDefaultingCommand.getWsdlURL());
        status = w2jCommand.execute((Environment)j2eeEnvironment);
        if (status.getSeverity() != 0) {
            return EnvironmentUtils.convertStatusToIStatus((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, (String)this.pluginId_);
        }
        RefreshProjectCommand refreshCommand = new RefreshProjectCommand();
        refreshCommand.setProject(axisClientDefaultingCommand.getClientProject());
        status = refreshCommand.execute(j2eeEnvironment);
        if (status.getSeverity() != 0) {
            return EnvironmentUtils.convertStatusToIStatus((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, (String)this.pluginId_);
        }
        Stub2BeanCommand s2bCommand = new Stub2BeanCommand();
        s2bCommand.setJavaWSDLParam(axisClientDefaultingCommand.getJavaWSDLParam());
        s2bCommand.setWebServicesParser(axisClientDefaultingCommand.getWebServicesParser());
        s2bCommand.setClientProject(axisClientDefaultingCommand.getClientProject());
        status = s2bCommand.execute(j2eeEnvironment);
        if (status.getSeverity() != 0) {
            return EnvironmentUtils.convertStatusToIStatus((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, (String)this.pluginId_);
        }
        CopyClientWSDLCommand copyCommand = new CopyClientWSDLCommand();
        copyCommand.setWsdlURL(axisClientDefaultingCommand.getWsdlURL());
        copyCommand.setClientWSDLPathName(outputWSDLFilePathName);
        copyCommand.setWsParser(axisClientDefaultingCommand.getWebServicesParser());
        status = copyCommand.execute(j2eeEnvironment);
        if (status.getSeverity() != 0) {
            return EnvironmentUtils.convertStatusToIStatus((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, (String)this.pluginId_);
        }
        BuildProjectCommand buildCommand = new BuildProjectCommand();
        buildCommand.setProject(axisClientDefaultingCommand.getClientProject());
        buildCommand.setForceBuild(true);
        status = buildCommand.execute((Environment)j2eeEnvironment);
        if (status.getSeverity() != 0) {
            return EnvironmentUtils.convertStatusToIStatus((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, (String)this.pluginId_);
        }
        InterfaceNames interfaceNames = this.calculateSIandSEIName(axisClientDefaultingCommand.getWsdlURL(), serviceQName, axisClientDefaultingCommand.getWebServicesParser());
        String siName = interfaceNames.getSiName();
        String[] seiNames = interfaceNames.getSeiNames();
        if (siName == null || siName.length() == 0 || seiNames == null || seiNames.length == 0) {
            return new Status(4, this.pluginId_, 0, "Problems!!", null);
        }
        dataModel.setServiceInterfaceName(siName);
        dataModel.setServiceEndpointInterfaceNames(seiNames);
        dataModel.setDidGenDescriptors(false);
        return EnvironmentUtils.convertStatusToIStatus((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, (String)this.pluginId_);
    }

    private InterfaceNames calculateSIandSEIName(String wsdlURL, String serviceQName, WebServicesParser wsParser) {
        InterfaceNames iNames = new InterfaceNames();
        String serviceLocalPart = serviceQName.substring(serviceQName.lastIndexOf(58) + 1);
        Map pkg2nsMapping = null;
        Definition def = wsParser.getWSDLDefinition(wsdlURL);
        Map services = def.getServices();
        Service service = null;
        Iterator it = services.values().iterator();
        while (it.hasNext()) {
            service = (Service)it.next();
            if (serviceLocalPart.equals(service.getQName().getLocalPart())) break;
        }
        if (service != null) {
            String serviceClassName;
            String servicePkgName = WSDLUtils.getPackageName(service, pkg2nsMapping);
            String jndiName = serviceClassName = service.getQName().getLocalPart();
            Map ports = service.getPorts();
            Iterator it2 = ports.values().iterator();
            while (it2.hasNext()) {
                if (!serviceClassName.equals(((Port)it2.next()).getBinding().getPortType().getQName().getLocalPart())) continue;
                serviceClassName = String.valueOf(serviceClassName) + "_Service";
                break;
            }
            ArrayList<String> seiNames = new ArrayList<String>();
            Iterator it22 = ports.values().iterator();
            while (it22.hasNext()) {
                Port port = (Port)it22.next();
                SOAPAddress soapAddress = null;
                List extensibilityElements = port.getExtensibilityElements();
                if (extensibilityElements != null) {
                    Iterator it3 = extensibilityElements.iterator();
                    while (it3.hasNext()) {
                        Object object = it3.next();
                        if (!(object instanceof SOAPAddress)) continue;
                        soapAddress = (SOAPAddress)object;
                        break;
                    }
                }
                if (soapAddress == null) continue;
                PortType portType = port.getBinding().getPortType();
                QName portTypeQName = portType.getQName();
                String portTypePkgName = WSDLUtils.getPackageName(portType, pkg2nsMapping);
                String portTypeClassName = portTypeQName.getLocalPart();
                if (jndiName.equals(portTypeClassName)) {
                    portTypeClassName = String.valueOf(portTypeClassName) + "_Port";
                }
                seiNames.add(String.valueOf(portTypePkgName) + "." + portTypeClassName);
            }
            iNames.setSiName(String.valueOf(servicePkgName) + "." + serviceClassName);
            iNames.setSEINames(this.convertToStringArray(seiNames.toArray()));
        }
        return iNames;
    }

    private String[] convertToStringArray(Object[] a) {
        if (a == null) {
            return new String[0];
        }
        int length = a.length;
        String[] sa = new String[length];
        int i = 0;
        while (i < length) {
            Object obj = a[i];
            if (obj instanceof String) {
                sa[i] = (String)obj;
            }
            ++i;
        }
        return sa;
    }

    private class InterfaceNames {
        private String siName_;
        private String[] seiNames_;

        InterfaceNames() {
        }

        public String getSiName() {
            return this.siName_;
        }

        public String[] getSeiNames() {
            return this.seiNames_;
        }

        public void setSiName(String siName) {
            this.siName_ = siName;
        }

        public void setSEINames(String[] seiNames) {
            this.seiNames_ = seiNames;
        }
    }
}

