/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.view.tree.ModuleResourceAdapter;
import org.eclipse.wst.server.ui.internal.view.tree.ServerElementAdapter;
import org.eclipse.wst.server.ui.internal.view.tree.TextResourceAdapter;

public class ServerTreeContentProvider
implements ITreeContentProvider {
    protected TreeViewer viewer;
    protected LifecycleListener listener;
    protected IResourceChangeListener resourceChangeListener;
    static /* synthetic */ Class class$0;

    public ServerTreeContentProvider() {
        this.addServerResourceListener();
        this.addServerListener();
    }

    public Object[] getServerTreeRoots(Object parent) {
        return new Object[]{new TextResourceAdapter(parent, 0)};
    }

    public void dispose() {
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.listener);
    }

    protected IWorkbenchAdapter getAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            return null;
        }
        IAdaptable iAdaptable = (IAdaptable)o;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof TextResourceAdapter) {
            TextResourceAdapter adapter = (TextResourceAdapter)element;
            Object[] children = adapter.getChildren(null);
            if (children != null) {
                int size = children.length;
                int i = 0;
                while (i < size) {
                    if (children[i] instanceof ServerElementAdapter) {
                        ServerElementAdapter adapter2 = (ServerElementAdapter)children[i];
                        adapter2.setFlags((byte)1);
                    }
                    ++i;
                }
            }
            return children;
        }
        if (element instanceof ModuleResourceAdapter) {
            ModuleResourceAdapter adapter = (ModuleResourceAdapter)element;
            return adapter.getChildren(null);
        }
        if (element instanceof ServerElementAdapter) {
            ServerElementAdapter adapter = (ServerElementAdapter)element;
            return adapter.getChildren();
        }
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter != null) {
            return adapter.getChildren(element);
        }
        return new Object[0];
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter != null) {
            return adapter.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        if (newViewer instanceof TreeViewer) {
            this.viewer = (TreeViewer)newViewer;
        }
    }

    private void addServerListener() {
    }

    private void addServerResourceListener() {
        this.listener = new LifecycleListener();
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.listener);
    }

    protected void handleServerModulesChanged(IServer server2) {
        if (this.viewer != null) {
            this.viewer.refresh((Object)new ServerElementAdapter(null, server2));
            IServer[] servers = ServerCore.getServers();
            if (servers != null) {
                int size = servers.length;
                int i = 0;
                while (i < size) {
                    if (server2.equals(servers[i])) {
                        this.viewer.refresh((Object)new ServerElementAdapter(null, servers[i]));
                    }
                    ++i;
                }
            }
        }
    }

    protected void handleServerResourceAdded(Object element) {
        if (this.viewer == null) {
            return;
        }
        ServerElementAdapter adapter = new ServerElementAdapter(null, element);
        adapter.setFlags((byte)1);
        if (element instanceof IServer) {
            this.viewer.add((Object)new TextResourceAdapter(null, 0), (Object)adapter);
        }
    }

    protected void handleServerResourceChanged(Object element) {
        if (this.viewer == null) {
            return;
        }
        if (element instanceof IServer) {
            ServerElementAdapter adapter = new ServerElementAdapter(null, element);
            adapter.setFlags((byte)1);
            this.viewer.refresh((Object)adapter);
        }
    }

    protected void handleServerResourceRemoved(Object element) {
        if (this.viewer == null) {
            return;
        }
        TextResourceAdapter.deleted = element;
        if (element instanceof IServer) {
            TextResourceAdapter adapter = new TextResourceAdapter(null, 0);
            this.viewer.refresh((Object)adapter);
        }
    }

    class LifecycleListener
    implements IServerLifecycleListener {
        LifecycleListener() {
        }

        public void serverAdded(IServer server) {
            Display.getDefault().syncExec(new Runnable(this, server){
                final /* synthetic */ LifecycleListener this$1;
                private final /* synthetic */ IServer val$server;
                {
                    this.this$1 = lifecycleListener;
                    this.val$server = iServer;
                }

                public void run() {
                    LifecycleListener.access$0(this.this$1).handleServerResourceAdded(this.val$server);
                }
            });
        }

        public void serverRemoved(IServer server) {
            Display.getDefault().syncExec(new Runnable(this, server){
                final /* synthetic */ LifecycleListener this$1;
                private final /* synthetic */ IServer val$server;
                {
                    this.this$1 = lifecycleListener;
                    this.val$server = iServer;
                }

                public void run() {
                    LifecycleListener.access$0(this.this$1).handleServerResourceRemoved(this.val$server);
                }
            });
        }

        public void serverChanged(IServer server) {
            Display.getDefault().syncExec(new Runnable(this, server){
                final /* synthetic */ LifecycleListener this$1;
                private final /* synthetic */ IServer val$server;
                {
                    this.this$1 = lifecycleListener;
                    this.val$server = iServer;
                }

                public void run() {
                    LifecycleListener.access$0(this.this$1).handleServerResourceChanged(this.val$server);
                }
            });
        }

        static /* synthetic */ ServerTreeContentProvider access$0(LifecycleListener lifecycleListener) {
            return lifecycleListener.ServerTreeContentProvider.this;
        }
    }
}

