/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.editor.IOrdered;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorActionFactory;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPageSectionFactory;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPartFactory;

public class ServerEditorCore {
    private static List editorPageFactories;
    private static List editorPageSectionFactories;
    private static List editorActionFactories;

    public static List getServerEditorPageFactories() {
        if (editorPageFactories == null) {
            ServerEditorCore.loadEditorPageFactories();
        }
        return editorPageFactories;
    }

    public static List getServerEditorPageSectionFactories() {
        if (editorPageSectionFactories == null) {
            ServerEditorCore.loadEditorPageSectionFactories();
        }
        return editorPageSectionFactories;
    }

    private static void loadEditorPageFactories() {
        Trace.trace(Trace.CONFIG, "->- Loading .editorPages extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.ui", "editorPages");
        int size = cf.length;
        editorPageFactories = new ArrayList(size);
        int i = 0;
        while (i < size) {
            try {
                editorPageFactories.add(new ServerEditorPartFactory(cf[i]));
                Trace.trace(Trace.CONFIG, "  Loaded editorPage: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load editorPage: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        ServerEditorCore.sortOrderedList(editorPageFactories);
        Trace.trace(Trace.CONFIG, "-<- Done loading .editorPages extension point -<-");
    }

    private static void loadEditorPageSectionFactories() {
        Trace.trace(Trace.CONFIG, "->- Loading .editorPageSections extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.ui", "editorPageSections");
        int size = cf.length;
        editorPageSectionFactories = new ArrayList(size);
        int i = 0;
        while (i < size) {
            try {
                editorPageSectionFactories.add(new ServerEditorPageSectionFactory(cf[i]));
                Trace.trace(Trace.CONFIG, "  Loaded editorPageSection: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load editorPageSection: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        ServerEditorCore.sortOrderedList(editorPageSectionFactories);
        Trace.trace(Trace.CONFIG, "-<- Done loading .editorPageSections extension point -<-");
    }

    public static List getServerEditorActionFactories() {
        if (editorActionFactories == null) {
            ServerEditorCore.loadEditorActionFactories();
        }
        return editorActionFactories;
    }

    private static void loadEditorActionFactories() {
        Trace.trace(Trace.CONFIG, "->- Loading .editorActions extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.ui", "editorActions");
        int size = cf.length;
        editorActionFactories = new ArrayList(size);
        int i = 0;
        while (i < size) {
            try {
                editorActionFactories.add(new ServerEditorActionFactory(cf[i]));
                Trace.trace(Trace.CONFIG, "  Loaded editorAction: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load editorAction: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        ServerEditorCore.sortOrderedList(editorActionFactories);
        Trace.trace(Trace.CONFIG, "-<- Done loading .editorActions extension point -<-");
    }

    public static List sortOrderedList(List list) {
        if (list == null) {
            return null;
        }
        int size = list.size();
        int i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                IOrdered a = (IOrdered)list.get(i);
                IOrdered b = (IOrdered)list.get(j);
                if (a.getOrder() > b.getOrder()) {
                    IOrdered temp = a;
                    list.set(i, b);
                    list.set(j, temp);
                }
                ++j;
            }
            ++i;
        }
        return list;
    }
}

