/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal;

import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.openon.OpenOnAction;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.provisional.StructuredTextEditorXML;
import org.eclipse.wst.xsd.ui.internal.XSDContentOutlinePage;
import org.eclipse.wst.xsd.ui.internal.XSDEditor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.XSDSelectionManager;
import org.eclipse.wst.xsd.ui.internal.properties.section.XSDTabbedPropertySheetPage;
import org.eclipse.wst.xsd.ui.internal.provider.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.provider.XSDAdapterFactoryLabelProvider;
import org.eclipse.wst.xsd.ui.internal.provider.XSDContentProvider;
import org.eclipse.wst.xsd.ui.internal.provider.XSDModelAdapterFactoryImpl;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.RefactorActionGroup;
import org.eclipse.wst.xsd.ui.internal.util.SelectionAdapter;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.osgi.framework.Bundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDTextEditor
extends StructuredTextEditorXML
implements INodeSelectionListener,
ISelectionChangedListener {
    protected XSDSelectionManager xsdSelectionManager;
    protected XSDModelAdapterFactoryImpl xsdModelAdapterFactory;
    protected static XSDAdapterFactoryLabelProvider adapterFactoryLabelProvider;
    protected InternalSelectionProvider internalSelectionProvider = new InternalSelectionProvider();
    protected XSDContentOutlinePage outlinePage;
    protected Composite client;
    protected IFile file;
    protected WrappedOpenFileAction wrappedAction;
    private static final String DOT = ".";
    private ActionGroup fRefactorMenuGroup;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public XSDTextEditor(XSDEditor xsdEditor) {
        this.xsdSelectionManager = xsdEditor.getSelectionManager();
        this.xsdSelectionManager.addSelectionChangedListener(this);
        this.setHelpContextId("org.eclipse.wst.xsd.ui.internal.xsde4000");
        this.xsdModelAdapterFactory = XSDModelAdapterFactoryImpl.getInstance();
        adapterFactoryLabelProvider = new XSDAdapterFactoryLabelProvider(this.xsdModelAdapterFactory);
    }

    public void dispose() {
        super.dispose();
        this.xsdSelectionManager.removeSelectionChangedListener(this);
    }

    public XSDModelAdapterFactoryImpl getXSDModelAdapterFactory() {
        return this.xsdModelAdapterFactory;
    }

    public static XSDAdapterFactoryLabelProvider getLabelProvider() {
        return adapterFactoryLabelProvider;
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            this.fPropertySheetPage = new XSDTabbedPropertySheetPage(this.getXSDEditor());
            ((XSDTabbedPropertySheetPage)this.fPropertySheetPage).setXSDModelAdapterFactory(this.xsdModelAdapterFactory);
            ((XSDTabbedPropertySheetPage)this.fPropertySheetPage).setSelectionManager(this.getXSDEditor().getSelectionManager());
            ((XSDTabbedPropertySheetPage)this.fPropertySheetPage).setXSDSchema(this.getXSDSchema());
            return this.fPropertySheetPage;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            if (this.fOutlinePage == null || this.fOutlinePage.getControl() == null || this.fOutlinePage.getControl().isDisposed()) {
                XSDContentOutlinePage outlinePage = new XSDContentOutlinePage(this);
                XSDContentProvider xsdContentProvider = new XSDContentProvider(this.xsdModelAdapterFactory);
                xsdContentProvider.setXSDSchema(this.getXSDSchema());
                outlinePage.setContentProvider(xsdContentProvider);
                outlinePage.setLabelProvider(adapterFactoryLabelProvider);
                outlinePage.setModel(this.getXSDSchema().getDocument());
                this.getViewerSelectionManager().addNodeSelectionListener((INodeSelectionListener)this);
                this.internalSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.getViewerSelectionManager());
                this.internalSelectionProvider.setEventSource((ISelectionProvider)outlinePage);
                this.fOutlinePage = outlinePage;
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(required);
    }

    public IContentOutlinePage getContentOutlinePage() {
        return this.fOutlinePage;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.internalSelectionProvider.setSelection(event.getSelection());
    }

    public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
        if (!event.getSource().equals(this.internalSelectionProvider) && this.getXSDEditor().getActiveEditorPage() != null) {
            XSDConcreteComponent modelObject;
            Object element = null;
            List list = event.getSelectedNodes();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                if (node == null) continue;
                if (node.getNodeType() == 1) {
                    element = (Element)node;
                    break;
                }
                if (node.getNodeType() != 2) continue;
                element = ((Attr)node).getOwnerElement();
                break;
            }
            XSDConcreteComponent o = element;
            if (element != null && (modelObject = this.getXSDSchema().getCorrespondingComponent(element)) != null) {
                o = modelObject;
            }
            if (o != null) {
                this.xsdSelectionManager.setSelection((ISelection)new StructuredSelection(o), this.internalSelectionProvider);
            } else {
                this.xsdSelectionManager.setSelection((ISelection)new StructuredSelection(), this.internalSelectionProvider);
            }
        }
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
    }

    public void update() {
        super.update();
        if (this.outlinePage != null) {
            this.outlinePage.setModel(this.getModel());
        }
    }

    protected void addOpenOnSelectionListener() {
        this.getTextViewer().getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                if (arg0.keyCode == 0x100000C) {
                    XSDTextEditor.this.getXSDEditor().getOpenOnSelectionHelper().openOnSelection();
                }
            }
        });
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        StructuredTextViewer sourceViewer = this.createStructedTextViewer(parent, verticalRuler, styles);
        this.initSourceViewer(sourceViewer);
        return sourceViewer;
    }

    public void setModel(IFileEditorInput input) {
        super.setModel(input);
        this.file = input.getFile();
    }

    public XSDSchema getXSDSchema() {
        return ((XSDEditor)this.getEditorPart()).getXSDSchema();
    }

    public XSDEditor getXSDEditor() {
        return (XSDEditor)this.getEditorPart();
    }

    public void safelySanityCheckState(IEditorInput input) {
        super.safelySanityCheckState(input);
    }

    protected void createActions() {
        super.createActions();
        this.addOpenOnSelectionListener();
        ResourceBundle resourceBundle = Platform.getResourceBundle((Bundle)XSDEditorPlugin.getPlugin().getBundle());
        this.wrappedAction = new WrappedOpenFileAction(resourceBundle, "OpenFileFromSource.", (ITextEditor)this);
        this.setAction("OpenFileFromSource", (IAction)this.wrappedAction);
        this.fRefactorMenuGroup = new RefactorActionGroup(this.getXSDEditor().getSelectionManager(), this.getXSDSchema(), "group.edit");
    }

    protected void addContextMenuActions(IMenuManager menu) {
        super.addContextMenuActions(menu);
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.fRefactorMenuGroup.setContext(context);
        this.fRefactorMenuGroup.fillContextMenu(menu);
        this.fRefactorMenuGroup.setContext(null);
    }

    class InternalSelectionProvider
    extends SelectionAdapter {
        InternalSelectionProvider() {
        }

        protected Object getObjectForOtherModel(Object object) {
            Node node = null;
            if (object instanceof Node) {
                node = (Node)object;
            } else if (object instanceof XSDComponent) {
                node = ((XSDComponent)object).getElement();
            } else if (object instanceof CategoryAdapter) {
                node = ((CategoryAdapter)object).getXSDSchema().getElement();
            }
            if (!(node instanceof IDOMNode)) {
                node = null;
            }
            return node;
        }
    }

    protected class WrappedOpenFileAction
    extends OpenOnAction {
        public WrappedOpenFileAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void run() {
            if (!XSDTextEditor.this.getXSDEditor().getOpenOnSelectionHelper().openOnSelection()) {
                super.run();
            }
        }
    }
}

