/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.dialogs.types.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.common.IComponentList;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.common.IComponentSelectionProvider;

public class ComponentSelectionDialog
extends Dialog {
    private Display display = Display.getCurrent();
    private String dialogTitle;
    protected IComponentSelectionProvider provider;
    private List componentTreeViewerInput;
    private List masterComponentList;
    protected Composite topComposite;
    protected Composite bottomComposite;
    private String filterTextLabel = "";
    private String componentListLabel = XSDEditorPlugin.getXSDString("_UI_LABEL_COMPONENTS");
    private Text textFilter;
    protected TreeViewer componentTreeViewer;
    private org.eclipse.swt.widgets.List qualifierList;
    protected Object componentSelection;
    protected Object qualifierTextSelection;
    private DelayedEvent delayedEvent;

    public ComponentSelectionDialog(Shell shell, String dialogTitle, IComponentSelectionProvider provider) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.dialogTitle = dialogTitle;
        this.provider = provider;
        this.componentTreeViewerInput = new ArrayList();
        this.masterComponentList = new ArrayList();
    }

    public void setComponentTreeLabel(String string) {
        this.componentListLabel = string;
    }

    public void setFilterLabel(String string) {
        this.filterTextLabel = string;
    }

    public void create() {
        super.create();
        this.setTextFilterFocus();
    }

    protected void setTextFilterFocus() {
        this.textFilter.setFocus();
    }

    public Control createDialogArea(Composite parent) {
        this.getShell().setText(this.dialogTitle);
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        GridData gData = (GridData)mainComposite.getLayoutData();
        gData.heightHint = 500;
        gData.widthHint = 400;
        Composite filterLabelAndTree = new Composite(mainComposite, 0);
        new GridData(1808);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        filterLabelAndTree.setLayoutData((Object)new GridData(1808));
        filterLabelAndTree.setLayout((Layout)layout);
        Label filterLabel = new Label(filterLabelAndTree, 0);
        filterLabel.setText(this.filterTextLabel);
        this.textFilter = new Text(filterLabelAndTree, 2052);
        this.textFilter.setLayoutData((Object)new GridData(768));
        this.textFilter.addModifyListener((ModifyListener)new TextFilterModifyAdapter());
        GridData textFilterData = new GridData();
        textFilterData.horizontalAlignment = 4;
        textFilterData.grabExcessHorizontalSpace = true;
        this.textFilter.setLayoutData((Object)textFilterData);
        this.createComponentTreeViewer(filterLabelAndTree);
        Label qualifierLabel = new Label(mainComposite, 0);
        qualifierLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_QUALIFIER"));
        this.qualifierList = new org.eclipse.swt.widgets.List(mainComposite, 2052);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 45;
        this.qualifierList.setLayoutData((Object)data);
        this.bottomComposite = new Composite(mainComposite, 0);
        this.bottomComposite.setLayoutData((Object)new GridData(768));
        this.bottomComposite.setLayout((Layout)new GridLayout());
        this.componentTreeViewer.setContentProvider((IContentProvider)new ComponentTreeContentProvider());
        this.componentTreeViewer.setLabelProvider((IBaseLabelProvider)this.provider.getLabelProvider());
        this.componentTreeViewer.setSorter(new ViewerSorter());
        this.componentTreeViewer.setInput((Object)this.componentTreeViewerInput);
        this.populateMasterComponentList();
        this.refreshTreeViewer("");
        return mainComposite;
    }

    protected TreeViewer createTreeViewer(Composite comp, String title) {
        Label label = new Label(comp, 0);
        label.setText(title);
        TreeViewer treeViewer = new TreeViewer(new Tree(comp, 2052));
        Tree treeWidget = treeViewer.getTree();
        GridData gd = new GridData(1808);
        treeWidget.setLayoutData((Object)gd);
        return treeViewer;
    }

    private void createComponentTreeViewer(Composite base) {
        this.componentTreeViewer = this.createTreeViewer(base, this.componentListLabel);
        this.componentTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
                List qualifiers = ComponentSelectionDialog.this.provider.getQualifiers(structuredSelection.getFirstElement());
                ComponentSelectionDialog.this.updateQualifierList(qualifiers);
                ComponentSelectionDialog.this.updateCanFinish();
            }
        });
    }

    private void updateQualifierList(List qualifiers) {
        this.qualifierList.removeAll();
        Iterator it = qualifiers.iterator();
        while (it.hasNext()) {
            this.qualifierList.add(it.next().toString());
        }
    }

    protected String getProcessedFilterString() {
        return this.processFilterString(this.textFilter.getText());
    }

    private String processFilterString(String inputString) {
        if (!inputString.equals("")) {
            inputString = this.insertString("*", ".", inputString);
            inputString = this.insertString("?", ".", inputString);
            inputString = String.valueOf(inputString) + ".*";
        } else {
            inputString = ".*";
        }
        return inputString.toLowerCase();
    }

    private String insertString(String target, String newString, String string) {
        new ArrayList();
        StringBuffer stringBuffer = new StringBuffer(string);
        int index = stringBuffer.indexOf(target);
        while (index != -1) {
            stringBuffer = stringBuffer.insert(index, newString);
            index = stringBuffer.indexOf(target, index + newString.length() + target.length());
        }
        return stringBuffer.toString();
    }

    protected void fireUpdateList(final ComponentList list) {
        Runnable runnable = new Runnable(){

            public void run() {
                int currentSize;
                int growingListSize = list.size();
                if (growingListSize > (currentSize = ComponentSelectionDialog.this.masterComponentList.size())) {
                    ComponentSelectionDialog.this.masterComponentList.addAll(list.subList(currentSize, growingListSize));
                }
                ComponentSelectionDialog.this.refreshTreeViewer(ComponentSelectionDialog.this.getProcessedFilterString());
            }
        };
        this.display.asyncExec(runnable);
    }

    protected void populateMasterComponentList() {
        this.masterComponentList.clear();
        this.provider.getLabelProvider();
        final ComponentList componentList = new ComponentList();
        this.provider.getComponents(componentList, true);
        Job job = new Job("read components"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ComponentSelectionDialog.this.provider.getComponents(componentList, false);
                    ComponentSelectionDialog.this.fireUpdateList(componentList);
                }
                catch (Exception exception) {}
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected void refreshTreeViewer(String filterText) {
        this.componentTreeViewerInput.clear();
        ILabelProvider labelProvider = this.provider.getLabelProvider();
        Pattern regex = Pattern.compile(filterText);
        Iterator it = this.masterComponentList.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            String itemString = labelProvider.getText(item);
            Matcher m = regex.matcher(itemString.toLowerCase());
            if (!itemString.toLowerCase().startsWith(filterText) && !m.matches()) continue;
            this.componentTreeViewerInput.add(item);
        }
        this.componentTreeViewer.refresh();
    }

    protected void updateCanFinish() {
        IStructuredSelection selection = (IStructuredSelection)this.componentTreeViewer.getSelection();
        if (selection.getFirstElement() != null) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.componentTreeViewer.getSelection();
        this.componentSelection = selection.getFirstElement();
        int qualifierIndex = this.qualifierList.getSelectionIndex();
        if (qualifierIndex < 0) {
            qualifierIndex = 0;
        }
        this.qualifierTextSelection = this.qualifierList.getItem(qualifierIndex);
        super.okPressed();
    }

    private class TextFilterModifyAdapter
    implements ModifyListener {
        TextFilterModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == ComponentSelectionDialog.this.textFilter) {
                if (ComponentSelectionDialog.this.delayedEvent != null) {
                    ((ComponentSelectionDialog)ComponentSelectionDialog.this).delayedEvent.CANCEL = true;
                }
                ComponentSelectionDialog.this.delayedEvent = new DelayedEvent();
                Display.getCurrent().timerExec(400, (Runnable)ComponentSelectionDialog.this.delayedEvent);
            }
        }
    }

    private class DelayedEvent
    implements Runnable {
        public boolean CANCEL = false;

        DelayedEvent() {
        }

        public void run() {
            if (!this.CANCEL) {
                ComponentSelectionDialog.this.refreshTreeViewer(ComponentSelectionDialog.this.getProcessedFilterString());
                if (ComponentSelectionDialog.this.componentTreeViewer.getTree().getItemCount() > 0) {
                    TreeItem item = ComponentSelectionDialog.this.componentTreeViewer.getTree().getItems()[0];
                    TreeItem[] items = new TreeItem[]{item};
                    ComponentSelectionDialog.this.componentTreeViewer.getTree().setSelection(items);
                }
                IStructuredSelection structuredSelection = (IStructuredSelection)ComponentSelectionDialog.this.componentTreeViewer.getSelection();
                List qualifiers = ComponentSelectionDialog.this.provider.getQualifiers(structuredSelection.getFirstElement());
                ComponentSelectionDialog.this.updateQualifierList(qualifiers);
                ComponentSelectionDialog.this.updateCanFinish();
            }
        }
    }

    class ComponentList
    implements IComponentList {
        private Vector objectVector = new Vector();
        private long currentChangeCounter = 0L;

        ComponentList() {
        }

        public void addComponent(Object o) {
            this.objectVector.add(o);
            ++this.currentChangeCounter;
            this.doViewerUpdate();
        }

        private void doViewerUpdate() {
            if (this.currentChangeCounter == 10L) {
                this.currentChangeCounter = 0L;
                ComponentSelectionDialog.this.fireUpdateList(this);
            }
        }

        public int size() {
            return this.objectVector.size();
        }

        public List subList(int startIndex, int endIndex) {
            return this.objectVector.subList(startIndex, endIndex);
        }

        public Iterator iterator() {
            return this.objectVector.iterator();
        }
    }

    private class ComponentTreeContentProvider
    implements ITreeContentProvider {
        ComponentTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                return ((List)parentElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

