/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.dialogs.types.xml;

import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.common.ComponentSelectionDialog;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.common.IComponentSelectionProvider;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xml.XMLComponentSelectionProvider;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xml.XMLComponentSpecification;

public class XMLComponentSelectionDialog
extends ComponentSelectionDialog {
    protected static final String DEFAULT_NAME_FIELD_TITLE = XSDEditorPlugin.getXSDString("_UI_LABEL_COMPONENT_NAME");
    protected static final String DEFAULT_LIST_TITLE = XSDEditorPlugin.getXSDString("_UI_LABEL_MATCHING_COMPONENTS");
    public static final String SCOPE_SPECIFIED_FILE = XSDEditorPlugin.getXSDString("_UI_LABEL_SPECIFIED_FILE");
    public static final String SCOPE_ENCLOSING_PROJECT = XSDEditorPlugin.getXSDString("_UI_LABEL_ENCLOSING_PROJECT");
    public static final String SCOPE_WORKSPACE = XSDEditorPlugin.getXSDString("_UI_LABEL_WORKSPACE");
    public static final String SCOPE_CURRENT_RESOURCE = XSDEditorPlugin.getXSDString("_UI_LABEL_CURRENT_RESOURCE");
    private String currentSearchScope = SCOPE_CURRENT_RESOURCE;
    protected Button chooseButton;
    protected Button[] radioButton = new Button[3];

    public XMLComponentSelectionDialog(Shell shell, String dialogTitle, IComponentSelectionProvider provider) {
        super(shell, dialogTitle, provider);
    }

    public Control createDialogArea(Composite parent) {
        this.setFilterLabel(this.provider.getNameFieldTitle() != null ? this.provider.getNameFieldTitle() : DEFAULT_NAME_FIELD_TITLE);
        this.setComponentTreeLabel(this.provider.getListTitle() != null ? this.provider.getListTitle() : DEFAULT_LIST_TITLE);
        super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.bottomComposite.setLayout((Layout)layout);
        Group group = new Group(this.bottomComposite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_SEARCH_SCOPE"));
        ScopeChangeListener scopeChangeListener = new ScopeChangeListener();
        this.radioButton[0] = new Button((Composite)group, 16);
        this.radioButton[0].setText(SCOPE_WORKSPACE);
        this.radioButton[1] = new Button((Composite)group, 16);
        this.radioButton[1].setText(SCOPE_ENCLOSING_PROJECT);
        this.radioButton[2] = new Button((Composite)group, 16);
        this.radioButton[2].setText(SCOPE_CURRENT_RESOURCE);
        int i = 0;
        while (i < this.radioButton.length) {
            if (this.radioButton[i].getText().equals(this.currentSearchScope)) {
                this.radioButton[i].setSelection(true);
            }
            this.radioButton[i].addSelectionListener((SelectionListener)scopeChangeListener);
            ++i;
        }
        Button check = new Button((Composite)group, 32);
        check.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_NARROW_SEARCH_SCOPE_RESOURCE"));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        check.setLayoutData((Object)gd);
        check.setEnabled(false);
        return parent;
    }

    public String getSearchScope() {
        return this.currentSearchScope;
    }

    public XMLComponentSpecification getSelection() {
        XMLComponentSelectionProvider.XMLComponentTreeObject treeObject = (XMLComponentSelectionProvider.XMLComponentTreeObject)this.componentSelection;
        List specs = treeObject.getXMLComponentSpecification();
        int matchingIndex = 0;
        int index = 0;
        while (index < specs.size()) {
            XMLComponentSpecification spec = (XMLComponentSpecification)specs.get(index);
            Path path = new Path(spec.getFileLocation());
            String specText = String.valueOf(spec.getTargetNamespace()) + " - " + path.lastSegment();
            if (specText.equals(this.qualifierTextSelection)) {
                matchingIndex = index;
                break;
            }
            ++index;
        }
        return (XMLComponentSpecification)specs.get(matchingIndex);
    }

    private class ScopeChangeListener
    extends SelectionAdapter {
        ScopeChangeListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button b;
            if (e.widget instanceof Button && ((b = (Button)e.widget).getStyle() & 0x10) != 0) {
                XMLComponentSelectionDialog.this.currentSearchScope = b.getText();
                XMLComponentSelectionDialog.this.populateMasterComponentList();
                XMLComponentSelectionDialog.this.refreshTreeViewer(XMLComponentSelectionDialog.this.getProcessedFilterString());
                Tree tree = XMLComponentSelectionDialog.this.componentTreeViewer.getTree();
                TreeItem[] items = tree.getItems();
                if (items.length > 0) {
                    TreeItem[] select = new TreeItem[]{items[0]};
                    tree.setSelection(select);
                }
                XMLComponentSelectionDialog.this.updateCanFinish();
            }
        }
    }
}

