/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.figures;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.GraphNodeEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.figures.GraphNodeFigure;

public class ConnectionFigure
extends RectangleFigure {
    protected boolean isOutlined = true;
    protected IFigure xsdFigure;

    public ConnectionFigure(IFigure xsdFigure) {
        this.setOpaque(false);
        this.xsdFigure = xsdFigure;
    }

    protected boolean isMouseEventTarget() {
        return false;
    }

    public boolean containsPoint(int x, int y) {
        return false;
    }

    protected void fillShape(Graphics graphics) {
        graphics.setForegroundColor(ColorConstants.black);
        this.drawLines(graphics, this.xsdFigure);
    }

    protected void drawLines(Graphics graphics, IFigure figure) {
        List childList;
        GraphNodeFigure graphNodeFigure;
        if (figure instanceof GraphNodeFigure && (graphNodeFigure = (GraphNodeFigure)figure).isConnected() && graphNodeFigure.isExpanded() && (childList = graphNodeFigure.getChildGraphNodeFigures()).size() > 0) {
            Rectangle r = graphNodeFigure.getConnectionRectangle();
            int x1 = r.x + r.width;
            int y1 = r.y + r.height / 2;
            int startOfChildBox = ((GraphNodeFigure)((Object)childList.get((int)0))).getConnectionRectangle().x;
            int x2 = x1 + (startOfChildBox - x1) / 3;
            int y2 = y1;
            if (childList.size() > 1) {
                graphics.drawLine(x1, y1, x2, y2);
                int minY = Integer.MAX_VALUE;
                int maxY = -1;
                Iterator i = childList.iterator();
                while (i.hasNext()) {
                    GraphNodeFigure childGraphNodeFigure = (GraphNodeFigure)((Object)i.next());
                    Rectangle childConnectionRectangle = childGraphNodeFigure.getConnectionRectangle();
                    int y = childConnectionRectangle.y + childConnectionRectangle.height / 2;
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                    graphics.drawLine(x2, y, childConnectionRectangle.x, y);
                }
                graphics.drawLine(x2, minY, x2, maxY);
            } else {
                graphics.drawLine(x1, y1, startOfChildBox, y2);
            }
        }
        List children = figure.getChildren();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            IFigure child = (IFigure)i.next();
            this.drawLines(graphics, child);
        }
    }

    public PointList getConnectionPoints(GraphNodeEditPart parentEditPart, GraphNodeEditPart childRefEditPart, Rectangle draggedFigureBounds) {
        PointList pointList = new PointList();
        int[] data = new int[1];
        Point a = this.getConnectionPoint(parentEditPart, childRefEditPart, data);
        if (a != null) {
            int draggedFigureBoundsY = draggedFigureBounds.y + draggedFigureBounds.height / 2;
            pointList.addPoint(a);
            if (data[0] == 0) {
                int x = a.x + (draggedFigureBounds.x - a.x) / 2;
                pointList.addPoint(new Point(x, a.y));
                pointList.addPoint(new Point(x, draggedFigureBoundsY));
                pointList.addPoint(new Point(draggedFigureBounds.x, draggedFigureBoundsY));
            } else {
                pointList.addPoint(new Point(a.x, draggedFigureBoundsY));
                pointList.addPoint(new Point(draggedFigureBounds.x, draggedFigureBoundsY));
            }
        }
        return pointList;
    }

    protected Point getConnectionPoint(GraphNodeEditPart parentEditPart, GraphNodeEditPart childRefEditPart, int[] data) {
        Point point = null;
        List childList = parentEditPart.getChildren();
        if (childList.size() > 0) {
            point = new Point();
            GraphNodeEditPart prev = null;
            GraphNodeEditPart next = null;
            Iterator i = childList.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof GraphNodeEditPart)) continue;
                GraphNodeEditPart childEditPart = (GraphNodeEditPart)o;
                if (childEditPart == childRefEditPart) {
                    next = childEditPart;
                    break;
                }
                prev = childEditPart;
            }
            if (next != null && prev != null) {
                int ya = prev.getConnectionRectangle().getCenter().y;
                int yb = next.getConnectionRectangle().getCenter().y;
                point.y = ya + (yb - ya) / 2;
                data[0] = 0;
            } else if (prev != null) {
                point.y = prev.getConnectionRectangle().getCenter().y;
                data[0] = 1;
            } else if (next != null) {
                point.y = next.getConnectionRectangle().getCenter().y;
                data[0] = -1;
            }
            if (next != null || prev != null) {
                GraphNodeEditPart child = prev != null ? prev : next;
                int startOfChildBox = child.getConnectionRectangle().x;
                Rectangle r = parentEditPart.getConnectionRectangle();
                int x1 = r.x + r.width;
                point.x = x1 + (startOfChildBox - x1) / 3;
            }
        }
        return point;
    }

    protected void outlineShape(Graphics graphics) {
        if (this.isOutlined) {
            super.outlineShape(graphics);
        }
    }
}

