/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.figures;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.SpacingFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.FloatableFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.GraphNodeContainerFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.GraphNodeFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.PostLayoutManager;

public class ContainerLayout
extends AbstractLayout
implements PostLayoutManager {
    protected boolean isHorizontal;
    protected int spacing = 0;
    protected int border = 0;

    public ContainerLayout() {
        this(true, 0);
    }

    public ContainerLayout(boolean isHorizontal, int spacing) {
        this.isHorizontal = isHorizontal;
        this.spacing = spacing;
    }

    public void setHorizontal(boolean isHorizontal) {
        this.isHorizontal = isHorizontal;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    protected Dimension calculatePreferredSize(IFigure parent, int w, int h) {
        GraphNodeContainerFigure graphNodeContainerFigure;
        Dimension preferred = null;
        if (parent instanceof GraphNodeContainerFigure && !(graphNodeContainerFigure = (GraphNodeContainerFigure)parent).isExpanded()) {
            preferred = new Dimension();
        }
        if (preferred == null) {
            preferred = new Dimension();
            List children = parent.getChildren();
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                Dimension childSize = child.getPreferredSize();
                if (this.isHorizontal) {
                    preferred.width += childSize.width;
                    preferred.height = Math.max(preferred.height, childSize.height);
                } else {
                    preferred.height += childSize.height;
                    preferred.width = Math.max(preferred.width, childSize.width);
                }
                ++i;
            }
            int childrenSize = children.size();
            if (childrenSize > 1) {
                if (this.isHorizontal) {
                    preferred.width += this.spacing * (childrenSize - 1);
                } else {
                    preferred.height += this.spacing * (childrenSize - 1);
                }
            }
            preferred.width += this.border * 2;
            preferred.height += this.border * 2;
            preferred.width += parent.getInsets().getWidth();
            preferred.height += parent.getInsets().getHeight();
        }
        return preferred;
    }

    protected int alignFigure(IFigure parent, IFigure child) {
        int y = -1;
        return y;
    }

    public void layout(IFigure parent) {
        List children = parent.getChildren();
        Dimension preferred = new Dimension();
        int rx = 0;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = child.getPreferredSize();
            if (this.isHorizontal) {
                preferred.height = Math.max(preferred.height, childSize.height);
                rx += childSize.width;
            } else {
                preferred.width = Math.max(preferred.width, childSize.width);
            }
            ++i;
        }
        if (this.isHorizontal) {
            preferred.height += this.border * 2;
            preferred.width += this.border;
        } else {
            preferred.width += this.border * 2;
            preferred.height += this.border;
        }
        int childrenSize = children.size();
        int i2 = 0;
        while (i2 < childrenSize) {
            IFigure child = (IFigure)children.get(i2);
            Dimension childSize = child.getPreferredSize();
            if (this.isHorizontal) {
                int y = this.alignFigure(parent, child);
                if (y == -1) {
                    y = (preferred.height - childSize.height) / 2;
                }
                Rectangle rectangle = new Rectangle(preferred.width, y, childSize.width, childSize.height);
                rectangle.translate(parent.getClientArea().getLocation());
                child.setBounds(rectangle);
                preferred.width += childSize.width;
                preferred.width += this.spacing;
                if (child instanceof SpacingFigure) {
                    int availableHorizontalSpace = parent.getClientArea().width - rx;
                    preferred.width += availableHorizontalSpace;
                }
            } else {
                Rectangle rectangle = new Rectangle(0, preferred.height, childSize.width, childSize.height);
                rectangle.translate(parent.getClientArea().getLocation());
                child.setBounds(rectangle);
                preferred.height += childSize.height;
                preferred.height += this.spacing;
            }
            ++i2;
        }
    }

    public void postLayout(IFigure figure) {
        Iterator i = figure.getChildren().iterator();
        while (i.hasNext()) {
            FloatableFigure floatableFigure;
            GraphNodeFigure graphNodeFigure;
            IFigure child = (IFigure)i.next();
            if (!(child instanceof FloatableFigure) || !(graphNodeFigure = (floatableFigure = (FloatableFigure)child).getGraphNodeFigure()).isExpanded() || graphNodeFigure.getChildGraphNodeFigures().size() != 1) continue;
            GraphNodeFigure alignedChild = (GraphNodeFigure)((Object)graphNodeFigure.getChildGraphNodeFigures().get(0));
            Rectangle alignedChildBounds = alignedChild.getConnectionRectangle();
            Rectangle childBounds = child.getBounds();
            int l = childBounds.y + childBounds.height / 2;
            int r = alignedChildBounds.y + alignedChildBounds.height / 2;
            int delta = r - l;
            this.fixUp(child, delta);
        }
    }

    protected void fixUp(IFigure figure, int delta) {
        Rectangle bounds = figure.getBounds();
        bounds.y += delta;
        figure.setBounds(bounds);
        Iterator i = figure.getChildren().iterator();
        while (i.hasNext()) {
            IFigure child = (IFigure)i.next();
            this.fixUp(child, delta);
        }
    }
}

