/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.actions.SetBaseTypeAction;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.XSDComboBoxPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.GlobalSimpleOrComplexTypeRenamer;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComplexTypePropertySource
extends BasePropertySource
implements IPropertySource {
    private String DERIVED_BY_ID = "derived by";
    private String BASE_TYPE_ID = "base type";
    private String[] blockOrFinalComboValues = new String[]{"", "#all", "extension", "restriction"};
    private String[] derivedByChoicesComboValues = new String[]{"", "restriction", "extension"};

    public ComplexTypePropertySource() {
    }

    public ComplexTypePropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public ComplexTypePropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<XSDComboBoxPropertyDescriptor> list = new ArrayList<XSDComboBoxPropertyDescriptor>();
        this.checkForAnonymousType(this.element);
        this.getDomHelper().getContentModelFromParent(this.element);
        XSDComboBoxPropertyDescriptor abstractDescriptor = new XSDComboBoxPropertyDescriptor("abstract", "abstract", this.trueFalseComboValues);
        list.add(abstractDescriptor);
        XSDComboBoxPropertyDescriptor mixedDescriptor = new XSDComboBoxPropertyDescriptor("mixed", "mixed", this.trueFalseComboValues);
        list.add(mixedDescriptor);
        XSDComboBoxPropertyDescriptor blockDescriptor = new XSDComboBoxPropertyDescriptor("block", "block", this.blockOrFinalComboValues);
        list.add(blockDescriptor);
        XSDComboBoxPropertyDescriptor finalDescriptor = new XSDComboBoxPropertyDescriptor("final", "final", this.blockOrFinalComboValues);
        list.add(finalDescriptor);
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public void setInput(Element element) {
        this.element = element;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            String attributeName = (String)id;
            result = this.element.getAttribute((String)id);
            Element contentModelElement = this.getDomHelper().getContentModelFromParent(this.element);
            String baseType = this.getDomHelper().getBaseType(contentModelElement);
            if (result == null) {
                result = "";
            }
            if (attributeName.equals(this.DERIVED_BY_ID)) {
                return this.getDomHelper().getDerivedByName(contentModelElement);
            }
            if (attributeName.equals(this.BASE_TYPE_ID)) {
                if (baseType != null) {
                    return baseType;
                }
                return "";
            }
            if (attributeName.equals("name")) {
                String name = this.element.getAttribute("name");
                boolean isAnonymousType = this.checkForAnonymousType(this.element);
                if (isAnonymousType) {
                    return "**anonymous**";
                }
                return name;
            }
            return result;
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof String) {
            String newValue = (String)value;
            String attributeName = (String)id;
            if (attributeName.equals("name")) {
                if (this.validateName(newValue)) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_COMPLEXTYPE_NAME_CHANGE"), this.element);
                    if (newValue.length() > 0) {
                        XSDConcreteComponent comp;
                        if (this.xsdSchema != null && (comp = this.xsdSchema.getCorrespondingComponent((Node)this.element)) != null && comp instanceof XSDComplexTypeDefinition && comp.getContainer().equals(this.xsdSchema)) {
                            GlobalSimpleOrComplexTypeRenamer renamer = new GlobalSimpleOrComplexTypeRenamer((XSDNamedComponent)comp, newValue);
                            renamer.visitSchema(this.xsdSchema);
                        }
                        this.element.setAttribute("name", newValue);
                    } else {
                        this.element.removeAttribute("name");
                    }
                    this.endRecording(this.element);
                }
            } else if (attributeName.equals(this.DERIVED_BY_ID)) {
                Element contentModelElement = this.getDomHelper().getContentModelFromParent(this.element);
                String baseType = this.getDomHelper().getBaseType(contentModelElement);
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_DERIVEDBY_CHANGE"), this.element);
                this.getDomHelper().getDerivedByElement(this.element);
                this.getDomHelper().changeDerivedByType(contentModelElement, newValue, baseType);
                this.endRecording(this.element);
            } else if (attributeName.equals(this.BASE_TYPE_ID)) {
                String derivedBy = this.getDomHelper().getDerivedByName(this.element);
                SetBaseTypeAction setBaseTypeAction = new SetBaseTypeAction(XSDEditorPlugin.getXSDString("_UI_LABEL_SET_BASE_TYPE"));
                setBaseTypeAction.setXSDSchema(this.xsdSchema);
                setBaseTypeAction.setComplexTypeElement(this.element);
                setBaseTypeAction.setType(newValue);
                setBaseTypeAction.setDerivedBy(derivedBy);
                setBaseTypeAction.performAction();
            } else {
                if (attributeName.equals("abstract")) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_COMPLEXTYPE_ABSTRACT_CHANGE"), this.element);
                } else if (attributeName.equals("mixed")) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_COMPLEXTYPE_MIXED_CHANGE"), this.element);
                } else if (attributeName.equals("block")) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_COMPLEXTYPE_BLOCK_CHANGE"), this.element);
                } else if (attributeName.equals("final")) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_COMPLEXTYPE_FINAL_CHANGE"), this.element);
                }
                if (newValue.length() > 0) {
                    this.element.setAttribute((String)id, (String)value);
                } else {
                    this.element.removeAttribute((String)id);
                }
                this.endRecording(this.element);
            }
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (ComplexTypePropertySource.this.viewer != null) {
                    ComplexTypePropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }

    boolean checkForAnonymousType(Element element) {
        Node parentElement = element.getParentNode();
        boolean isAnonymous = false;
        if (parentElement != null && XSDDOMHelper.inputEquals(parentElement, "element", false)) {
            isAnonymous = true;
        }
        return isAnonymous;
    }
}

