/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.ViewerSelectionManager;
import org.eclipse.wst.sse.ui.internal.properties.RemoveAction;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XSDPropertySheetPage
extends PropertySheetPage
implements ISelectionChangedListener,
INodeSelectionListener {
    IEditorPart editorPart;
    private ViewerSelectionManager fViewerSelectionManager;
    IStructuredModel model;
    protected RemoveAction fRemoveAction;
    Control designControl;

    public XSDPropertySheetPage(IStructuredModel model, IEditorPart editorPart) {
        this.model = model;
        this.editorPart = editorPart;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(null, event.getSelection());
    }

    public void setViewerSelectionManager(ViewerSelectionManager viewerSelectionManager) {
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.removeNodeSelectionListener((INodeSelectionListener)this);
        }
        this.fViewerSelectionManager = viewerSelectionManager;
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.addNodeSelectionListener((INodeSelectionListener)this);
        }
    }

    public void dispose() {
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.removeNodeSelectionListener((INodeSelectionListener)this);
        }
        super.dispose();
    }

    public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
        if (event.getSelectedNodes().size() > 1) {
            this.selectionChanged(null, (ISelection)StructuredSelection.EMPTY);
        } else if (event.getSelectedNodes().size() != 0) {
            Object item = event.getSelectedNodes().get(0);
            if (item instanceof Text) {
                Node parent = ((Text)item).getParentNode();
                this.selectionChanged(null, (ISelection)new StructuredSelection((Object)parent));
            } else {
                this.selectionChanged(null, (ISelection)new StructuredSelection(event.getSelectedNodes()));
            }
        }
    }

    private void setPropertiesTitle(PropertySheet thePart, String title) {
        Control control = thePart.getDefaultPage().getControl();
        Composite parent = control.getParent();
        while (parent != null) {
            Control[] children;
            if (parent instanceof ViewForm && (children = parent.getChildren()).length > 0 && children[0] instanceof CLabel) {
                CLabel clabel = (CLabel)children[0];
                clabel.setText(title);
            }
            parent = parent.getParent();
        }
    }
}

