/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.wst.xsd.ui.internal.properties.AnyAttributePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.AnyElementPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.AppInfoPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.AttributeGroupRefPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.AttributePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.ComplexTypePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.DocumentationPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.ElementPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.EnumerationPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.GroupRefPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.KeyrefPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.ModelGroupPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.NamePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.NotationPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.PatternPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.SchemaPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.SimpleContentPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.SimpleRestrictPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.SimpleTypeListPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.SimpleTypePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.SimpleTypeUnionPropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.XPathPropertySource;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDPropertySourceProvider
implements IPropertySourceProvider {
    XSDSchema xsdSchema;
    boolean showParent = false;

    public IPropertySource getPropertySource(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof XSDConcreteComponent) {
            Element input;
            BasePropertySource bps;
            XSDElementDeclaration elementDeclaration;
            XSDConcreteComponent component = (XSDConcreteComponent)object;
            this.xsdSchema = component.getSchema();
            if (component instanceof XSDElementDeclaration && (elementDeclaration = (XSDElementDeclaration)component).isElementDeclarationReference()) {
                component = elementDeclaration.getResolvedElementDeclaration();
            }
            if ((bps = (BasePropertySource)this.getXSDPropertySource(input = component.getElement())) == null) {
                return null;
            }
            bps.setInput(input);
            return bps;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IPropertySource getXSDPropertySource(Object object) {
        Element input = (Element)object;
        this.showParent = false;
        if (this.inputEquals(input, "element", false)) {
            return new ElementPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "element", true)) {
            return new GroupRefPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "sequence", false) || this.inputEquals(input, "choice", false) || this.inputEquals(input, "all", false)) {
            return new ModelGroupPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "attribute", false)) {
            return new AttributePropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "attribute", true)) {
            return new AttributeGroupRefPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "attributeGroup", false)) {
            return new NamePropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "attributeGroup", true)) {
            return new AttributeGroupRefPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "notation", false)) {
            return new NotationPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "simpleType", false)) {
            return new SimpleTypePropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "group", false)) {
            return new NamePropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "group", true)) {
            return new GroupRefPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "schema", false)) {
            return new SchemaPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "complexType", false)) {
            return new ComplexTypePropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "documentation", false)) {
            return new DocumentationPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "appinfo", false)) {
            return new AppInfoPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "simpleContent", false)) {
            if (input == null || !(input instanceof Element)) return null;
            XSDDOMHelper xsdDOMHelper = new XSDDOMHelper();
            Element parent = input;
            Element derivedByNode = xsdDOMHelper.getDerivedByElement(parent);
            if (derivedByNode == null) return null;
            if (!this.inputEquals(derivedByNode, "restriction", false) && !this.inputEquals(derivedByNode, "extension", false)) return null;
            return new SimpleContentPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "complexContent", false)) {
            if (input == null || !(input instanceof Element)) return null;
            XSDDOMHelper xsdDOMHelper = new XSDDOMHelper();
            Element parent = input;
            Element derivedByNode = xsdDOMHelper.getDerivedByElement(parent);
            if (derivedByNode == null) return null;
            return new SimpleContentPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "list", false)) {
            return new SimpleTypeListPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "union", false)) {
            return new SimpleTypeUnionPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "restriction", false)) {
            return this.createRestrictWindow(input, this.xsdSchema);
        }
        if (XSDDOMHelper.isFacet(input)) {
            Node parent;
            if (input == null || !(input instanceof Element) || !this.inputEquals(parent = input.getParentNode(), "restriction", false)) return null;
            return this.createRestrictWindow(input, this.xsdSchema);
        }
        if (this.inputEquals(input, "extension", false)) {
            Node parent;
            if (input == null || !(input instanceof Element) || !this.inputEquals(parent = input.getParentNode(), "complexContent", false) && !this.inputEquals(parent, "simpleContent", false)) return null;
            this.showParent = true;
            return new SimpleContentPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "pattern", false)) {
            return new PatternPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "enumeration", false)) {
            return new EnumerationPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "any", false)) {
            return new AnyElementPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "anyAttribute", false)) {
            return new AnyAttributePropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "unique", false)) {
            return new NamePropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "keyref", false)) {
            return new KeyrefPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "selector", false)) {
            return new XPathPropertySource(this.xsdSchema);
        }
        if (this.inputEquals(input, "field", false)) {
            return new XPathPropertySource(this.xsdSchema);
        }
        if (!this.inputEquals(input, "key", false)) return null;
        return new NamePropertySource(this.xsdSchema);
    }

    protected IPropertySource createRestrictWindow(Object input, XSDSchema xsdSchema) {
        if (input != null && input instanceof Element) {
            Node parent = ((Element)input).getParentNode();
            if (this.inputEquals(parent, "simpleType", false)) {
                return new SimpleRestrictPropertySource(xsdSchema);
            }
            if (this.inputEquals(parent, "simpleContent", false)) {
                return new SimpleRestrictPropertySource(xsdSchema);
            }
            if (this.inputEquals(parent, "complexContent", false)) {
                this.showParent = true;
                return new SimpleContentPropertySource(xsdSchema);
            }
        }
        return null;
    }

    protected boolean inputEquals(Object input, String tagname, boolean isRef) {
        return XSDDOMHelper.inputEquals(input, tagname, isRef);
    }
}

