/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.text;

import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xsd.ui.internal.text.DocumentAdapter;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDModelReconcileAdapter
extends DocumentAdapter {
    INodeNotifier currentNotifier;
    int currentEventType;
    XSDSchema schema;
    boolean handlingNotifyChanged = false;
    protected DelayedEvent delayedTask;

    public XSDModelReconcileAdapter(Document document, XSDSchema schema) {
        super(document);
        this.schema = schema;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        if (!this.handlingNotifyChanged) {
            this.handlingNotifyChanged = true;
            try {
                this.handleNotifyChange(notifier, eventType, feature, oldValue, newValue, index);
            }
            catch (Exception exception) {}
            this.handlingNotifyChanged = false;
        }
    }

    public void handleNotifyChange(INodeNotifier notifier, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        switch (eventType) {
            case 2: {
                if (!(newValue instanceof Element)) break;
                this.adapt((Element)newValue);
                break;
            }
            case 3: {
                Element elem;
                Node node = (Node)notifier;
                XSDConcreteComponent listener = this.schema.getCorrespondingComponent(node);
                if (listener instanceof XSDSchema && feature instanceof Element && (XSDDOMHelper.inputEquals(elem = (Element)feature, "include", false) || XSDDOMHelper.inputEquals(elem, "import", false) || XSDDOMHelper.inputEquals(elem, "redefine", false))) {
                    this.schema.reset();
                    this.schema.update();
                }
            }
            case 1: {
                Node node = (Node)notifier;
                XSDConcreteComponent listener = this.schema.getCorrespondingComponent(node);
                if (node.getNodeType() == 1) {
                    listener.elementAttributesChanged((Element)node);
                    listener.elementChanged((Element)node);
                    break;
                }
                if (node.getNodeType() != 9) break;
                listener.elementAttributesChanged(((Document)node).getDocumentElement());
                listener.elementChanged(((Document)node).getDocumentElement());
                break;
            }
            case 4: 
            case 5: {
                Element docElement;
                Node node = (Node)notifier;
                XSDConcreteComponent listener = this.schema.getCorrespondingComponent(node);
                if (node.getNodeType() == 1) {
                    listener.elementContentsChanged((Element)node);
                    break;
                }
                if (node.getNodeType() != 9 || (docElement = ((Document)node).getDocumentElement()) == null) break;
                String prefix = docElement.getPrefix();
                String xmlnsString = prefix == null ? "xmlns" : "xmlns:" + prefix;
                Attr attr = docElement.getAttributeNode(xmlnsString);
                boolean doParse = false;
                if (attr != null && attr.getValue().equals("http://www.w3.org/2001/XMLSchema") && docElement.getLocalName().equals("schema")) {
                    doParse = true;
                }
                if (!doParse) break;
                this.adapt(docElement);
                this.schema.setElement(docElement);
            }
        }
    }

    protected void startDelayedEvent(INodeNotifier notifier, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        this.delayedTask = new DelayedEvent();
        this.delayedTask.setNotifier(notifier);
        this.delayedTask.setEventType(eventType);
        this.delayedTask.setFeature(feature);
        this.delayedTask.setOldValue(oldValue);
        this.delayedTask.setNewValue(newValue);
        this.delayedTask.setIndex(index);
        Display.getDefault().timerExec(400, (Runnable)this.delayedTask);
    }

    class DelayedEvent
    implements Runnable {
        INodeNotifier notifier;
        int eventType;
        Object feature;
        Object oldValue;
        Object newValue;
        int index;
        boolean cancelEvent = false;

        DelayedEvent() {
        }

        public void run() {
            if (!this.cancelEvent) {
                XSDModelReconcileAdapter.this.handleNotifyChange(this.notifier, this.eventType, this.feature, this.oldValue, this.newValue, this.index);
                if (XSDModelReconcileAdapter.this.delayedTask == this) {
                    XSDModelReconcileAdapter.this.delayedTask = null;
                }
            }
        }

        public void setCancel(boolean flag) {
            this.cancelEvent = flag;
        }

        public void setNotifier(INodeNotifier notifier) {
            this.notifier = notifier;
        }

        public void setEventType(int eventType) {
            this.eventType = eventType;
        }

        public void setFeature(Object feature) {
            this.feature = feature;
        }

        public void setOldValue(Object oldValue) {
            this.oldValue = oldValue;
        }

        public void setNewValue(Object newValue) {
            this.newValue = newValue;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public INodeNotifier getNotifier() {
            return this.notifier;
        }

        public int getEventType() {
            return this.eventType;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public Object getOldValue() {
            return this.oldValue;
        }
    }
}

