/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.validation;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xml.ui.internal.validation.core.ValidateAction;
import org.eclipse.wst.xsd.ui.internal.validation.XSDMessageInfoHelper;
import org.eclipse.wst.xsd.ui.internal.validation.XSDValidator;
import org.eclipse.wst.xsd.ui.internal.validation.XSDValidatorManager;

public class ValidateAction
extends org.eclipse.wst.xml.ui.internal.validation.core.ValidateAction {
    private static final String _UI_DIALOG_XML_SCHEMA_INVALID_TEXT = "_UI_DIALOG_XML_SCHEMA_INVALID_TEXT";
    private static final String _UI_DIALOG_XML_SCHEMA_INVALID_TITLE = "_UI_DIALOG_XML_SCHEMA_INVALID_TITLE";
    private static final String _UI_VALIDATION_INTERNAL_ERROR = "_UI_VALIDATION_INTERNAL_ERROR";
    private static final String _UI_DIALOG_XML_SCHEMA_VALID_TITLE = "_UI_DIALOG_XML_SCHEMA_VALID_TITLE";
    private static final String _UI_DIALOG_XML_SCHEMA_VALID_TEXT = "_UI_DIALOG_XML_SCHEMA_VALID_TEXT";
    private static final String _UI_MESSAGE_LIMIT_EXCEEDED = "_UI_DIALOG_XML_SCHEMA_LIMITE_EXCEEDED";
    private static final String _UI_DIALOG_XML_SCHEMA_VALID_WITH_WARNINGS = "_UI_DIALOG_XML_SCHEMA_VALID_WITH_WARNINGS";
    private InputStream inputStream;

    public ValidateAction(IFile file, boolean showDialog) {
        super(file, showDialog);
    }

    protected void addInfoToMessage(ValidationMessage validationMessage, IMessage message) {
        if (this.inputStream != null) {
            XSDMessageInfoHelper messageInfoHelper = new XSDMessageInfoHelper();
            String[] messageInfo = messageInfoHelper.createMessageInfo(validationMessage.getMessage(), validationMessage.getKey());
            message.setAttribute("columnNumber", (Object)new Integer(validationMessage.getColumnNumber()));
            message.setAttribute("squiggleSelectionStrategy", (Object)messageInfo[0]);
            message.setAttribute("squiggleNameOrValue", (Object)messageInfo[1]);
        }
    }

    protected void validate(final IFile file) {
        final ValidateAction.ValidationOutcome valoutcome = new ValidateAction.ValidationOutcome((org.eclipse.wst.xml.ui.internal.validation.core.ValidateAction)this);
        IPath path = file.getLocation();
        final String uri = this.createURIForFilePath(path.toString());
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor progressMonitor) throws CoreException {
                ValidateAction.this.clearMarkers(file);
                XSDValidator validator = XSDValidator.getInstance();
                ValidationReport valreport = validator.validate(uri, ValidateAction.this.inputStream);
                valoutcome.isValid = valreport.isValid();
                valoutcome.hasMessages = valreport.getValidationMessages().length != 0;
                ValidateAction.this.createMarkers(file, valreport.getValidationMessages());
                file.setSessionProperty(ValidationMessage.ERROR_MESSAGE_MAP_QUALIFIED_NAME, (Object)valreport.getNestedMessages());
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(op, null);
            String internalErrorMessage = null;
            if (this.showDialog) {
                if (!valoutcome.isValid) {
                    String message = XSDValidatorManager.getString(_UI_DIALOG_XML_SCHEMA_INVALID_TEXT);
                    String title = XSDValidatorManager.getString(_UI_DIALOG_XML_SCHEMA_INVALID_TITLE);
                    if (internalErrorMessage != null) {
                        message = String.valueOf(message) + "\n" + internalErrorMessage;
                    }
                    this.openErrorDialog(title, message);
                } else if (valoutcome.isValid && valoutcome.hasMessages) {
                    String message = XSDValidatorManager.getString(_UI_DIALOG_XML_SCHEMA_VALID_WITH_WARNINGS);
                    String title = XSDValidatorManager.getString(_UI_DIALOG_XML_SCHEMA_VALID_TITLE);
                    this.openWarningDialog(title, message);
                } else {
                    String message = XSDValidatorManager.getString(_UI_DIALOG_XML_SCHEMA_VALID_TEXT);
                    String title = XSDValidatorManager.getString(_UI_DIALOG_XML_SCHEMA_VALID_TITLE);
                    this.openValidDialog(title, message);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }
}

