/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.widgets;

import java.util.List;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.ViewUtility;
import org.eclipse.xsd.XSDSchema;

public class TypeSection {
    protected Button simpleType;
    protected Button userSimpleType;
    protected Button userComplexType;
    protected Button noneRadio;
    protected Combo typeList;
    protected Combo derivedByCombo;
    protected boolean showUserComplexType = true;
    protected boolean showUserSimpleType = true;
    protected boolean showNone = false;
    protected boolean showDerivedBy = false;
    protected String[] derivedByChoices = new String[]{"restriction", "extension"};
    public final int NONE = 1;
    public final int BUILT_IN = 2;
    public final int SIMPLE = 3;
    public final int COMPLEX = 4;
    String sectionTitle = XSDEditorPlugin.getXSDString("_UI_LABEL_TYPE_INFORMATION");
    String currentObjectUuid = "";

    public TypeSection(Composite parent) {
    }

    public Composite createClient(Composite parent) {
        new ViewUtility();
        Composite client = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.verticalSpacing = 0;
        client.setLayout((Layout)gl);
        if (this.showNone) {
            this.noneRadio = ViewUtility.createRadioButton(client, XSDEditorPlugin.getXSDString("_UI_RADIO_NONE"));
            WorkbenchHelp.setHelp((Control)this.noneRadio, (String)"org.eclipse.wst.xsd.ui.internal.xsde0910");
        }
        this.simpleType = ViewUtility.createRadioButton(client, XSDEditorPlugin.getXSDString("_UI_RADIO_BUILT_IN_SIMPLE_TYPE"));
        WorkbenchHelp.setHelp((Control)this.simpleType, (String)"org.eclipse.wst.xsd.ui.internal.xsde0920");
        if (this.showUserSimpleType) {
            this.userSimpleType = ViewUtility.createRadioButton(client, XSDEditorPlugin.getXSDString("_UI_RADIO_USER_DEFINED_SIMPLE_TYPE"));
            WorkbenchHelp.setHelp((Control)this.userSimpleType, (String)"org.eclipse.wst.xsd.ui.internal.xsde0930");
        }
        if (this.showUserComplexType) {
            this.userComplexType = ViewUtility.createRadioButton(client, XSDEditorPlugin.getXSDString("_UI_RADIO_USER_DEFINED_COMPLEX_TYPE"));
            WorkbenchHelp.setHelp((Control)this.userComplexType, (String)"org.eclipse.wst.xsd.ui.internal.xsde0940");
        }
        if (this.showDerivedBy) {
            Composite derivedByComposite = ViewUtility.createComposite(client, 2);
            ViewUtility.createLabel(derivedByComposite, XSDEditorPlugin.getXSDString("_UI_LABEL_DERIVED_BY"));
            this.derivedByCombo = ViewUtility.createComboBox(derivedByComposite);
            this.populateDerivedByCombo();
            WorkbenchHelp.setHelp((Control)this.derivedByCombo, (String)"org.eclipse.wst.xsd.ui.internal.xsde1210");
            this.derivedByCombo.setToolTipText(XSDEditorPlugin.getXSDString("_UI_TOOLTIP_DERIVED_BY"));
        }
        if (!this.showNone) {
            this.simpleType.setSelection(true);
        }
        return client;
    }

    public void setIsDerivedBy(boolean derive) {
        this.sectionTitle = derive ? XSDEditorPlugin.getXSDString("_UI_LABEL_BASE_TYPE") : XSDEditorPlugin.getXSDString("_UI_LABEL_TYPE_INFORMATION");
    }

    public void setShowDerivedBy(boolean derive) {
        this.showDerivedBy = derive;
    }

    public Combo getDerivedByCombo() {
        return this.derivedByCombo;
    }

    public Button getNoneRadio() {
        return this.noneRadio;
    }

    public Button getSimpleType() {
        return this.simpleType;
    }

    public Button getUserComplexType() {
        return this.userComplexType;
    }

    public Button getUserSimpleType() {
        return this.userSimpleType;
    }

    public Combo getTypeList() {
        return this.typeList;
    }

    public void populateBuiltInType(XSDSchema xsdSchema) {
        this.getTypeList().removeAll();
        List items = this.getBuiltInTypeNamesList(xsdSchema);
        int i = 0;
        while (i < items.size()) {
            this.getTypeList().add(items.get(i).toString());
            ++i;
        }
    }

    public List getBuiltInTypeNamesList(XSDSchema xsdSchema) {
        TypesHelper helper = new TypesHelper(xsdSchema);
        return helper.getBuiltInTypeNamesList();
    }

    public void populateUserComplexType(XSDSchema xsdSchema, boolean showAnonymous) {
        this.getTypeList().removeAll();
        if (showAnonymous) {
            this.getTypeList().add(XSDEditorPlugin.getXSDString("_UI_ANONYMOUS"));
        }
        List items = this.getUserComplexTypeNamesList(xsdSchema);
        int i = 0;
        while (i < items.size()) {
            this.getTypeList().add(items.get(i).toString());
            ++i;
        }
    }

    public List getUserComplexTypeNamesList(XSDSchema xsdSchema) {
        TypesHelper helper = new TypesHelper(xsdSchema);
        return helper.getUserComplexTypeNamesList();
    }

    public void populateUserSimpleType(XSDSchema xsdSchema, boolean showAnonymous) {
        this.getTypeList().removeAll();
        if (showAnonymous) {
            this.getTypeList().add(XSDEditorPlugin.getXSDString("_UI_ANONYMOUS"));
        }
        List items = this.getUserSimpleTypeNamesList(xsdSchema);
        int i = 0;
        while (i < items.size()) {
            this.getTypeList().add(items.get(i).toString());
            ++i;
        }
    }

    public void populateUserSimpleType(XSDSchema xsdSchema) {
        this.getTypeList().removeAll();
        List items = this.getUserSimpleTypeNamesList(xsdSchema);
        int i = 0;
        while (i < items.size()) {
            this.getTypeList().add(items.get(i).toString());
            ++i;
        }
    }

    public List getUserSimpleTypeNamesList(XSDSchema xsdSchema) {
        TypesHelper helper = new TypesHelper(xsdSchema);
        return helper.getUserSimpleTypeNamesList();
    }

    public String getPrefix(String ns, XSDSchema xsdSchema) {
        TypesHelper helper = new TypesHelper(xsdSchema);
        String key = helper.getPrefix(ns, true);
        return key;
    }

    protected void populateDerivedByCombo() {
        int i = 0;
        while (i < this.derivedByChoices.length) {
            this.getDerivedByCombo().add(this.derivedByChoices[i]);
            ++i;
        }
    }

    public boolean getShowUserComplexType() {
        return this.showUserComplexType;
    }

    public boolean getShowUserSimpleType() {
        return this.showUserSimpleType;
    }

    public boolean getShowNone() {
        return this.showNone;
    }

    public void setShowUserComplexType(boolean showUserComplexType) {
        this.showUserComplexType = showUserComplexType;
    }

    public void setShowUserSimpleType(boolean showUserSimpleType) {
        this.showUserSimpleType = showUserSimpleType;
    }

    public void setShowNone(boolean showNone) {
        this.showNone = showNone;
    }
}

