/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.UIProjectSetSerializationContext;
import org.eclipse.team.internal.ui.wizards.ExportProjectSetMainPage;
import org.eclipse.team.internal.ui.wizards.ProjectSetImportWizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ProjectSetExportWizard
extends Wizard
implements IExportWizard {
    ExportProjectSetMainPage mainPage;
    IStructuredSelection selection;

    public ProjectSetExportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TeamUIMessages.ProjectSetExportWizard_Project_Set_1);
    }

    public void addPages() {
        this.mainPage = new ExportProjectSetMainPage("projectSetMainPage", TeamUIMessages.ProjectSetExportWizard_Export_a_Project_Set_3, TeamUIPlugin.getImageDescriptor("wizban/export_projectset_wizban.gif"));
        IProject[] projects = this.selection.toList().toArray(new IProject[0]);
        this.mainPage.setSelectedProjects(projects);
        this.mainPage.setFileName(ProjectSetImportWizard.lastFile);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        boolean[] result;
        block5: {
            result = new boolean[1];
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        UIProjectSetSerializationContext context;
                        String id;
                        HashMap<String, ArrayList<IProject>> map;
                        File file;
                        block23: {
                            List list;
                            boolean r;
                            String filename = ProjectSetExportWizard.this.mainPage.getFileName();
                            Path path = new Path(filename);
                            if (path.getFileExtension() == null) {
                                filename = String.valueOf(filename) + ".psf";
                            }
                            ProjectSetImportWizard.lastFile = filename;
                            file = new File(filename);
                            File parentFile = file.getParentFile();
                            if (parentFile != null && !parentFile.exists()) {
                                r = MessageDialog.openQuestion((Shell)ProjectSetExportWizard.this.getShell(), (String)TeamUIMessages.ProjectSetExportWizard_Question_4, (String)TeamUIMessages.ProjectSetExportWizard_Target_directory_does_not_exist__Would_you_like_to_create_it__5);
                                if (!r) {
                                    result[0] = false;
                                    return;
                                }
                                r = parentFile.mkdirs();
                                if (!r) {
                                    MessageDialog.openError((Shell)ProjectSetExportWizard.this.getShell(), (String)TeamUIMessages.ProjectSetExportWizard_Export_Problems_6, (String)TeamUIMessages.ProjectSetExportWizard_An_error_occurred_creating_the_target_directory_7);
                                    result[0] = false;
                                    return;
                                }
                            }
                            if (file.exists() && file.isFile() && !(r = MessageDialog.openQuestion((Shell)ProjectSetExportWizard.this.getShell(), (String)TeamUIMessages.ProjectSetExportWizard_Question_8, (String)TeamUIMessages.ProjectSetExportWizard_Target_already_exists__Would_you_like_to_overwrite_it__9))) {
                                result[0] = false;
                                return;
                            }
                            IProject[] projects = ProjectSetExportWizard.this.mainPage.getSelectedProjects();
                            map = new HashMap<String, ArrayList<IProject>>();
                            int i = 0;
                            while (i < projects.length) {
                                IProject project = projects[i];
                                RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                                if (provider != null) {
                                    id = provider.getID();
                                    list = (ArrayList<IProject>)map.get(id);
                                    if (list == null) {
                                        list = new ArrayList<IProject>();
                                        map.put(id, (ArrayList<IProject>)list);
                                    }
                                    list.add(project);
                                }
                                ++i;
                            }
                            context = new UIProjectSetSerializationContext(ProjectSetExportWizard.this.getShell(), filename);
                            BufferedWriter writer = null;
                            try {
                                try {
                                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                                    writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                                    writer.newLine();
                                    writer.write("<psf version=\"2.0\">");
                                    writer.newLine();
                                    Iterator it = map.keySet().iterator();
                                    monitor.beginTask(null, 1000 * map.keySet().size());
                                    while (true) {
                                        if (!it.hasNext()) {
                                            writer.write("</psf>");
                                            writer.newLine();
                                            result[0] = true;
                                            break;
                                        }
                                        id = (String)it.next();
                                        writer.write("\t<provider id=\"");
                                        writer.write(id);
                                        writer.write("\">");
                                        writer.newLine();
                                        list = (List)map.get(id);
                                        IProject[] projectArray = list.toArray(new IProject[list.size()]);
                                        RepositoryProviderType providerType = RepositoryProviderType.getProviderType((String)id);
                                        ProjectSetCapability serializer = providerType.getProjectSetCapability();
                                        ProjectSetCapability.ensureBackwardsCompatible((RepositoryProviderType)providerType, (ProjectSetCapability)serializer);
                                        if (serializer != null) {
                                            String[] references = serializer.asReference(projectArray, (ProjectSetSerializationContext)context, (IProgressMonitor)new SubProgressMonitor(monitor, 990));
                                            int i2 = 0;
                                            while (i2 < references.length) {
                                                writer.write("\t\t<project reference=\"");
                                                writer.write(references[i2]);
                                                writer.write("\"/>");
                                                writer.newLine();
                                                ++i2;
                                            }
                                        }
                                        writer.write("\t</provider>");
                                        writer.newLine();
                                    }
                                }
                                catch (IOException e) {
                                    throw new InvocationTargetException(e);
                                }
                                catch (TeamException e) {
                                    throw new InvocationTargetException(e);
                                }
                                Object var18_24 = null;
                                if (writer == null) break block23;
                            }
                            catch (Throwable throwable) {
                                Object var18_23 = null;
                                if (writer == null) throw throwable;
                                try {
                                    writer.close();
                                    throw throwable;
                                }
                                catch (IOException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            try {}
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                            writer.close();
                        }
                        Iterator iter = map.keySet().iterator();
                        while (iter.hasNext()) {
                            ProjectSetCapability capability;
                            id = (String)iter.next();
                            RepositoryProviderType type = RepositoryProviderType.getProviderType((String)id);
                            if (type == null || (capability = type.getProjectSetCapability()) == null) continue;
                            capability.projectSetCreated(file, (ProjectSetSerializationContext)context, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        }
                        monitor.done();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                return true;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof TeamException) {
                    ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)((TeamException)target).getStatus());
                    return false;
                }
                if (target instanceof RuntimeException) {
                    throw (RuntimeException)target;
                }
                if (!(target instanceof Error)) break block5;
                throw (Error)target;
            }
        }
        return result[0];
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

