/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.Vector;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.PrivateUDDIRegistryTypeRegistry;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.PublicUDDIRegistryTypeRegistry;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.uddi.PublicUDDIRegistryType;
import org.eclipse.jst.ws.internal.ui.uddi.PrivateUDDIRegistryType;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.ws.internal.explorer.LaunchOption;

public class PublishWSWidget
extends SimpleWidgetDataContributor {
    private String INFOPOP_PWPB_PAGE = "org.eclipse.jst.ws.consumption.ui.PWPB0001";
    private String INFOPOP_PWPB_CHECKBOX_WS_LAUNCH = "org.eclipse.jst.ws.consumption.ui.PWPB0002";
    private Button launchUDDICheckbox_;
    private Button launchPrivateUDDICheckbox_;
    private Label pubilcUDDIRegComboLabel_;
    private Combo publicUDDIRegCombo_;
    private MessageUtils msgUtils = new MessageUtils("org.eclipse.jst.ws.consumption.ui.plugin", (Object)this);
    private Listener statusListener;
    private Boolean publish;

    public PublishWSWidget(boolean publish) {
        this.publish = new Boolean(publish);
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener = statusListener;
        Listener selListener = new Listener(){

            public void handleEvent(Event event) {
                PublishWSWidget.this.handleSelectionEvent(event);
            }
        };
        parent.setToolTipText(this.msgUtils.getMessage("TOOLTIP_PWPB_PAGE"));
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, this.INFOPOP_PWPB_PAGE);
        this.launchPrivateUDDICheckbox_ = new Button(parent, 32);
        if (this.publish.booleanValue()) {
            this.launchPrivateUDDICheckbox_.setText(this.msgUtils.getMessage("BUTTON_WS_PUBLISH_PRIVATE_UDDI"));
        } else {
            this.launchPrivateUDDICheckbox_.setText(this.msgUtils.getMessage("BUTTON_WS_FIND_PRIVATE_UDDI"));
        }
        this.launchPrivateUDDICheckbox_.setToolTipText(this.msgUtils.getMessage("TOOLTIP_PWPB_CHECKBOX_WS_LAUNCH"));
        this.launchPrivateUDDICheckbox_.addListener(13, selListener);
        helpSystem.setHelp((Control)this.launchPrivateUDDICheckbox_, this.INFOPOP_PWPB_CHECKBOX_WS_LAUNCH);
        this.launchUDDICheckbox_ = new Button(parent, 32);
        if (this.publish.booleanValue()) {
            this.launchUDDICheckbox_.setText(this.msgUtils.getMessage("BUTTON_WS_PUBLISH"));
        } else {
            this.launchUDDICheckbox_.setText(this.msgUtils.getMessage("BUTTON_WS_FIND"));
        }
        this.launchUDDICheckbox_.setToolTipText(this.msgUtils.getMessage("TOOLTIP_PWPB_CHECKBOX_WS_LAUNCH"));
        this.launchUDDICheckbox_.addListener(13, selListener);
        helpSystem.setHelp((Control)this.launchUDDICheckbox_, this.INFOPOP_PWPB_CHECKBOX_WS_LAUNCH);
        Composite c = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        c.setLayoutData((Object)gd);
        new Label(c, 64);
        this.pubilcUDDIRegComboLabel_ = new Label(c, 64);
        this.pubilcUDDIRegComboLabel_.setText(this.msgUtils.getMessage("LABEL_PUBLIC_UDDI_REGISTRIES"));
        this.publicUDDIRegCombo_ = new Combo(c, 12);
        this.publicUDDIRegCombo_.setEnabled(false);
        this.initPublicUDDI();
        this.initPrivateUDDI();
        return this;
    }

    private void initPublicUDDI() {
        PublicUDDIRegistryTypeRegistry reg = PublicUDDIRegistryTypeRegistry.getInstance();
        PublicUDDIRegistryType[] types = reg.getAllPublicUDDIRegistryTypes();
        int i = 0;
        while (i < types.length) {
            String publishURL;
            if (!this.publish.booleanValue() || (publishURL = types[i].getPublishURL()) != null && publishURL.indexOf("://") != -1) {
                this.publicUDDIRegCombo_.add(types[i].getName());
            }
            ++i;
        }
        if (types.length > 0) {
            this.publicUDDIRegCombo_.setText(this.publicUDDIRegCombo_.getItem(0));
        }
    }

    private void initPrivateUDDI() {
        if (!this.publish.booleanValue() && !PrivateUDDIRegistryTypeRegistry.getInstance().getPrivateUDDIRegistryType().isPrivateUDDIRegistryInstalled()) {
            this.launchPrivateUDDICheckbox_.setEnabled(false);
        }
    }

    private void handleSelectionEvent(Event event) {
        if (this.launchUDDICheckbox_ == event.widget) {
            this.publicUDDIRegCombo_.setEnabled(this.launchUDDICheckbox_.getSelection());
        }
        this.statusListener.handleEvent(event);
    }

    public void setPublishToPublicUDDI(boolean publish) {
        this.launchUDDICheckbox_.setSelection(publish);
        this.publicUDDIRegCombo_.setEnabled(publish);
    }

    public void setPublishToPublicUDDI(Boolean publish) {
        this.setPublishToPublicUDDI((boolean)publish);
    }

    public void setPublishToPrivateUDDI(boolean publish) {
        this.launchPrivateUDDICheckbox_.setSelection(publish);
    }

    public void setPublishToPrivateUDDI(Boolean publish) {
        this.setPublishToPrivateUDDI((boolean)publish);
    }

    public boolean getPublishToPublicUDDI() {
        return this.launchUDDICheckbox_.getSelection();
    }

    public boolean getPublishToPrivateUDDI() {
        return this.launchPrivateUDDICheckbox_.getSelection();
    }

    public boolean getForceLaunchOutsideIDE() {
        return false;
    }

    public LaunchOption[] getLaunchOptions() {
        Vector<LaunchOption> launchOptionVector = new Vector<LaunchOption>();
        if (this.launchUDDICheckbox_.getSelection()) {
            PublicUDDIRegistryTypeRegistry reg = PublicUDDIRegistryTypeRegistry.getInstance();
            int UDDIRegSelectionIndex = this.publicUDDIRegCombo_.getSelectionIndex();
            if (UDDIRegSelectionIndex != -1) {
                String name = this.publicUDDIRegCombo_.getItem(UDDIRegSelectionIndex);
                String id = reg.getPublicUDDIRegistryTypeIDByName(name);
                PublicUDDIRegistryType type = reg.getPublicUDDIRegistryTypeByID(id);
                launchOptionVector.add(new LaunchOption("inquiry", type.getInquiryURL()));
                launchOptionVector.add(new LaunchOption("publish", type.getPublishURL()));
            }
        }
        if (this.launchPrivateUDDICheckbox_.getSelection()) {
            PrivateUDDIRegistryTypeRegistry privateReg = PrivateUDDIRegistryTypeRegistry.getInstance();
            PrivateUDDIRegistryType privateType = privateReg.getPrivateUDDIRegistryType();
            String[] privateInquiryURL = privateType.getPrivateUDDIRegistryInquiryAPI();
            String[] privatePublishURL = privateType.getPrivateUDDIRegistryPublishAPI();
            int i = 0;
            while (i < privateInquiryURL.length) {
                launchOptionVector.add(new LaunchOption("inquiry", privateInquiryURL[i]));
                launchOptionVector.add(new LaunchOption("publish", privatePublishURL[i]));
                ++i;
            }
        }
        return launchOptionVector.toArray(new LaunchOption[0]);
    }
}

