/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime;

import org.eclipse.jst.ws.internal.consumption.ui.common.ValidationUtils;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime.ProjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime.RuntimeServerSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.ClientProjectTypeRegistry;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionList;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionListChoices;

public class ClientRuntimeSelectionWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private String INFOPOP_PWRS_GROUP_CLIENT = String.valueOf(this.pluginId_) + ".PWRS0003";
    private String clientScenarioId;
    private Group clientGroup_;
    private RuntimeServerSelectionWidget runtimeWidget_;
    private SelectionListChoices runtime2ClientTypes_;
    private Combo clientType_;
    private SelectionAdapter clientTypeSelListener;
    private ProjectSelectionWidget projectWidget_;
    private boolean isVisible_;
    private String serviceScenarioId;

    public WidgetDataEvents addControls(Composite parent, final Listener statusListener) {
        MessageUtils msgUtils = new MessageUtils(String.valueOf(this.pluginId_) + ".plugin", (Object)this);
        UIUtils uiUtils = new UIUtils(msgUtils, this.pluginId_);
        this.clientGroup_ = uiUtils.createGroup(parent, "LABEL_CLIENT_SELECTION_VIEW_TITLE", null, this.INFOPOP_PWRS_GROUP_CLIENT, 2, 5, 5);
        this.runtimeWidget_ = new RuntimeServerSelectionWidget(true);
        this.runtimeWidget_.addControls((Composite)this.clientGroup_, statusListener);
        this.runtimeWidget_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClientRuntimeSelectionWidget.this.handleRuntime2ClientTypesEvent();
                ClientRuntimeSelectionWidget.this.handleUpdateProjectWidget();
            }
        });
        this.clientType_ = uiUtils.createCombo((Composite)this.clientGroup_, "LABEL_CLIENT_TYPE", "TOOLTIP_PWCR_COMBO_CLIENT_TYPE", this.INFOPOP_PWRS_GROUP_CLIENT, 2060);
        this.clientTypeSelListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ClientRuntimeSelectionWidget.this.handleSetProjects(ClientRuntimeSelectionWidget.this.clientType_.getSelectionIndex());
                statusListener.handleEvent(null);
            }
        };
        this.clientType_.addSelectionListener((SelectionListener)this.clientTypeSelListener);
        this.projectWidget_ = new ProjectSelectionWidget(true);
        this.projectWidget_.addControls((Composite)this.clientGroup_, statusListener);
        return this;
    }

    public void setVisible(boolean value) {
        this.clientGroup_.setVisible(value);
        this.isVisible_ = value;
    }

    public boolean isVisible() {
        return this.isVisible_;
    }

    public void setClientTypeRuntimeServer(TypeRuntimeServer ids) {
        this.runtimeWidget_.setTypeRuntimeServer(ids);
        this.projectWidget_.setTypeRuntimeServer(ids);
    }

    public TypeRuntimeServer getClientTypeRuntimeServer() {
        return this.runtimeWidget_.getTypeRuntimeServer();
    }

    public String getJ2EEVersion() {
        return this.runtimeWidget_.getJ2EEVersion();
    }

    public void setJ2EEVersion(String j2eeVersion) {
        this.runtimeWidget_.setJ2EEVersion(j2eeVersion);
        this.projectWidget_.setJ2EEVersion(j2eeVersion);
    }

    public boolean getClientNeedEAR() {
        return this.projectWidget_.getNeedEAR();
    }

    public void setClientNeedEAR(boolean b) {
        this.projectWidget_.setNeedEAR(b);
    }

    public String getClientComponentName() {
        return this.projectWidget_.getComponentName();
    }

    public void setClientComponentName(String name) {
        this.projectWidget_.setComponentName(name);
    }

    public String getClientEarComponentName() {
        return this.projectWidget_.getEarComponentName();
    }

    public void setClientEarComponentName(String name) {
        this.projectWidget_.setEarComponentName(name);
    }

    public String getClientComponentType() {
        SelectionList projTypeList = this.runtime2ClientTypes_.getChoice().getList();
        projTypeList.setIndex(this.clientType_.getSelectionIndex());
        return projTypeList.getSelection();
    }

    public void setClientComponentType(String type) {
        this.projectWidget_.setComponentType(type);
    }

    public String getClientProjectName() {
        return this.projectWidget_.getProjectName();
    }

    public String getClientEarProjectName() {
        return this.projectWidget_.getEarProjectName();
    }

    public void setRuntime2ClientTypes(SelectionListChoices runtime2ClientTypes) {
        this.runtime2ClientTypes_ = runtime2ClientTypes;
        this.handleRuntime2ClientTypesEvent();
    }

    public SelectionListChoices getRuntime2ClientTypes() {
        ClientProjectTypeRegistry.getInstance();
        String runtime = this.runtimeWidget_.getTypeRuntimeServer().getRuntimeId();
        String clientProject = this.projectWidget_.getProjectChoices().getList().getSelection();
        String earProject = this.projectWidget_.getProjectChoices().getChoice().getList().getSelection();
        SelectionList runtimeList = this.runtime2ClientTypes_.getList();
        runtimeList.setSelectionValue(runtime);
        SelectionList projTypeList = this.runtime2ClientTypes_.getChoice().getList();
        projTypeList.setIndex(this.clientType_.getSelectionIndex());
        SelectionListChoices clientProjChoice = this.runtime2ClientTypes_.getChoice().getChoice();
        SelectionList clientProjList = clientProjChoice.getList();
        clientProjList.setSelectionValue(clientProject);
        SelectionList earProjList = clientProjChoice.getChoice().getList();
        earProjList.setSelectionValue(earProject);
        return this.runtime2ClientTypes_;
    }

    private void handleRuntime2ClientTypesEvent() {
        if (this.runtime2ClientTypes_ != null) {
            String newRuntimeId;
            String currentRuntimeId = this.runtime2ClientTypes_.getList().getSelection();
            if (currentRuntimeId != (newRuntimeId = this.runtimeWidget_.getTypeRuntimeServer().getRuntimeId())) {
                SelectionList runtimes = this.runtime2ClientTypes_.getList();
                runtimes.setSelectionValue(this.runtimeWidget_.getTypeRuntimeServer().getRuntimeId());
            }
            String[] clientTypeIds = this.runtime2ClientTypes_.getChoice().getList().getList();
            int selectedClientTypeIdx = this.runtime2ClientTypes_.getChoice().getList().getIndex();
            this.clientType_.removeSelectionListener((SelectionListener)this.clientTypeSelListener);
            this.clientType_.setItems(this.getClientTypeLabels(clientTypeIds));
            this.clientType_.select(selectedClientTypeIdx);
            this.clientType_.addSelectionListener((SelectionListener)this.clientTypeSelListener);
            this.handleSetProjects(selectedClientTypeIdx);
        }
    }

    private void handleUpdateProjectWidget() {
        this.projectWidget_.setTypeRuntimeServer(this.runtimeWidget_.getTypeRuntimeServer());
        this.projectWidget_.setJ2EEVersion(this.runtimeWidget_.getJ2EEVersion());
    }

    private void handleSetProjects(int clientTypeIndex) {
        SelectionListChoices clientType2Projects = this.runtime2ClientTypes_.getChoice();
        clientType2Projects.getList().setIndex(clientTypeIndex);
        SelectionListChoices currentProjects = this.projectWidget_.getProjectChoices();
        if (currentProjects != null) {
            String projectName = currentProjects.getList().getSelection();
            String earName = currentProjects.getChoice().getList().getSelection();
            clientType2Projects.getChoice().getList().setSelectionValue(projectName);
            clientType2Projects.getChoice().getChoice().getList().setSelectionValue(earName);
        }
        this.projectWidget_.setComponentType(clientType2Projects.getList().getSelection());
        this.projectWidget_.setProjectChoices(clientType2Projects.getChoice());
    }

    private String[] getClientTypeLabels(String[] types) {
        MessageUtils msgUtils = new MessageUtils(String.valueOf(this.pluginId_) + ".plugin", (Object)this);
        String[] clientTypeLabels = new String[types.length];
        int index = 0;
        while (index < types.length) {
            String type = types[index];
            clientTypeLabels[index] = type.equals("jst.web") ? msgUtils.getMessage("LABEL_CLIENT_COMP_TYPE_WEB") : (type.equals("jst.ejb") ? msgUtils.getMessage("LABEL_CLIENT_COMP_TYPE_EJB") : (type.equals("jst.appclient") ? msgUtils.getMessage("LABEL_CLIENT_COMP_TYPE_APP_CLIENT") : (type.equals("jst.utility") ? msgUtils.getMessage("LABEL_CLIENT_COMP_TYPE_CONTAINERLESS") : type)));
            ++index;
        }
        return clientTypeLabels;
    }

    public ProjectSelectionWidget getProjectSelectionWidget() {
        return this.projectWidget_;
    }

    public Status getStatus() {
        SimpleStatus finalStatus = new SimpleStatus("");
        Status projectStatus = this.projectWidget_.getStatus();
        Status runtimeStatus = this.runtimeWidget_.getStatus();
        if (runtimeStatus.getSeverity() == 4) {
            finalStatus = runtimeStatus;
        } else if (projectStatus.getSeverity() == 4) {
            finalStatus = projectStatus;
        } else {
            SelectionListChoices clientProjects = this.getProjectSelectionWidget().getProjectChoices();
            ValidationUtils valUtils = new ValidationUtils();
            if (clientProjects != null) {
                String clientJ2EElevel;
                String clientServerFactoryId;
                Status clientProjectStatus;
                String clientEARName = this.getClientEarProjectName();
                String clientProjName = this.getClientProjectName();
                String clientCompName = this.projectWidget_.getComponentName();
                String clientEARCompName = this.projectWidget_.getEarComponentName();
                Status clientProjectTypeStatus = valUtils.validateProjectType(clientProjName, this.runtime2ClientTypes_);
                if (clientProjectTypeStatus.getSeverity() == 4) {
                    finalStatus = clientProjectTypeStatus;
                }
                if ((clientProjectStatus = valUtils.validateProjectTargetAndJ2EE(clientProjName, clientCompName, clientEARName, clientEARCompName, clientServerFactoryId = this.getClientTypeRuntimeServer().getServerId(), clientJ2EElevel = this.getJ2EEVersion())).getSeverity() == 4) {
                    finalStatus = clientProjectStatus;
                }
            }
        }
        return finalStatus;
    }
}

