/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.IApplicationClientNatureConstants;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.internal.earcreation.AddUtilityJARMapCommand;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.CreateSampleProjectCommand;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.server.core.IServer;

public class AddModuleDependenciesCommand
extends SimpleCommand {
    private String sampleProject;
    private String sampleEAR;
    private String sampleP;
    private String sampleC;
    private String clientC;
    private String clientP;
    private String clientProject;
    private String sampleServerTypeID;
    private IServer sampleExistingServer;
    private String clientJ2EEVersion;

    public AddModuleDependenciesCommand() {
        super("org.eclipse.jst.ws.internal.consumption.command.common.AddModuleDependenciesTask", "org.eclipse.jst.ws.internal.consumption.command.common.AddModuleDependenciesTask");
    }

    public Status execute(Environment env) {
        try {
            IProject clientIProject;
            IProject sampleIProject;
            if (this.sampleProject != null) {
                int index = this.sampleProject.indexOf("/");
                this.sampleP = this.sampleProject.substring(0, index);
                this.sampleC = this.sampleProject.substring(index + 1);
            }
            if ((sampleIProject = ProjectUtilities.getProject((String)this.sampleP)) == null) {
                CreateSampleProjectCommand createSample = new CreateSampleProjectCommand();
                createSample.setSampleProject(this.sampleProject);
                createSample.setSampleProjectEAR(this.sampleEAR);
                if (this.sampleEAR != null && this.sampleEAR.length() > 0) {
                    createSample.setNeedEAR(true);
                }
                createSample.setExistingServer(this.sampleExistingServer);
                createSample.setServerFactoryId(this.sampleServerTypeID);
                createSample.setJ2eeVersion(this.clientJ2EEVersion);
                createSample.execute(env);
            }
            IResource res = ResourceUtils.findResource((String)this.sampleEAR);
            IProject sampleIEAR = null;
            if (res instanceof IProject) {
                sampleIEAR = (IProject)res;
            }
            if (sampleIProject == null) {
                return new SimpleStatus("", "", 4);
            }
            if (this.clientProject != null) {
                int index = this.clientProject.indexOf("/");
                this.clientP = this.clientProject.substring(0, index);
                this.clientC = this.clientProject.substring(index + 1);
            }
            if ((clientIProject = ProjectUtilities.getProject((String)this.clientP)) != null && !J2EEUtils.isWebComponent((IProject)clientIProject, (String)this.clientC)) {
                String uri = String.valueOf(clientIProject.getName()) + ".jar";
                if (ResourceUtils.isTrueJavaProject((IProject)clientIProject)) {
                    this.addJavaProjectAsUtilityJar(clientIProject, sampleIEAR, uri);
                }
                this.addJAROrModuleDependency(sampleIProject, this.sampleC, uri);
                this.addBuildPath(sampleIProject, clientIProject);
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
        return new SimpleStatus("");
    }

    private void addJavaProjectAsUtilityJar(IProject javaProject, IProject earProject, String uri) {
        AddUtilityJARMapCommand cmd = new AddUtilityJARMapCommand(earProject, uri, javaProject);
        cmd.execute();
    }

    private void addJAROrModuleDependency(IProject project, String compName, String uri) throws IOException, CoreException {
        J2EENature nature = null;
        if (J2EEUtils.isWebComponent((IProject)project, (String)compName)) {
            nature = this.getWebNature(project);
        } else if (J2EEUtils.isAppClientComponent((IProject)project, (String)compName)) {
            nature = this.getAppClientNature(project);
        } else if (J2EEUtils.isEJBComponent((IProject)project, (String)compName)) {
            nature = this.getEJBNature(project);
        }
        if (nature != null) {
            ArchiveManifest manifest = J2EEProjectUtilities.readManifest((IProject)project);
            manifest.mergeClassPath(new String[]{uri});
            J2EEProjectUtilities.writeManifest((IProject)project, (ArchiveManifest)manifest);
        }
    }

    private void addBuildPath(IProject referencingProject, IProject referencedProject) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)referencingProject);
        if (javaProject != null) {
            IClasspathEntry[] oldCp = javaProject.getRawClasspath();
            IClasspathEntry[] newCp = new IClasspathEntry[oldCp.length];
            int i = 0;
            while (i < oldCp.length) {
                newCp[i] = oldCp[i];
                ++i;
            }
            newCp[newCp.length - 1] = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
            javaProject.setRawClasspath(newCp, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private J2EENature getWebNature(IProject project) {
        try {
            return (J2EENature)project.getNature("org.eclipse.jst.j2ee.web.WebNature");
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private J2EENature getAppClientNature(IProject project) {
        int i = 0;
        while (i < IApplicationClientNatureConstants.APPCLIENT_NATURE_IDS.length) {
            try {
                return (J2EENature)project.getNature(IApplicationClientNatureConstants.APPCLIENT_NATURE_IDS[i]);
            }
            catch (CoreException coreException) {
                ++i;
            }
        }
        return null;
    }

    private J2EENature getEJBNature(IProject project) {
        try {
            return (J2EENature)project.getNature("org.eclipse.jst.j2ee.ejb.EJBNature");
        }
        catch (CoreException coreException) {
            try {
                return (J2EENature)project.getNature("org.eclipse.jst.j2ee.ejb.EJBNature");
            }
            catch (CoreException coreException2) {
                return null;
            }
        }
    }

    private IProject getEARProject(IProject sampleProject) {
        EARNatureRuntime[] natures = J2EEUtils.getEARProjects((IProject)sampleProject);
        if (natures != null && natures.length > 0) {
            return natures[0].getProject();
        }
        return null;
    }

    public void setSampleProject(String sampleProject) {
        this.sampleProject = sampleProject;
    }

    public String getSampleProject() {
        return this.sampleProject;
    }

    public void setSampleProjectEAR(String sampleEAR) {
        this.sampleEAR = sampleEAR;
    }

    public void setClientProject(String clientProject) {
        this.clientProject = clientProject;
    }

    public void setSampleServerTypeID(String sampleServerTypeID) {
        this.sampleServerTypeID = sampleServerTypeID;
    }

    public void setSampleExistingServer(IServer sampleExistingServer) {
        this.sampleExistingServer = sampleExistingServer;
    }

    public void setClientJ2EEVersion(String clientJ2EEVersion) {
        this.clientJ2EEVersion = clientJ2EEVersion;
    }
}

