/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test.explorer;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.consumption.command.common.StartProjectCommand;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.LaunchOption;
import org.eclipse.wst.ws.internal.explorer.WSExplorerLauncherCommand;
import org.eclipse.wst.ws.internal.explorer.plugin.ExplorerPlugin;
import org.eclipse.wst.ws.internal.provisional.wsrt.TestInfo;

public class WSEGenerateCommand
extends SimpleCommand {
    private TestInfo testInfo;
    private Model proxyModel;

    public WSEGenerateCommand(TestInfo testInfo) {
        this.testInfo = testInfo;
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        StartProjectCommand spc = new StartProjectCommand(true);
        spc.setServiceServerTypeID(this.testInfo.getServiceServerTypeID());
        spc.setServiceExistingServer(this.testInfo.getServiceExistingServer());
        IProject project = ProjectUtilities.getProject((String)this.testInfo.getServiceProject());
        spc.setServiceProject(project);
        spc.setIsWebProjectStartupRequested(true);
        status = spc.execute(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        WSExplorerLauncherCommand launchCommand = new WSExplorerLauncherCommand();
        launchCommand.setForceLaunchOutsideIDE(false);
        Vector<LaunchOption> launchOptionVector = new Vector<LaunchOption>();
        String stateLocation = ExplorerPlugin.getInstance().getPluginStateLocation();
        String defaultFavoritesLocation = ExplorerPlugin.getInstance().getDefaultFavoritesLocation();
        launchOptionVector.add(new LaunchOption("stateLocation", stateLocation));
        launchOptionVector.add(new LaunchOption("defaultFavoritesLocation", defaultFavoritesLocation));
        launchOptionVector.add(new LaunchOption("wsdl", this.testInfo.getWsdlServiceURL()));
        if (this.testInfo.getEndpoint() != null) {
            Iterator it = this.testInfo.getEndpoint().iterator();
            while (it.hasNext()) {
                launchOptionVector.add(new LaunchOption("webServiceEndpoint", it.next().toString()));
            }
        }
        launchCommand.setLaunchOptions(launchOptionVector.toArray(new LaunchOption[0]));
        status = launchCommand.execute(env);
        return status;
    }
}

