/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test.wssample;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.PublishProjectCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.StartServerCommand;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusException;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.ws.internal.provisional.wsrt.TestInfo;

public class GSTCLaunchCommand
extends SimpleCommand {
    public static String INPUT = "Input.jsp";
    public static String TEST_CLIENT = "TestClient.jsp";
    public static String RESULT = "Result.jsp";
    public static String METHOD = "Method.jsp";
    private TestInfo testInfo;
    private MessageUtils msgUtils;

    public GSTCLaunchCommand(TestInfo testInfo) {
        this.testInfo = testInfo;
        String pluginId = "org.eclipse.jst.ws.consumption.ui";
        this.msgUtils = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
    }

    public Status execute(Environment env) {
        return this.launchSample(env);
    }

    private Status launchSample(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        Path fDestinationFolderPath = new Path(this.testInfo.getJspFolder());
        fDestinationFolderPath = fDestinationFolderPath.makeAbsolute();
        PublishProjectCommand ppc = new PublishProjectCommand();
        ppc.setServerTypeID(this.testInfo.getClientServerTypeID());
        ppc.setExistingServer(this.testInfo.getClientExistingServer());
        ppc.setProject(this.testInfo.getGenerationProject());
        status = ppc.execute(env);
        StartServerCommand serverCommand = new StartServerCommand(true);
        serverCommand.setServerInstanceId(this.testInfo.getClientExistingServer().getId());
        status = serverCommand.execute(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        IProject sampleProject = ProjectUtilities.getProject((String)this.testInfo.getGenerationProject());
        Path newPath = new Path(ServerUtils.getWebComponentURL((IProject)sampleProject, (String)this.testInfo.getGenerationModule(), (String)this.testInfo.getClientServerTypeID(), (IServer)this.testInfo.getClientExistingServer()));
        int count = J2EEUtils.getWebContentPath((IProject)sampleProject, (String)this.testInfo.getGenerationModule()).segmentCount();
        newPath = newPath.append(fDestinationFolderPath.removeFirstSegments(count).makeAbsolute());
        StringBuffer urlString = new StringBuffer(newPath.append(TEST_CLIENT).toString());
        if (this.testInfo.getEndpoint() != null && !this.testInfo.getEndpoint().isEmpty()) {
            urlString.append("?endpoint=");
            urlString.append(this.testInfo.getEndpoint().get(0).toString());
        }
        try {
            URL url = new URL(urlString.toString());
            int retries = 0;
            while (retries < 10) {
                try {
                    new URL(newPath.append(RESULT).toString()).openStream();
                    new URL(newPath.append(METHOD).toString()).openStream();
                    new URL(newPath.append(INPUT).toString()).openStream();
                    new URL(newPath.append(TEST_CLIENT).toString()).openStream();
                    break;
                }
                catch (IOException iOException) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++retries;
                }
            }
            IWorkbenchBrowserSupport browserSupport = WebServiceConsumptionUIPlugin.getInstance().getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(2, null, null, null);
            browser.openURL(url);
            return status;
        }
        catch (PartInitException exc) {
            env.getLog().log(2, 5048, (Object)this, "launchSample", (Throwable)exc);
            status = new SimpleStatus("launchSample", this.msgUtils.getMessage("MSG_ERROR_MALFORMED_URL"), 2);
            try {
                env.getStatusHandler().report((Status)status);
            }
            catch (StatusException statusException) {
                status = new SimpleStatus("launchSample", this.msgUtils.getMessage("MSG_ERROR_MALFORMED_URL"), 4);
            }
            return status;
        }
        catch (MalformedURLException exc) {
            env.getLog().log(2, 5048, (Object)this, "launchSample", (Throwable)exc);
            status = new SimpleStatus("launchSample", this.msgUtils.getMessage("MSG_ERROR_MALFORMED_URL"), 2);
            try {
                env.getStatusHandler().report((Status)status);
            }
            catch (StatusException statusException) {
                status = new SimpleStatus("launchSample", this.msgUtils.getMessage("MSG_ERROR_MALFORMED_URL"), 4);
            }
            return status;
        }
    }
}

