/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jem.internal.proxy.core.BaseProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyLaunchSupport;
import org.eclipse.jem.internal.proxy.ide.IDEMethodProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.ide.awt.IDERegisterAWT;
import org.eclipse.jem.internal.proxy.remote.LocalFileConfigurationContributorController;

public class IDERegistration {
    private String pluginName;

    public static ProxyFactoryRegistry startAnImplementation(IConfigurationContributor[] contributors, boolean attachAWT, IProject project, String vmName, String pluginName, IProgressMonitor pm) throws CoreException {
        IDERegistration idereg = new IDERegistration(pluginName);
        return idereg.startImplementation(contributors, attachAWT, project, vmName, pm);
    }

    public IDERegistration() {
    }

    private IDERegistration(String pluginName) {
        this.pluginName = pluginName;
    }

    public ProxyFactoryRegistry startImplementation(IConfigurationContributor[] contributors, boolean attachAWT, IProject project, String vmName, IProgressMonitor pm) throws CoreException {
        int ii;
        URL[] classPaths = null;
        IJavaProject javaProject = null;
        if (project != null) {
            javaProject = JavaCore.create((IProject)project);
            classPaths = ProxyLaunchSupport.convertStringPathsToURL((String[])JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject));
        } else {
            classPaths = new URL[]{};
        }
        IJavaProject jp = javaProject;
        final ProxyLaunchSupport.LaunchInfo launchInfo = new ProxyLaunchSupport.LaunchInfo();
        contributors = ProxyLaunchSupport.fillInLaunchInfo((IConfigurationContributor[])(contributors == null ? ProxyLaunchSupport.EMPTY_CONFIG_CONTRIBUTORS : contributors), (ProxyLaunchSupport.LaunchInfo)launchInfo, (String)(jp != null ? jp.getElementName() : null));
        final LocalFileConfigurationContributorController controller = new LocalFileConfigurationContributorController(classPaths, new URL[3][], launchInfo);
        final IConfigurationContributor[] contribs = contributors;
        int i = 0;
        while (i < contributors.length) {
            ii = i++;
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribs[ii].initialize(launchInfo.getConfigInfo());
                }
            });
        }
        i = 0;
        while (i < contributors.length) {
            ii = i++;
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribs[ii].contributeClasspaths((IConfigurationContributionController)controller);
                }
            });
        }
        classPaths = controller.getFinalClasspath();
        final BaseProxyFactoryRegistry registry = (BaseProxyFactoryRegistry)IDERegistration.createIDEProxyFactoryRegistry(vmName, this.pluginName, classPaths);
        ProxyLaunchSupport.performExtensionRegistrations((BaseProxyFactoryRegistry)registry, (ProxyLaunchSupport.LaunchInfo)launchInfo);
        int i2 = 0;
        while (i2 < contribs.length) {
            final int ii2 = i2++;
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribs[ii2].contributeToRegistry((ProxyFactoryRegistry)registry);
                }
            });
        }
        return registry;
    }

    public static ProxyFactoryRegistry createIDEProxyFactoryRegistry(String aName, String aPluginName, URL[] otherURLs) {
        IDEProxyFactoryRegistry registry = new IDEProxyFactoryRegistry(aName, IDEProxyFactoryRegistry.createSpecialLoader(aPluginName, otherURLs));
        IDERegistration.initRegistry(registry);
        return registry;
    }

    public static ProxyFactoryRegistry createIDEProxyFactoryRegistry(String aName, ClassLoader loader) {
        IDEProxyFactoryRegistry registry = new IDEProxyFactoryRegistry(aName, loader);
        IDERegistration.initRegistry(registry);
        return registry;
    }

    private static void initRegistry(IDEProxyFactoryRegistry registry) {
        new IDEStandardBeanTypeProxyFactory(registry);
        new IDEStandardBeanProxyFactory(registry);
        new IDEMethodProxyFactory(registry);
        IDERegisterAWT.registerAWT(registry);
    }
}

