/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;

public class BP2122
extends AssertionProcess {
    private final WSDLValidatorImpl validator;
    private String context;

    public BP2122(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        ErrorList errorList = new ErrorList();
        Types types = (Types)entryContext.getEntry().getEntryDetail();
        Definition definition = null;
        if (types != null) {
            definition = this.validator.analyzerContext.getCandidateInfo().getDefinition(types);
            if (definition == null) {
                throw new WSIException("Could not find types definition in any WSDL document.");
            }
            this.context = definition.getDocumentBaseURI();
            List extElements = types.getExtensibilityElements();
            int i = 0;
            while (i < extElements.size()) {
                ExtensibilityElement extElement = (ExtensibilityElement)extElements.get(i);
                if (extElement instanceof UnknownExtensibilityElement && !extElement.getElementType().equals(WSITag.ELEM_XSD_SCHEMA)) {
                    errorList.add(String.valueOf(extElement.getElementType().toString()) + " can not be a child of the wsdl:types element.");
                }
                ++i;
            }
        }
        if (errorList.isEmpty()) {
            errorList.add(this.validator.wsdlDocument.getSchemasValidationErrors());
        }
        if (!errorList.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(errorList.toString(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

