/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.internal;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.internet.monitor.core.internal.IMemento;
import org.eclipse.wst.internet.monitor.core.internal.Messages;
import org.eclipse.wst.internet.monitor.core.internal.MonitorManager;
import org.eclipse.wst.internet.monitor.core.internal.MonitorPlugin;
import org.eclipse.wst.internet.monitor.core.internal.MonitorWorkingCopy;
import org.eclipse.wst.internet.monitor.core.internal.Trace;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorWorkingCopy;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IRequestListener;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;

public class Monitor
implements IMonitor {
    private static final String MEMENTO_ID = "id";
    private static final String MEMENTO_LOCAL_PORT = "local-port";
    private static final String MEMENTO_REMOTE_HOST = "remote-host";
    private static final String MEMENTO_REMOTE_PORT = "remote-port";
    private static final String MEMENTO_TYPE_ID = "type-id";
    private static final int ADD = 0;
    private static final int CHANGE = 1;
    protected String id;
    protected String remoteHost;
    protected int remotePort = 80;
    protected int localPort = 80;
    protected String protocolId;
    protected List requestListeners = new ArrayList(2);

    public Monitor() {
        this.protocolId = MonitorPlugin.getInstance().getDefaultType();
    }

    public String getId() {
        return this.id;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getProtocol() {
        return this.protocolId;
    }

    public boolean isRunning() {
        if (this.isWorkingCopy()) {
            return false;
        }
        return MonitorManager.getInstance().isRunning(this);
    }

    public void delete() {
        if (this.isWorkingCopy()) {
            return;
        }
        MonitorManager.getInstance().removeMonitor(this);
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public IMonitorWorkingCopy createWorkingCopy() {
        return new MonitorWorkingCopy(this);
    }

    protected void setInternal(IMonitor monitor) {
        this.id = monitor.getId();
        this.remoteHost = monitor.getRemoteHost();
        this.remotePort = monitor.getRemotePort();
        this.localPort = monitor.getLocalPort();
        this.protocolId = monitor.getProtocol();
    }

    protected void save(IMemento memento) {
        memento.putString(MEMENTO_ID, this.id);
        memento.putString(MEMENTO_TYPE_ID, this.protocolId);
        memento.putInteger(MEMENTO_LOCAL_PORT, this.localPort);
        memento.putString(MEMENTO_REMOTE_HOST, this.remoteHost);
        memento.putInteger(MEMENTO_REMOTE_PORT, this.remotePort);
    }

    protected void load(IMemento memento) {
        this.id = memento.getString(MEMENTO_ID);
        this.protocolId = memento.getString(MEMENTO_TYPE_ID);
        Integer temp = memento.getInteger(MEMENTO_LOCAL_PORT);
        if (temp != null) {
            this.localPort = temp;
        }
        this.remoteHost = memento.getString(MEMENTO_REMOTE_HOST);
        temp = memento.getInteger(MEMENTO_REMOTE_PORT);
        if (temp != null) {
            this.remotePort = temp;
        }
    }

    public synchronized void start() throws CoreException {
        if (this.isRunning()) {
            return;
        }
        if (this.isWorkingCopy() || !MonitorManager.getInstance().exists(this)) {
            throw new IllegalArgumentException();
        }
        IStatus status = this.validate();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        MonitorManager.getInstance().startMonitor(this);
    }

    public synchronized void stop() {
        if (this.isWorkingCopy() || !MonitorManager.getInstance().exists(this)) {
            throw new IllegalArgumentException();
        }
        if (!this.isRunning()) {
            return;
        }
        MonitorManager.getInstance().stopMonitor(this);
    }

    public synchronized void addRequestListener(IRequestListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (!this.requestListeners.contains(listener)) {
            this.requestListeners.add(listener);
        }
    }

    public synchronized void removeRequestListener(IRequestListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.requestListeners.remove(listener);
    }

    protected void fireRequestEvent(Request rr, int type) {
        int size = this.requestListeners.size();
        IRequestListener[] rl = new IRequestListener[size];
        this.requestListeners.toArray(rl);
        int i = 0;
        while (i < size) {
            IRequestListener listener = rl[i];
            if (type == 0) {
                listener.requestAdded(this, rr);
            } else if (type == 1) {
                listener.requestChanged(this, rr);
            }
            ++i;
        }
    }

    public void addRequest(Request request) {
        this.fireRequestEvent(request, 0);
    }

    public void requestChanged(Request request) {
        this.fireRequestEvent(request, 1);
    }

    public IStatus validate() {
        if (this.localPort < 0) {
            return new Status(4, "org.eclipse.wst.internet.monitor.core", 0, Messages.errorInvalidLocalPort, null);
        }
        if (this.remotePort < 0) {
            return new Status(4, "org.eclipse.wst.internet.monitor.core", 0, Messages.errorInvalidRemotePort, null);
        }
        if (this.remoteHost == null || this.remoteHost.length() == 0 || !Monitor.isValidHostname(this.remoteHost)) {
            return new Status(4, "org.eclipse.wst.internet.monitor.core", 0, Messages.errorInvalidRemoteHost, null);
        }
        if (Monitor.isLocalhost(this.remoteHost) && this.localPort == this.remotePort) {
            return new Status(4, "org.eclipse.wst.internet.monitor.core", 0, Messages.errorInvalidLocalPort, null);
        }
        return new Status(0, "org.eclipse.wst.internet.monitor.core", 0, Messages.monitorValid, null);
    }

    protected static boolean isValidHostname(String host) {
        if (host == null || host.trim().length() < 1) {
            return false;
        }
        int length = host.length();
        int i = 0;
        while (i < length) {
            char c = host.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != ':' && c != '.') {
                return false;
            }
            ++i;
        }
        return !host.endsWith(":");
    }

    protected static boolean isLocalhost(String host) {
        if (host == null) {
            return false;
        }
        try {
            if ("localhost".equals(host) || "127.0.0.1".equals(host)) {
                return true;
            }
            InetAddress localHostaddr = InetAddress.getLocalHost();
            if (localHostaddr.getHostName().equals(host)) {
                return true;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Error checking for localhost", e);
        }
        return false;
    }

    public String toString() {
        return "Monitor [" + this.getId() + ", " + this.getProtocol() + ", " + this.getLocalPort() + ", " + this.getRemoteHost() + ", " + this.getRemotePort() + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Monitor)) {
            return false;
        }
        IMonitor m = (IMonitor)obj;
        if (m.isWorkingCopy() && (m = ((IMonitorWorkingCopy)m).getOriginal()) == null) {
            return false;
        }
        if (this.id == null && m.getId() != null) {
            return false;
        }
        if (this.id != null && !this.id.equals(m.getId())) {
            return false;
        }
        if (this.localPort != m.getLocalPort()) {
            return false;
        }
        if (this.remotePort != m.getRemotePort()) {
            return false;
        }
        if (this.remoteHost == null && m.getRemoteHost() != null) {
            return false;
        }
        if (this.remoteHost != null && !this.remoteHost.equals(m.getRemoteHost())) {
            return false;
        }
        if (this.protocolId == null && m.getProtocol() != null) {
            return false;
        }
        return this.protocolId == null || this.protocolId.equals(m.getProtocol());
    }
}

