/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.CodeGeneration;

public final class StubUtility2 {
    private static void addOverrideAnnotation(ASTRewrite rewrite, MethodDeclaration decl, IMethodBinding binding) {
        if (!binding.getDeclaringClass().isInterface()) {
            MarkerAnnotation marker = rewrite.getAST().newMarkerAnnotation();
            marker.setTypeName((Name)rewrite.getAST().newSimpleName("Override"));
            rewrite.getListRewrite((ASTNode)decl, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)marker, null);
        }
    }

    public static MethodDeclaration createConstructorStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, IMethodBinding binding, String type, int modifiers, boolean omitSuper, CodeGenerationSettings settings) throws CoreException {
        String string;
        String placeHolder;
        AST ast = rewrite.getAST();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers & 0xFFFFFBFF & 0xFFFFFEFF));
        decl.setName(ast.newSimpleName(type));
        decl.setConstructor(true);
        ITypeBinding[] typeParams = binding.getTypeParameters();
        List typeParameters = decl.typeParameters();
        int i = 0;
        while (i < typeParams.length) {
            ITypeBinding curr = typeParams[i];
            TypeParameter newTypeParam = ast.newTypeParameter();
            newTypeParam.setName(ast.newSimpleName(curr.getName()));
            ITypeBinding[] typeBounds = curr.getTypeBounds();
            if (typeBounds.length != 1 || !"java.lang.Object".equals(typeBounds[0].getQualifiedName())) {
                List newTypeBounds = newTypeParam.typeBounds();
                int k = 0;
                while (k < typeBounds.length) {
                    newTypeBounds.add(imports.addImport(typeBounds[k], ast));
                    ++k;
                }
            }
            typeParameters.add(newTypeParam);
            ++i;
        }
        List parameters = StubUtility2.createParameters(unit, imports, ast, binding, decl);
        List thrownExceptions = decl.thrownExceptions();
        ITypeBinding[] excTypes = binding.getExceptionTypes();
        int i2 = 0;
        while (i2 < excTypes.length) {
            String excTypeName = imports.addImport(excTypes[i2]);
            thrownExceptions.add(ASTNodeFactory.newName(ast, excTypeName));
            ++i2;
        }
        Block body = ast.newBlock();
        decl.setBody(body);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        String bodyStatement = "";
        if (!omitSuper) {
            SuperConstructorInvocation invocation = ast.newSuperConstructorInvocation();
            SingleVariableDeclaration varDecl = null;
            Iterator iterator = parameters.iterator();
            while (iterator.hasNext()) {
                varDecl = (SingleVariableDeclaration)iterator.next();
                invocation.arguments().add(ast.newSimpleName(varDecl.getName().getIdentifier()));
            }
            bodyStatement = ASTNodes.asFormattedString((ASTNode)invocation, 0, delimiter);
        }
        if ((placeHolder = CodeGeneration.getMethodBodyContent(unit, type, binding.getName(), true, bodyStatement, delimiter)) != null) {
            ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 41);
            body.statements().add(todoNode);
        }
        if (settings != null && settings.createComments && (string = StubUtility2.getMethodComment(unit, type, decl, binding, delimiter)) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    public static MethodDeclaration createConstructorStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ITypeBinding typeBinding, AST ast, IMethodBinding superConstructor, IVariableBinding[] variableBindings, int modifiers, CodeGenerationSettings settings) throws CoreException {
        String string;
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers & 0xFFFFFBFF & 0xFFFFFEFF));
        decl.setName(ast.newSimpleName(typeBinding.getName()));
        decl.setConstructor(true);
        List parameters = decl.parameters();
        if (superConstructor != null) {
            ITypeBinding[] typeParams = superConstructor.getTypeParameters();
            List typeParameters = decl.typeParameters();
            int i = 0;
            while (i < typeParams.length) {
                ITypeBinding curr = typeParams[i];
                TypeParameter newTypeParam = ast.newTypeParameter();
                newTypeParam.setName(ast.newSimpleName(curr.getName()));
                ITypeBinding[] typeBounds = curr.getTypeBounds();
                if (typeBounds.length != 1 || !"java.lang.Object".equals(typeBounds[0].getQualifiedName())) {
                    List newTypeBounds = newTypeParam.typeBounds();
                    int k = 0;
                    while (k < typeBounds.length) {
                        newTypeBounds.add(imports.addImport(typeBounds[k], ast));
                        ++k;
                    }
                }
                typeParameters.add(newTypeParam);
                ++i;
            }
            StubUtility2.createParameters(unit, imports, ast, superConstructor, decl);
            List thrownExceptions = decl.thrownExceptions();
            ITypeBinding[] excTypes = superConstructor.getExceptionTypes();
            int i2 = 0;
            while (i2 < excTypes.length) {
                String excTypeName = imports.addImport(excTypes[i2]);
                thrownExceptions.add(ASTNodeFactory.newName(ast, excTypeName));
                ++i2;
            }
        }
        Block body = ast.newBlock();
        decl.setBody(body);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        String bodyStatement = "";
        if (superConstructor != null) {
            SuperConstructorInvocation invocation = ast.newSuperConstructorInvocation();
            SingleVariableDeclaration varDecl = null;
            Iterator iterator = parameters.iterator();
            while (iterator.hasNext()) {
                varDecl = (SingleVariableDeclaration)iterator.next();
                invocation.arguments().add(ast.newSimpleName(varDecl.getName().getIdentifier()));
            }
            bodyStatement = ASTNodes.asFormattedString((ASTNode)invocation, 0, delimiter);
        }
        ArrayList<String> prohibited = new ArrayList<String>();
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            prohibited.add(((SingleVariableDeclaration)iterator.next()).getName().getIdentifier());
        }
        String param = null;
        ArrayList<String> list = new ArrayList<String>(prohibited);
        String[] excluded = null;
        int i = 0;
        while (i < variableBindings.length) {
            SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
            var.setType(imports.addImport(variableBindings[i].getType(), ast));
            excluded = new String[list.size()];
            list.toArray(excluded);
            param = StubUtility2.getParameterName(unit, variableBindings[i], excluded);
            list.add(param);
            var.setName(ast.newSimpleName(param));
            parameters.add(var);
            ++i;
        }
        String placeHolder = CodeGeneration.getMethodBodyContent(unit, typeBinding.getName(), typeBinding.getName(), true, bodyStatement, delimiter);
        if (placeHolder != null) {
            ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 41);
            body.statements().add(todoNode);
        }
        list = new ArrayList(prohibited);
        int i3 = 0;
        while (i3 < variableBindings.length) {
            excluded = new String[list.size()];
            list.toArray(excluded);
            String paramName = StubUtility2.getParameterName(unit, variableBindings[i3], excluded);
            list.add(paramName);
            String fieldName = variableBindings[i3].getName();
            SimpleName expression = null;
            if (paramName.equals(fieldName) || settings.useKeywordThis) {
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(fieldName));
                expression = access;
            } else {
                expression = ast.newSimpleName(fieldName);
            }
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide((Expression)expression);
            assignment.setRightHandSide((Expression)ast.newSimpleName(paramName));
            assignment.setOperator(Assignment.Operator.ASSIGN);
            body.statements().add(ast.newExpressionStatement((Expression)assignment));
            ++i3;
        }
        if (settings != null && settings.createComments && (string = StubUtility2.getMethodComment(unit, typeBinding.getName(), decl, superConstructor, delimiter)) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    public static MethodDeclaration createDelegationStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, AST ast, IBinding[] bindings, CodeGenerationSettings settings) throws CoreException {
        String string;
        Assert.isNotNull(bindings);
        Assert.isTrue(bindings.length == 2);
        Assert.isTrue(bindings[0] instanceof IVariableBinding);
        Assert.isTrue(bindings[1] instanceof IMethodBinding);
        IVariableBinding variableBinding = (IVariableBinding)bindings[0];
        IMethodBinding methodBinding = (IMethodBinding)bindings[1];
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, methodBinding.getModifiers() & 0xFFFFFFDF & 0xFFFFFBFF & 0xFFFFFEFF));
        decl.setName(ast.newSimpleName(methodBinding.getName()));
        decl.setConstructor(false);
        ITypeBinding[] typeParams = methodBinding.getTypeParameters();
        List typeParameters = decl.typeParameters();
        int i = 0;
        while (i < typeParams.length) {
            ITypeBinding curr = typeParams[i];
            TypeParameter newTypeParam = ast.newTypeParameter();
            newTypeParam.setName(ast.newSimpleName(curr.getName()));
            ITypeBinding[] typeBounds = curr.getTypeBounds();
            if (typeBounds.length != 1 || !"java.lang.Object".equals(typeBounds[0].getQualifiedName())) {
                List newTypeBounds = newTypeParam.typeBounds();
                int k = 0;
                while (k < typeBounds.length) {
                    newTypeBounds.add(imports.addImport(typeBounds[k], ast));
                    ++k;
                }
            }
            typeParameters.add(newTypeParam);
            ++i;
        }
        decl.setReturnType2(imports.addImport(methodBinding.getReturnType(), ast));
        List parameters = decl.parameters();
        ITypeBinding[] params = methodBinding.getParameterTypes();
        String[] paramNames = StubUtility2.suggestArgumentNames(unit.getJavaProject(), methodBinding);
        int i2 = 0;
        while (i2 < params.length) {
            SingleVariableDeclaration varDecl = ast.newSingleVariableDeclaration();
            if (params[i2].isWildcardType() && !params[i2].isUpperbound()) {
                varDecl.setType(imports.addImport(params[i2].getBound(), ast));
            } else if (methodBinding.isVarargs() && params[i2].isArray() && i2 == params.length - 1) {
                StringBuffer buffer = new StringBuffer(imports.addImport(params[i2].getElementType()));
                int dim = 1;
                while (dim < params[i2].getDimensions()) {
                    buffer.append("[]");
                    ++dim;
                }
                varDecl.setType(ASTNodeFactory.newType(ast, buffer.toString()));
                varDecl.setVarargs(true);
            } else {
                varDecl.setType(imports.addImport(params[i2], ast));
            }
            varDecl.setName(ast.newSimpleName(paramNames[i2]));
            parameters.add(varDecl);
            ++i2;
        }
        List thrownExceptions = decl.thrownExceptions();
        ITypeBinding[] excTypes = methodBinding.getExceptionTypes();
        int i3 = 0;
        while (i3 < excTypes.length) {
            String excTypeName = imports.addImport(excTypes[i3]);
            thrownExceptions.add(ASTNodeFactory.newName(ast, excTypeName));
            ++i3;
        }
        Block body = ast.newBlock();
        decl.setBody(body);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        ReturnStatement statement = null;
        MethodInvocation invocation = ast.newMethodInvocation();
        invocation.setName(ast.newSimpleName(methodBinding.getName()));
        List arguments = invocation.arguments();
        int i4 = 0;
        while (i4 < params.length) {
            arguments.add(ast.newSimpleName(paramNames[i4]));
            ++i4;
        }
        if (settings.useKeywordThis) {
            FieldAccess access = ast.newFieldAccess();
            access.setExpression((Expression)ast.newThisExpression());
            access.setName(ast.newSimpleName(variableBinding.getName()));
            invocation.setExpression((Expression)access);
        } else {
            invocation.setExpression((Expression)ast.newSimpleName(variableBinding.getName()));
        }
        if (methodBinding.getReturnType().isPrimitive() && methodBinding.getReturnType().getName().equals("void")) {
            statement = ast.newExpressionStatement((Expression)invocation);
        } else {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression((Expression)invocation);
            statement = returnStatement;
        }
        body.statements().add(statement);
        ITypeBinding declaringType = variableBinding.getDeclaringClass();
        String qualifiedName = declaringType.getQualifiedName();
        IPackageBinding packageBinding = declaringType.getPackage();
        if (packageBinding != null && packageBinding.getName().length() > 0 && qualifiedName.startsWith(packageBinding.getName())) {
            qualifiedName = qualifiedName.substring(packageBinding.getName().length());
        }
        if (settings != null && settings.createComments && (string = StubUtility2.getMethodComment(unit, qualifiedName, decl, methodBinding, delimiter)) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    public static MethodDeclaration createImplementationStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, AST ast, IMethodBinding binding, String type, CodeGenerationSettings settings, boolean deferred) throws CoreException {
        String string;
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.modifiers().addAll(StubUtility2.getImplementationModifiers(ast, binding, deferred));
        decl.setName(ast.newSimpleName(binding.getName()));
        decl.setConstructor(false);
        ITypeBinding[] typeParams = binding.getTypeParameters();
        List typeParameters = decl.typeParameters();
        int i = 0;
        while (i < typeParams.length) {
            ITypeBinding curr = typeParams[i];
            TypeParameter newTypeParam = ast.newTypeParameter();
            newTypeParam.setName(ast.newSimpleName(curr.getName()));
            ITypeBinding[] typeBounds = curr.getTypeBounds();
            if (typeBounds.length != 1 || !"java.lang.Object".equals(typeBounds[0].getQualifiedName())) {
                List newTypeBounds = newTypeParam.typeBounds();
                int k = 0;
                while (k < typeBounds.length) {
                    newTypeBounds.add(imports.addImport(typeBounds[k], ast));
                    ++k;
                }
            }
            typeParameters.add(newTypeParam);
            ++i;
        }
        decl.setReturnType2(imports.addImport(binding.getReturnType(), ast));
        List parameters = StubUtility2.createParameters(unit, imports, ast, binding, decl);
        List thrownExceptions = decl.thrownExceptions();
        ITypeBinding[] excTypes = binding.getExceptionTypes();
        int i2 = 0;
        while (i2 < excTypes.length) {
            String excTypeName = imports.addImport(excTypes[i2]);
            thrownExceptions.add(ASTNodeFactory.newName(ast, excTypeName));
            ++i2;
        }
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        if (!deferred) {
            String placeHolder;
            Block body = ast.newBlock();
            decl.setBody(body);
            String bodyStatement = "";
            ITypeBinding declaringType = binding.getDeclaringClass();
            if (Modifier.isAbstract((int)binding.getModifiers()) || declaringType.isAnnotation() || declaringType.isInterface()) {
                Expression expression = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType2(), decl.getExtraDimensions());
                if (expression != null) {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression(expression);
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter);
                }
            } else {
                SuperMethodInvocation invocation = ast.newSuperMethodInvocation();
                invocation.setName(ast.newSimpleName(binding.getName()));
                SingleVariableDeclaration varDecl = null;
                Iterator iterator = parameters.iterator();
                while (iterator.hasNext()) {
                    varDecl = (SingleVariableDeclaration)iterator.next();
                    invocation.arguments().add(ast.newSimpleName(varDecl.getName().getIdentifier()));
                }
                SuperMethodInvocation expression = invocation;
                Type returnType = decl.getReturnType2();
                if (returnType != null && returnType instanceof PrimitiveType && ((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.VOID)) {
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)ast.newExpressionStatement((Expression)expression), 0, delimiter);
                } else {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression((Expression)expression);
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter);
                }
            }
            if ((placeHolder = CodeGeneration.getMethodBodyContent(unit, type, binding.getName(), false, bodyStatement, delimiter)) != null) {
                ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 41);
                body.statements().add(todoNode);
            }
        }
        if (settings.createComments && (string = StubUtility2.getMethodComment(unit, type, decl, binding, delimiter)) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        if (settings.overrideAnnotation && JavaModelUtil.is50OrHigher(unit.getJavaProject())) {
            StubUtility2.addOverrideAnnotation(rewrite, decl, binding);
        }
        return decl;
    }

    public static MethodDeclaration createImplementationStub(ICompilationUnit unit, ASTRewrite rewrite, ImportsStructure structure, IMethodBinding binding, String type, boolean deferred, CodeGenerationSettings settings) throws CoreException {
        String string;
        AST ast = rewrite.getAST();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.modifiers().addAll(StubUtility2.getImplementationModifiers(ast, binding, deferred));
        decl.setName(ast.newSimpleName(binding.getName()));
        decl.setConstructor(false);
        ITypeBinding[] typeParams = binding.getTypeParameters();
        List typeParameters = decl.typeParameters();
        int index = 0;
        while (index < typeParams.length) {
            ITypeBinding curr = typeParams[index];
            TypeParameter newTypeParam = ast.newTypeParameter();
            newTypeParam.setName(ast.newSimpleName(curr.getName()));
            ITypeBinding[] typeBounds = curr.getTypeBounds();
            if (typeBounds.length != 1 || !"java.lang.Object".equals(typeBounds[0].getQualifiedName())) {
                List newTypeBounds = newTypeParam.typeBounds();
                int offset = 0;
                while (offset < typeBounds.length) {
                    newTypeBounds.add(StubUtility2.createTypeNode(structure, typeBounds[offset], ast));
                    ++offset;
                }
            }
            typeParameters.add(newTypeParam);
            ++index;
        }
        decl.setReturnType2(StubUtility2.createTypeNode(structure, binding.getReturnType(), ast));
        List parameters = StubUtility2.createParameters(unit, structure, ast, binding, decl);
        List thrownExceptions = decl.thrownExceptions();
        ITypeBinding[] excTypes = binding.getExceptionTypes();
        int index2 = 0;
        while (index2 < excTypes.length) {
            thrownExceptions.add(ASTNodeFactory.newName(ast, structure != null ? structure.addImport(excTypes[index2]) : excTypes[index2].getQualifiedName()));
            ++index2;
        }
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        if (!deferred) {
            String placeHolder;
            Block body = ast.newBlock();
            decl.setBody(body);
            String bodyStatement = "";
            ITypeBinding declaringType = binding.getDeclaringClass();
            if (Modifier.isAbstract((int)binding.getModifiers()) || declaringType.isAnnotation() || declaringType.isInterface()) {
                Expression expression = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType2(), decl.getExtraDimensions());
                if (expression != null) {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression(expression);
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter);
                }
            } else {
                SuperMethodInvocation invocation = ast.newSuperMethodInvocation();
                invocation.setName(ast.newSimpleName(binding.getName()));
                SingleVariableDeclaration varDecl = null;
                Iterator iterator = parameters.iterator();
                while (iterator.hasNext()) {
                    varDecl = (SingleVariableDeclaration)iterator.next();
                    invocation.arguments().add(ast.newSimpleName(varDecl.getName().getIdentifier()));
                }
                SuperMethodInvocation expression = invocation;
                Type returnType = decl.getReturnType2();
                if (returnType instanceof PrimitiveType && ((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.VOID)) {
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)ast.newExpressionStatement((Expression)expression), 0, delimiter);
                } else {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression((Expression)expression);
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter);
                }
            }
            if ((placeHolder = CodeGeneration.getMethodBodyContent(unit, type, binding.getName(), false, bodyStatement, delimiter)) != null) {
                ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 41);
                body.statements().add(todoNode);
            }
        }
        if (settings != null && settings.createComments && (string = StubUtility2.getMethodComment(unit, type, decl, binding, delimiter)) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        if (settings.overrideAnnotation && JavaModelUtil.is50OrHigher(unit.getJavaProject())) {
            StubUtility2.addOverrideAnnotation(rewrite, decl, binding);
        }
        return decl;
    }

    private static List createParameters(ICompilationUnit unit, ImportRewrite imports, AST ast, IMethodBinding binding, MethodDeclaration decl) {
        List parameters = decl.parameters();
        ITypeBinding[] params = binding.getParameterTypes();
        String[] paramNames = StubUtility2.suggestArgumentNames(unit.getJavaProject(), binding);
        int i = 0;
        while (i < params.length) {
            SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
            if (binding.isVarargs() && params[i].isArray() && i == params.length - 1) {
                StringBuffer buffer = new StringBuffer(imports.addImport(params[i].getElementType()));
                int dim = 1;
                while (dim < params[i].getDimensions()) {
                    buffer.append("[]");
                    ++dim;
                }
                var.setType(ASTNodeFactory.newType(ast, buffer.toString()));
                var.setVarargs(true);
            } else {
                var.setType(imports.addImport(params[i], ast));
            }
            var.setName(ast.newSimpleName(paramNames[i]));
            parameters.add(var);
            ++i;
        }
        return parameters;
    }

    private static List createParameters(ICompilationUnit unit, ImportsStructure structure, AST ast, IMethodBinding binding, MethodDeclaration decl) {
        List parameters = decl.parameters();
        ITypeBinding[] params = binding.getParameterTypes();
        String[] paramNames = StubUtility2.suggestArgumentNames(unit.getJavaProject(), binding);
        int i = 0;
        while (i < params.length) {
            SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
            if (binding.isVarargs() && params[i].isArray() && i == params.length - 1) {
                ITypeBinding elementType = params[i].getElementType();
                StringBuffer buffer = new StringBuffer(structure != null ? structure.addImport(elementType) : elementType.getQualifiedName());
                int dim = 1;
                while (dim < params[i].getDimensions()) {
                    buffer.append("[]");
                    ++dim;
                }
                var.setType(ASTNodeFactory.newType(ast, buffer.toString()));
                var.setVarargs(true);
            } else {
                var.setType(StubUtility2.createTypeNode(structure, params[i], ast));
            }
            var.setName(ast.newSimpleName(paramNames[i]));
            parameters.add(var);
            ++i;
        }
        return parameters;
    }

    private static Type createTypeNode(ImportsStructure structure, ITypeBinding binding, AST ast) {
        if (structure != null) {
            return structure.addImport(binding, ast);
        }
        return StubUtility2.createTypeNode(binding, ast);
    }

    private static Type createTypeNode(ITypeBinding binding, AST ast) {
        if (binding.isPrimitive()) {
            return ast.newPrimitiveType(PrimitiveType.toCode((String)binding.getName()));
        }
        ITypeBinding normalized = Bindings.normalizeTypeBinding(binding);
        if (normalized == null) {
            return ast.newSimpleType((Name)ast.newSimpleName("invalid"));
        }
        if (normalized.isTypeVariable()) {
            return ast.newSimpleType((Name)ast.newSimpleName(binding.getName()));
        }
        if (normalized.isWildcardType()) {
            WildcardType type = ast.newWildcardType();
            ITypeBinding bound = normalized.getBound();
            if (bound != null) {
                type.setBound(StubUtility2.createTypeNode(bound, ast), normalized.isUpperbound());
            }
            return type;
        }
        if (normalized.isArray()) {
            return ast.newArrayType(StubUtility2.createTypeNode(normalized.getElementType(), ast), normalized.getDimensions());
        }
        String qualified = Bindings.getRawQualifiedName(normalized);
        if (qualified.length() > 0) {
            ITypeBinding[] typeArguments = normalized.getTypeArguments();
            if (typeArguments.length > 0) {
                ParameterizedType type = ast.newParameterizedType((Type)ast.newSimpleType(ASTNodeFactory.newName(ast, qualified)));
                List arguments = type.typeArguments();
                int index = 0;
                while (index < typeArguments.length) {
                    arguments.add(StubUtility2.createTypeNode(typeArguments[index], ast));
                    ++index;
                }
                return type;
            }
            return ast.newSimpleType(ASTNodeFactory.newName(ast, qualified));
        }
        return ast.newSimpleType(ASTNodeFactory.newName(ast, Bindings.getRawName(normalized)));
    }

    private static IMethodBinding findMethodBinding(IMethodBinding method, List allMethods) {
        int i = 0;
        while (i < allMethods.size()) {
            IMethodBinding curr = (IMethodBinding)allMethods.get(i);
            if (Bindings.isSubsignature(method, curr)) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static IMethodBinding findOverridingMethod(IMethodBinding method, List allMethods) {
        int i = 0;
        while (i < allMethods.size()) {
            IMethodBinding curr = (IMethodBinding)allMethods.get(i);
            if (Bindings.areOverriddenMethods(curr, method) || Bindings.isSubsignature(curr, method)) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static void findUnimplementedInterfaceMethods(ITypeBinding typeBinding, HashSet visited, ArrayList allMethods, IPackageBinding currPack, ArrayList toImplement) {
        if (visited.add(typeBinding)) {
            IMethodBinding[] typeMethods = typeBinding.getDeclaredMethods();
            int i = 0;
            while (i < typeMethods.length) {
                IMethodBinding curr = typeMethods[i];
                IMethodBinding impl = StubUtility2.findMethodBinding(curr, allMethods);
                if (impl == null || !Bindings.isVisibleInHierarchy(impl, currPack) || curr.getExceptionTypes().length < impl.getExceptionTypes().length && !Modifier.isFinal((int)impl.getModifiers())) {
                    if (impl != null) {
                        allMethods.remove(impl);
                    }
                    toImplement.add(curr);
                    allMethods.add(curr);
                }
                ++i;
            }
            ITypeBinding[] superInterfaces = typeBinding.getInterfaces();
            int i2 = 0;
            while (i2 < superInterfaces.length) {
                StubUtility2.findUnimplementedInterfaceMethods(superInterfaces[i2], visited, allMethods, currPack, toImplement);
                ++i2;
            }
        }
    }

    public static IBinding[][] getDelegatableMethods(AST ast, ITypeBinding binding) {
        ArrayList tuples = new ArrayList();
        ArrayList<IMethodBinding> declared = new ArrayList<IMethodBinding>();
        IMethodBinding[] typeMethods = binding.getDeclaredMethods();
        int index = 0;
        while (index < typeMethods.length) {
            declared.add(typeMethods[index]);
            ++index;
        }
        IVariableBinding[] typeFields = binding.getDeclaredFields();
        int index2 = 0;
        while (index2 < typeFields.length) {
            IVariableBinding fieldBinding = typeFields[index2];
            if (fieldBinding.isField() && !fieldBinding.isEnumConstant() && !fieldBinding.isSynthetic()) {
                StubUtility2.getDelegatableMethods(ast, tuples, new ArrayList(declared), fieldBinding, fieldBinding.getType(), binding);
            }
            ++index2;
        }
        return (IBinding[][])tuples.toArray((T[])new IBinding[tuples.size()][2]);
    }

    private static void getDelegatableMethods(AST ast, List tuples, List methods, IVariableBinding fieldBinding, ITypeBinding typeBinding, ITypeBinding binding) {
        boolean match = false;
        if (typeBinding.isTypeVariable()) {
            ITypeBinding[] typeBounds = typeBinding.getTypeBounds();
            if (typeBounds == null || typeBounds.length == 0) {
                typeBounds = new ITypeBinding[]{ast.resolveWellKnownType("java.lang.Object")};
            }
            int index = 0;
            while (index < typeBounds.length) {
                int offset;
                IMethodBinding[] candidates = StubUtility2.getDelegateCandidates(typeBounds[index], binding);
                int candidate = 0;
                while (candidate < candidates.length) {
                    match = false;
                    IMethodBinding methodBinding = candidates[candidate];
                    offset = 0;
                    while (offset < methods.size() && !match) {
                        if (Bindings.areOverriddenMethods((IMethodBinding)methods.get(offset), methodBinding)) {
                            match = true;
                        }
                        ++offset;
                    }
                    if (!match) {
                        tuples.add(new IBinding[]{fieldBinding, methodBinding});
                        methods.add(methodBinding);
                    }
                    ++candidate;
                }
                ITypeBinding superclass = typeBounds[index].getSuperclass();
                if (superclass != null) {
                    StubUtility2.getDelegatableMethods(ast, tuples, methods, fieldBinding, superclass, binding);
                }
                ITypeBinding[] superInterfaces = typeBounds[index].getInterfaces();
                offset = 0;
                while (offset < superInterfaces.length) {
                    StubUtility2.getDelegatableMethods(ast, tuples, methods, fieldBinding, superInterfaces[offset], binding);
                    ++offset;
                }
                ++index;
            }
        } else {
            int offset;
            IMethodBinding[] candidates = StubUtility2.getDelegateCandidates(typeBinding, binding);
            int index = 0;
            while (index < candidates.length) {
                match = false;
                IMethodBinding methodBinding = candidates[index];
                offset = 0;
                while (offset < methods.size() && !match) {
                    if (Bindings.areOverriddenMethods((IMethodBinding)methods.get(offset), methodBinding)) {
                        match = true;
                    }
                    ++offset;
                }
                if (!match) {
                    tuples.add(new IBinding[]{fieldBinding, methodBinding});
                    methods.add(methodBinding);
                }
                ++index;
            }
            ITypeBinding superclass = typeBinding.getSuperclass();
            if (superclass != null) {
                StubUtility2.getDelegatableMethods(ast, tuples, methods, fieldBinding, superclass, binding);
            }
            ITypeBinding[] superInterfaces = typeBinding.getInterfaces();
            offset = 0;
            while (offset < superInterfaces.length) {
                StubUtility2.getDelegatableMethods(ast, tuples, methods, fieldBinding, superInterfaces[offset], binding);
                ++offset;
            }
        }
    }

    private static IMethodBinding[] getDelegateCandidates(ITypeBinding binding, ITypeBinding hierarchy) {
        ArrayList<IMethodBinding> allMethods = new ArrayList<IMethodBinding>();
        boolean isInterface = binding.isInterface();
        IMethodBinding[] typeMethods = binding.getDeclaredMethods();
        int index = 0;
        while (index < typeMethods.length) {
            int modifiers = typeMethods[index].getModifiers();
            if (!(typeMethods[index].isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isFinal((int)modifiers) || !isInterface && !Modifier.isPublic((int)modifiers))) {
                ITypeBinding[] parameterBindings = typeMethods[index].getParameterTypes();
                boolean upper = false;
                int offset = 0;
                while (offset < parameterBindings.length) {
                    if (parameterBindings[offset].isWildcardType() && parameterBindings[offset].isUpperbound()) {
                        upper = true;
                    }
                    ++offset;
                }
                if (!upper) {
                    allMethods.add(typeMethods[index]);
                }
            }
            ++index;
        }
        return allMethods.toArray(new IMethodBinding[allMethods.size()]);
    }

    private static List getImplementationModifiers(AST ast, IMethodBinding method, boolean deferred) {
        int modifiers = method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFFD;
        if (deferred) {
            modifiers &= 0xFFFFFFFB;
            modifiers |= 1;
        }
        return ASTNodeFactory.newModifiers(ast, modifiers);
    }

    private static String getMethodComment(ICompilationUnit cu, String typeName, MethodDeclaration decl, IMethodBinding overridden, String lineDelimiter) throws CoreException {
        if (overridden != null) {
            overridden = overridden.getMethodDeclaration();
            String declaringClassQualifiedName = overridden.getDeclaringClass().getQualifiedName();
            String[] parameterTypesQualifiedNames = StubUtility2.getParameterTypesQualifiedNames(overridden);
            return StubUtility.getMethodComment(cu, typeName, decl, true, overridden.isDeprecated(), declaringClassQualifiedName, parameterTypesQualifiedNames, lineDelimiter);
        }
        return StubUtility.getMethodComment(cu, typeName, decl, false, false, null, null, lineDelimiter);
    }

    public static IMethodBinding[] getOverridableMethods(AST ast, ITypeBinding typeBinding, boolean isSubType) {
        int index;
        int modifiers;
        ArrayList<IMethodBinding> allMethods = new ArrayList<IMethodBinding>();
        IMethodBinding[] typeMethods = typeBinding.getDeclaredMethods();
        int index2 = 0;
        while (index2 < typeMethods.length) {
            modifiers = typeMethods[index2].getModifiers();
            if (!(typeMethods[index2].isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers))) {
                allMethods.add(typeMethods[index2]);
            }
            ++index2;
        }
        ITypeBinding clazz = typeBinding.getSuperclass();
        while (clazz != null) {
            IMethodBinding[] methods = clazz.getDeclaredMethods();
            int offset = 0;
            while (offset < methods.length) {
                int modifiers2 = methods[offset].getModifiers();
                if (!(methods[offset].isConstructor() || Modifier.isStatic((int)modifiers2) || Modifier.isPrivate((int)modifiers2) || StubUtility2.findOverridingMethod(methods[offset], allMethods) != null)) {
                    allMethods.add(methods[offset]);
                }
                ++offset;
            }
            clazz = clazz.getSuperclass();
        }
        clazz = typeBinding;
        while (clazz != null) {
            ITypeBinding[] superInterfaces = clazz.getInterfaces();
            index = 0;
            while (index < superInterfaces.length) {
                StubUtility2.getOverridableMethods(ast, superInterfaces[index], allMethods);
                ++index;
            }
            clazz = clazz.getSuperclass();
        }
        if (typeBinding.isInterface()) {
            StubUtility2.getOverridableMethods(ast, ast.resolveWellKnownType("java.lang.Object"), allMethods);
        }
        if (!isSubType) {
            allMethods.removeAll(Arrays.asList(typeMethods));
        }
        modifiers = 0;
        if (!typeBinding.isInterface()) {
            index = allMethods.size() - 1;
            while (index >= 0) {
                IMethodBinding method = (IMethodBinding)allMethods.get(index);
                modifiers = method.getModifiers();
                if (Modifier.isFinal((int)modifiers)) {
                    allMethods.remove(index);
                }
                --index;
            }
        }
        return allMethods.toArray(new IMethodBinding[allMethods.size()]);
    }

    private static void getOverridableMethods(AST ast, ITypeBinding superBinding, List allMethods) {
        IMethodBinding[] methods = superBinding.getDeclaredMethods();
        int offset = 0;
        while (offset < methods.length) {
            int modifiers = methods[offset].getModifiers();
            if (!(methods[offset].isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers) || StubUtility2.findOverridingMethod(methods[offset], allMethods) != null || Modifier.isStatic((int)modifiers))) {
                allMethods.add(methods[offset]);
            }
            ++offset;
        }
        ITypeBinding[] superInterfaces = superBinding.getInterfaces();
        int index = 0;
        while (index < superInterfaces.length) {
            StubUtility2.getOverridableMethods(ast, superInterfaces[index], allMethods);
            ++index;
        }
    }

    private static String getParameterName(ICompilationUnit unit, IVariableBinding binding, String[] excluded) {
        String name = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)unit.getJavaProject(), (String)binding.getName(), (int)binding.getModifiers());
        return StubUtility.suggestArgumentName(unit.getJavaProject(), name, excluded);
    }

    private static String[] getParameterTypesQualifiedNames(IMethodBinding binding) {
        ITypeBinding[] typeBindings = binding.getParameterTypes();
        String[] result = new String[typeBindings.length];
        int i = 0;
        while (i < result.length) {
            if (typeBindings[i].isTypeVariable()) {
                result[i] = typeBindings[i].getName();
            } else if (binding.isVarargs() && typeBindings[i].isArray() && i == typeBindings.length - 1) {
                StringBuffer buffer = new StringBuffer(typeBindings[i].getElementType().getQualifiedName());
                int dim = 1;
                while (dim < typeBindings[i].getDimensions()) {
                    buffer.append("[]");
                    ++dim;
                }
                buffer.append("...");
                result[i] = buffer.toString();
            } else {
                result[i] = typeBindings[i].getTypeDeclaration().getQualifiedName();
            }
            ++i;
        }
        return result;
    }

    public static IMethodBinding[] getUnimplementedMethods(ITypeBinding typeBinding) {
        int modifiers;
        ArrayList<IMethodBinding> allMethods = new ArrayList<IMethodBinding>();
        ArrayList<IMethodBinding> toImplement = new ArrayList<IMethodBinding>();
        IMethodBinding[] typeMethods = typeBinding.getDeclaredMethods();
        int i = 0;
        while (i < typeMethods.length) {
            IMethodBinding curr = typeMethods[i];
            int modifiers2 = curr.getModifiers();
            if (!(curr.isConstructor() || Modifier.isStatic((int)modifiers2) || Modifier.isPrivate((int)modifiers2))) {
                allMethods.add(curr);
            }
            ++i;
        }
        ITypeBinding superClass = typeBinding.getSuperclass();
        while (superClass != null) {
            typeMethods = superClass.getDeclaredMethods();
            int i2 = 0;
            while (i2 < typeMethods.length) {
                IMethodBinding curr = typeMethods[i2];
                modifiers = curr.getModifiers();
                if (!(curr.isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers) || StubUtility2.findMethodBinding(curr, allMethods) != null)) {
                    allMethods.add(curr);
                }
                ++i2;
            }
            superClass = superClass.getSuperclass();
        }
        int i3 = 0;
        while (i3 < allMethods.size()) {
            IMethodBinding curr = (IMethodBinding)allMethods.get(i3);
            modifiers = curr.getModifiers();
            if ((Modifier.isAbstract((int)modifiers) || curr.getDeclaringClass().isInterface()) && typeBinding != curr.getDeclaringClass()) {
                toImplement.add(curr);
            }
            ++i3;
        }
        HashSet visited = new HashSet();
        ITypeBinding curr = typeBinding;
        while (curr != null) {
            ITypeBinding[] superInterfaces = curr.getInterfaces();
            int i4 = 0;
            while (i4 < superInterfaces.length) {
                StubUtility2.findUnimplementedInterfaceMethods(superInterfaces[i4], visited, allMethods, typeBinding.getPackage(), toImplement);
                ++i4;
            }
            curr = curr.getSuperclass();
        }
        return toImplement.toArray(new IMethodBinding[toImplement.size()]);
    }

    public static IMethodBinding[] getVisibleConstructors(ITypeBinding binding, boolean accountExisting, boolean proposeDefault) {
        IMethodBinding[] methods;
        ArrayList constructorMethods = new ArrayList();
        ArrayList<IMethodBinding> existingConstructors = null;
        ITypeBinding superType = binding.getSuperclass();
        if (superType == null) {
            return new IMethodBinding[0];
        }
        if (accountExisting) {
            methods = binding.getDeclaredMethods();
            existingConstructors = new ArrayList<IMethodBinding>(methods.length);
            int index = 0;
            while (index < methods.length) {
                IMethodBinding method = methods[index];
                if (method.isConstructor() && !method.isDefaultConstructor()) {
                    existingConstructors.add(method);
                }
                ++index;
            }
        }
        if (existingConstructors != null) {
            constructorMethods.addAll(existingConstructors);
        }
        methods = binding.getDeclaredMethods();
        IMethodBinding[] superMethods = superType.getDeclaredMethods();
        int index = 0;
        while (index < superMethods.length) {
            IMethodBinding method = superMethods[index];
            if (method.isConstructor() && Bindings.isVisibleInHierarchy(method, binding.getPackage()) && (!accountExisting || !Bindings.containsSignatureEquivalentConstructor(methods, method))) {
                constructorMethods.add(method);
            }
            ++index;
        }
        if (existingConstructors != null) {
            constructorMethods.removeAll(existingConstructors);
        }
        if (constructorMethods.isEmpty()) {
            superType = binding;
            while (superType.getSuperclass() != null) {
                superType = superType.getSuperclass();
            }
            IMethodBinding method = Bindings.findMethodInType(superType, "Object", new ITypeBinding[0]);
            if (!(!proposeDefault && accountExisting && !existingConstructors.isEmpty() || accountExisting && Bindings.containsSignatureEquivalentConstructor(methods, method))) {
                constructorMethods.add(method);
            }
        }
        return constructorMethods.toArray(new IMethodBinding[constructorMethods.size()]);
    }

    private static String[] suggestArgumentNames(IJavaProject project, IMethodBinding binding) {
        int nParams = binding.getParameterTypes().length;
        if (nParams > 0) {
            try {
                IMethod method = (IMethod)binding.getMethodDeclaration().getJavaElement();
                if (method != null) {
                    return StubUtility.suggestArgumentNames(project, method.getParameterNames());
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        String[] names = new String[nParams];
        int i = 0;
        while (i < names.length) {
            names[i] = "arg" + i;
            ++i;
        }
        return names;
    }

    private StubUtility2() {
    }
}

