/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.osgi.service.prefs.BackingStoreException;

class LinkedModeConfigurationBlock
extends AbstractConfigurationBlock {
    private static final String EXIT = "org.eclipse.jdt.ui.link.exit";
    private static final String TARGET = "org.eclipse.jdt.ui.link.target";
    private static final String MASTER = "org.eclipse.jdt.ui.link.master";
    private static final String SLAVE = "org.eclipse.jdt.ui.link.slave";
    static final String[] HIGHLIGHT = new String[]{PreferencesMessages.LinkedModeConfigurationBlock_HIGHLIGHT, "unused"};
    static final String[] UNDERLINE = new String[]{PreferencesMessages.LinkedModeConfigurationBlock_UNDERLINE, "UNDERLINE"};
    static final String[] BOX = new String[]{PreferencesMessages.LinkedModeConfigurationBlock_BOX, "BOX"};
    static final String[] IBEAM = new String[]{PreferencesMessages.LinkedModeConfigurationBlock_IBEAM, "IBEAM"};
    static final String[] SQUIGGLES = new String[]{PreferencesMessages.LinkedModeConfigurationBlock_SQUIGGLES, "SQUIGGLES"};
    private ColorSelector fAnnotationForegroundColorEditor;
    private Button fShowInTextCheckBox;
    private StructuredViewer fAnnotationTypeViewer;
    private final ListItem[] fListModel;
    private ComboViewer fDecorationViewer;
    private FontMetrics fFontMetrics;

    public LinkedModeConfigurationBlock(OverlayPreferenceStore store) {
        super(new OverlayPreferenceStore(EditorsUI.getPreferenceStore(), new OverlayPreferenceStore.OverlayKey[0]));
        MarkerAnnotationPreferences prefs = new MarkerAnnotationPreferences();
        this.getPreferenceStore().addKeys(this.createOverlayStoreKeys(prefs));
        this.fListModel = this.createAnnotationTypeListModel(prefs);
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys(MarkerAnnotationPreferences preferences) {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            if (!this.isLinkedModeAnnotation(info)) continue;
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getColorPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getTextPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getTextStylePreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getHighlightPreferenceKey()));
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    private boolean isLinkedModeAnnotation(AnnotationPreference info) {
        Object type = info.getAnnotationType();
        return type.equals(MASTER) || type.equals(SLAVE) || type.equals(TARGET) || type.equals(EXIT);
    }

    private ListItem[] createAnnotationTypeListModel(MarkerAnnotationPreferences preferences) {
        ArrayList<ListItem> listModelItems = new ArrayList<ListItem>();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            if (!this.isLinkedModeAnnotation(info)) continue;
            String label = info.getPreferenceLabel();
            List styles = this.getStyles(info.getAnnotationType());
            listModelItems.add(new ListItem(label, null, info.getColorPreferenceKey(), info.getTextPreferenceKey(), info.getOverviewRulerPreferenceKey(), info.getHighlightPreferenceKey(), info.getVerticalRulerPreferenceKey(), info.getTextStylePreferenceKey(), styles));
        }
        ListItem[] items = new ListItem[listModelItems.size()];
        listModelItems.toArray(items);
        return items;
    }

    private List getStyles(Object type) {
        if (type.equals(MASTER)) {
            return Arrays.asList(BOX, HIGHLIGHT, UNDERLINE, SQUIGGLES);
        }
        if (type.equals(SLAVE)) {
            return Arrays.asList(BOX, HIGHLIGHT, UNDERLINE, SQUIGGLES);
        }
        if (type.equals(TARGET)) {
            return Arrays.asList(BOX, HIGHLIGHT, UNDERLINE, SQUIGGLES);
        }
        if (type.equals(EXIT)) {
            return Arrays.asList(new String[][]{IBEAM});
        }
        return new ArrayList();
    }

    public Control createControl(Composite parent) {
        OverlayPreferenceStore store = this.getPreferenceStore();
        store.load();
        store.start();
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 16384);
        label.setText(PreferencesMessages.LinkedModeConfigurationBlock_annotationPresentationOptions);
        GridData gd = new GridData(256);
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(4, 4, true, true);
        editorComposite.setLayoutData((Object)gd);
        this.fAnnotationTypeViewer = new TableViewer(editorComposite, 2564);
        this.fAnnotationTypeViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
        this.fAnnotationTypeViewer.setContentProvider((IContentProvider)new ItemContentProvider());
        gd = new GridData(1, 1, false, false);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fAnnotationTypeViewer.getControl().setLayoutData((Object)gd);
        Composite optionsComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        optionsComposite.setLayout((Layout)layout);
        optionsComposite.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fShowInTextCheckBox = new Button(optionsComposite, 32);
        this.fShowInTextCheckBox.setText(PreferencesMessages.LinkedModeConfigurationBlock_labels_showIn);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        this.fShowInTextCheckBox.setLayoutData((Object)gd);
        this.fDecorationViewer = new ComboViewer(optionsComposite, 8);
        this.fDecorationViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fDecorationViewer.setLabelProvider((IBaseLabelProvider)new ArrayLabelProvider());
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        this.fDecorationViewer.getControl().setLayoutData((Object)gd);
        this.fDecorationViewer.setInput((Object)new Object[]{HIGHLIGHT, SQUIGGLES, BOX, UNDERLINE, IBEAM});
        label = new Label(optionsComposite, 16384);
        label.setText(PreferencesMessages.LinkedModeConfigurationBlock_color);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fAnnotationForegroundColorEditor = new ColorSelector(optionsComposite);
        Button foregroundColorButton = this.fAnnotationForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.createDependency(this.fShowInTextCheckBox, new Control[]{label, foregroundColorButton});
        this.fAnnotationTypeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LinkedModeConfigurationBlock.this.handleAnnotationListSelection();
            }
        });
        this.fShowInTextCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ListItem item = LinkedModeConfigurationBlock.this.getSelectedItem();
                boolean value = LinkedModeConfigurationBlock.this.fShowInTextCheckBox.getSelection();
                if (value) {
                    String[] decoration = (String[])((IStructuredSelection)LinkedModeConfigurationBlock.this.fDecorationViewer.getSelection()).getFirstElement();
                    if (HIGHLIGHT.equals(decoration)) {
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.highlightKey, true);
                    } else {
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.textKey, true);
                    }
                } else {
                    LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.textKey, false);
                    LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.highlightKey, false);
                }
                LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.textKey, value);
                LinkedModeConfigurationBlock.this.updateDecorationViewer(item, false);
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ListItem item = LinkedModeConfigurationBlock.this.getSelectedItem();
                PreferenceConverter.setValue((IPreferenceStore)LinkedModeConfigurationBlock.this.getPreferenceStore(), (String)item.colorKey, (RGB)LinkedModeConfigurationBlock.this.fAnnotationForegroundColorEditor.getColorValue());
            }
        });
        this.fDecorationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String[] decoration = (String[])((IStructuredSelection)LinkedModeConfigurationBlock.this.fDecorationViewer.getSelection()).getFirstElement();
                ListItem item = LinkedModeConfigurationBlock.this.getSelectedItem();
                if (LinkedModeConfigurationBlock.this.fShowInTextCheckBox.getSelection()) {
                    if (HIGHLIGHT.equals(decoration)) {
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.highlightKey, true);
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.textKey, false);
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.textStyleKey, "NONE");
                    } else {
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.highlightKey, false);
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.textKey, true);
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(item.textStyleKey, decoration[1]);
                    }
                }
            }
        });
        return composite;
    }

    protected int convertWidthInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    protected int convertHeightInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    protected void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        this.fFontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private void handleAnnotationListSelection() {
        ListItem item = this.getSelectedItem();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)item.colorKey);
        this.fAnnotationForegroundColorEditor.setColorValue(rgb);
        boolean highlight = item.highlightKey == null ? false : this.getPreferenceStore().getBoolean(item.highlightKey);
        boolean showInText = item.textKey == null ? false : this.getPreferenceStore().getBoolean(item.textKey);
        this.fShowInTextCheckBox.setSelection(showInText || highlight);
        this.updateDecorationViewer(item, true);
    }

    public void initialize() {
        super.initialize();
        this.fAnnotationTypeViewer.setInput((Object)this.fListModel);
        this.fAnnotationTypeViewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (LinkedModeConfigurationBlock.this.fAnnotationTypeViewer != null && !LinkedModeConfigurationBlock.this.fAnnotationTypeViewer.getControl().isDisposed()) {
                    LinkedModeConfigurationBlock.this.fAnnotationTypeViewer.setSelection((ISelection)new StructuredSelection((Object)LinkedModeConfigurationBlock.this.fListModel[0]));
                    LinkedModeConfigurationBlock.super.initialize();
                }
            }
        });
    }

    private ListItem getSelectedItem() {
        return (ListItem)((IStructuredSelection)this.fAnnotationTypeViewer.getSelection()).getFirstElement();
    }

    private void updateDecorationViewer(ListItem item, boolean changed) {
        boolean enabled = this.fShowInTextCheckBox.getSelection() && (item.highlightKey != null || item.textStyleKey != null);
        this.fDecorationViewer.getControl().setEnabled(enabled);
        if (changed) {
            String[] selection = null;
            ArrayList list = new ArrayList();
            list.addAll(item.validStyles);
            if (this.getPreferenceStore().getBoolean(item.highlightKey)) {
                selection = HIGHLIGHT;
            }
            if (selection == null) {
                String val = this.getPreferenceStore().getString(item.textStyleKey);
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    String[] elem = (String[])iter.next();
                    if (!elem[1].equals(val)) continue;
                    selection = elem;
                    break;
                }
            }
            this.fDecorationViewer.setInput((Object)list.toArray(new Object[list.size()]));
            if (selection == null) {
                selection = (String[])list.get(0);
            }
            this.fDecorationViewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
        }
    }

    public void performOk() {
        super.performOk();
        this.getPreferenceStore().propagate();
        try {
            Platform.getPreferencesService().getRootNode().node("instance").node("org.eclipse.ui.editors").flush();
        }
        catch (BackingStoreException e) {
            JavaPlugin.log(e);
        }
    }

    public void performDefaults() {
        this.getPreferenceStore().loadDefaults();
        this.handleAnnotationListSelection();
        super.performDefaults();
    }

    public void dispose() {
        OverlayPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            store.stop();
        }
        super.dispose();
    }

    private static final class ListItem {
        final String label;
        final Image image;
        final String colorKey;
        final String highlightKey;
        final String overviewRulerKey;
        final String textStyleKey;
        final String textKey;
        final String verticalRulerKey;
        final List validStyles;

        ListItem(String label, Image image, String colorKey, String textKey, String overviewRulerKey, String highlightKey, String verticalRulerKey, String textStyleKey, List validStyles) {
            this.label = label;
            this.image = image;
            this.colorKey = colorKey;
            this.highlightKey = highlightKey;
            this.overviewRulerKey = overviewRulerKey;
            this.textKey = textKey;
            this.textStyleKey = textStyleKey;
            this.verticalRulerKey = verticalRulerKey;
            this.validStyles = validStyles;
        }
    }

    private static final class ItemContentProvider
    implements IStructuredContentProvider {
        ItemContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (ListItem[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ItemLabelProvider
    extends LabelProvider {
        ItemLabelProvider() {
        }

        public String getText(Object element) {
            return ((ListItem)element).label;
        }
    }

    private static class ArrayLabelProvider
    extends LabelProvider {
        ArrayLabelProvider() {
        }

        public String getText(Object element) {
            return ((String[])element)[0].toString();
        }
    }
}

