/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.SerialVersionDefaultProposal;
import org.eclipse.jdt.internal.ui.text.correction.SerialVersionHashProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public final class SerialVersionSubProcessor {
    public static final void getSerialVersionProposals(IInvocationContext context, IProblemLocation location, Collection proposals) {
        Assert.isNotNull(context);
        Assert.isNotNull(location);
        Assert.isNotNull(proposals);
        CompilationUnit root = context.getASTRoot();
        ASTNode selection = location.getCoveredNode(root);
        if (selection != null) {
            SimpleType type;
            Name name = null;
            if (selection instanceof SimpleType) {
                type = (SimpleType)selection;
                name = type.getName();
            } else if (selection instanceof ParameterizedType) {
                type = (ParameterizedType)selection;
                Type raw = type.getType();
                if (raw instanceof SimpleType) {
                    name = ((SimpleType)raw).getName();
                } else if (raw instanceof QualifiedType) {
                    name = ((QualifiedType)raw).getName();
                }
            } else if (selection instanceof Name) {
                name = (Name)selection;
            }
            if (name != null) {
                SimpleName simple = name.isSimpleName() ? (SimpleName)name : ((QualifiedName)name).getName();
                ICompilationUnit unit = context.getCompilationUnit();
                if (JavaModelUtil.isEditable(unit)) {
                    proposals.add(new SerialVersionDefaultProposal(unit, (ASTNode)simple));
                    proposals.add(new SerialVersionHashProposal(unit, (ASTNode)simple));
                }
            }
        }
    }
}

