/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ExclusionInclusionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.OutputLocationDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ExtendedNewFolderDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.LinkFolderDialog;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ClasspathModifierQueries {
    public static OutputFolderQuery getDefaultFolderQuery(final Shell shell, IPath outputLocation) {
        return new OutputFolderQuery(outputLocation){
            protected IPath fOutputLocation;
            protected boolean fRemoveProject;

            public boolean doQuery(boolean editingOutputFolder, OutputFolderValidator validator, IJavaProject project) throws JavaModelException {
                boolean[] result = new boolean[1];
                this.fRemoveProject = false;
                this.fOutputLocation = project.getOutputLocation();
                Display.getDefault().syncExec(new Runnable(this, shell, validator, result, editingOutputFolder){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ OutputFolderValidator val$validator;
                    private final /* synthetic */ boolean[] val$result;
                    private final /* synthetic */ boolean val$editingOutputFolder;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$validator = outputFolderValidator;
                        this.val$result = blArray;
                        this.val$editingOutputFolder = bl;
                    }

                    public void run() {
                        Shell sh = this.val$shell != null ? this.val$shell : JavaPlugin.getActiveWorkbenchShell();
                        String title = NewWizardMessages.ClasspathModifier_ChangeOutputLocationDialog_title;
                        if (this.this$1.fDesiredOutputLocation.segmentCount() == 1) {
                            String outputFolderName = PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
                            IPath newOutputFolder = this.this$1.fDesiredOutputLocation.append(outputFolderName);
                            newOutputFolder = 2.access$0(this.this$1, newOutputFolder, this.val$validator);
                            String message = Messages.format(NewWizardMessages.ClasspathModifier_ChangeOutputLocationDialog_project_outputLocation, newOutputFolder);
                            this.this$1.fRemoveProject = true;
                            if (MessageDialog.openConfirm((Shell)sh, (String)title, (String)message)) {
                                this.this$1.fOutputLocation = newOutputFolder;
                                this.val$result[0] = true;
                            }
                        } else {
                            IPath newOutputFolder = this.this$1.fDesiredOutputLocation;
                            newOutputFolder = 2.access$0(this.this$1, newOutputFolder, this.val$validator);
                            if (this.val$editingOutputFolder) {
                                this.this$1.fOutputLocation = newOutputFolder;
                                this.val$result[0] = true;
                                return;
                            }
                            String message = NewWizardMessages.ClasspathModifier_ChangeOutputLocationDialog_project_message;
                            this.this$1.fRemoveProject = true;
                            if (MessageDialog.openQuestion((Shell)sh, (String)title, (String)message)) {
                                this.this$1.fOutputLocation = newOutputFolder;
                                this.val$result[0] = true;
                            }
                        }
                    }
                });
                return result[0];
            }

            public IPath getOutputLocation() {
                return this.fOutputLocation;
            }

            public boolean removeProjectFromClasspath() {
                return this.fRemoveProject;
            }

            private IPath getValidPath(IPath newOutputFolder, OutputFolderValidator validator) {
                int i = 1;
                IPath path = newOutputFolder;
                while (!validator.validate(path)) {
                    path = new Path(String.valueOf(newOutputFolder.toString()) + i);
                    ++i;
                }
                return path;
            }

            static /* synthetic */ IPath access$0(2 var0, IPath iPath, OutputFolderValidator outputFolderValidator) {
                return var0.getValidPath(iPath, outputFolderValidator);
            }
        };
    }

    public static IInclusionExclusionQuery getDefaultInclusionExclusionQuery(final Shell shell) {
        return new IInclusionExclusionQuery(){
            protected IPath[] fInclusionPattern;
            protected IPath[] fExclusionPattern;

            public boolean doQuery(CPListElement element, boolean focusOnExcluded) {
                boolean[] result = new boolean[1];
                Display.getDefault().syncExec(new Runnable(this, shell, element, focusOnExcluded, result){
                    final /* synthetic */ 4 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ CPListElement val$element;
                    private final /* synthetic */ boolean val$focusOnExcluded;
                    private final /* synthetic */ boolean[] val$result;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$element = cPListElement;
                        this.val$focusOnExcluded = bl;
                        this.val$result = blArray;
                    }

                    public void run() {
                        Shell sh = this.val$shell != null ? this.val$shell : JavaPlugin.getActiveWorkbenchShell();
                        ExclusionInclusionDialog dialog = new ExclusionInclusionDialog(sh, this.val$element, this.val$focusOnExcluded);
                        this.val$result[0] = dialog.open() == 0;
                        this.this$1.fInclusionPattern = dialog.getInclusionPattern();
                        this.this$1.fExclusionPattern = dialog.getExclusionPattern();
                    }
                });
                return result[0];
            }

            public IPath[] getInclusionPattern() {
                return this.fInclusionPattern;
            }

            public IPath[] getExclusionPattern() {
                return this.fExclusionPattern;
            }
        };
    }

    public static IOutputLocationQuery getDefaultOutputLocationQuery(final Shell shell, final IPath projectOutputLocation, final List classpathList) {
        return new IOutputLocationQuery(){
            protected IPath fOutputLocation;

            public boolean doQuery(CPListElement element) {
                boolean[] result = new boolean[1];
                Display.getDefault().syncExec(new Runnable(this, shell, element, classpathList, result){
                    final /* synthetic */ 6 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ CPListElement val$element;
                    private final /* synthetic */ List val$classpathList;
                    private final /* synthetic */ boolean[] val$result;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$element = cPListElement;
                        this.val$classpathList = list;
                        this.val$result = blArray;
                    }

                    public void run() {
                        Shell sh = this.val$shell != null ? this.val$shell : JavaPlugin.getActiveWorkbenchShell();
                        OutputLocationDialog dialog = new OutputLocationDialog(sh, this.val$element, this.val$classpathList);
                        this.val$result[0] = dialog.open() == 0;
                        this.this$1.fOutputLocation = dialog.getOutputLocation();
                    }
                });
                return result[0];
            }

            public IPath getOutputLocation() {
                return this.fOutputLocation;
            }

            public OutputFolderQuery getOutputFolderQuery(IPath p) {
                return ClasspathModifierQueries.getDefaultFolderQuery(shell, projectOutputLocation);
            }
        };
    }

    public static IFolderCreationQuery getDefaultFolderCreationQuery(final Shell shell, final Object selection) {
        return new IFolderCreationQuery(){
            protected boolean fIsSourceFolder;
            protected IFolder fFolder;

            public boolean doQuery() {
                boolean[] isOK = new boolean[1];
                Display.getDefault().syncExec(new Runnable(this, shell, selection, isOK){
                    final /* synthetic */ 8 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ Object val$selection;
                    private final /* synthetic */ boolean[] val$isOK;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$selection = object;
                        this.val$isOK = blArray;
                    }

                    public void run() {
                        ExtendedNewFolderDialog dialog;
                        IFolder container;
                        Shell sh;
                        Shell shell = sh = this.val$shell != null ? this.val$shell : JavaPlugin.getActiveWorkbenchShell();
                        if (this.val$selection instanceof IFolder) {
                            container = (IFolder)this.val$selection;
                        } else {
                            IJavaElement javaElement = (IJavaElement)this.val$selection;
                            IJavaProject project = javaElement.getJavaProject();
                            container = project.getProject();
                            if (!(this.val$selection instanceof IJavaProject)) {
                                container = container.getFolder(javaElement.getPath().removeFirstSegments(1));
                            }
                        }
                        boolean javaProjectSelected = false;
                        if (this.val$selection instanceof IJavaProject) {
                            javaProjectSelected = true;
                        }
                        boolean bl = this.val$isOK[0] = (dialog = new ExtendedNewFolderDialog(sh, (IContainer)container, javaProjectSelected)).open() == 0;
                        if (this.val$isOK[0]) {
                            this.this$1.fFolder = dialog.getCreatedFolder();
                            this.this$1.fIsSourceFolder = dialog.isSourceFolder();
                        }
                    }
                });
                return isOK[0];
            }

            public boolean isSourceFolder() {
                return this.fIsSourceFolder;
            }

            public IFolder getCreatedFolder() {
                return this.fFolder;
            }
        };
    }

    public static ILinkToQuery getDefaultLinkQuery(final Shell shell, final IJavaProject project, final IPath desiredOutputLocation) {
        return new ILinkToQuery(){
            protected IFolder fFolder;

            public boolean doQuery() {
                boolean[] isOK = new boolean[1];
                Display.getDefault().syncExec(new Runnable(this, shell, project, isOK){
                    final /* synthetic */ 10 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ IJavaProject val$project;
                    private final /* synthetic */ boolean[] val$isOK;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$project = iJavaProject;
                        this.val$isOK = blArray;
                    }

                    public void run() {
                        Shell sh = this.val$shell != null ? this.val$shell : JavaPlugin.getActiveWorkbenchShell();
                        LinkFolderDialog dialog = new LinkFolderDialog(sh, (IContainer)this.val$project.getProject());
                        boolean bl = this.val$isOK[0] = dialog.open() == 0;
                        if (this.val$isOK[0]) {
                            this.this$1.fFolder = dialog.getCreatedFolder();
                        }
                    }
                });
                return isOK[0];
            }

            public IFolder getCreatedFolder() {
                return this.fFolder;
            }

            public OutputFolderQuery getOutputFolderQuery() {
                return ClasspathModifierQueries.getDefaultFolderQuery(shell, desiredOutputLocation);
            }
        };
    }

    public static IAddArchivesQuery getDefaultArchivesQuery(final Shell shell) {
        return new IAddArchivesQuery(){

            public IPath[] doQuery() {
                IPath[][] selected = new IPath[1][];
                Display.getDefault().syncExec(new Runnable(this, shell, selected){
                    final /* synthetic */ 12 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ IPath[][] val$selected;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$selected = iPathArray;
                    }

                    public void run() {
                        Shell sh = this.val$shell != null ? this.val$shell : JavaPlugin.getActiveWorkbenchShell();
                        this.val$selected[0] = BuildPathDialogAccess.chooseExternalJAREntries(sh);
                    }
                });
                if (selected[0] == null) {
                    return new IPath[0];
                }
                return selected[0];
            }
        };
    }

    public static IRemoveLinkedFolderQuery getDefaultRemoveLinkedFolderQuery(final Shell shell) {
        return new IRemoveLinkedFolderQuery(){

            public final int doQuery(IFolder folder) {
                int[] result = new int[]{1};
                Display.getDefault().syncExec(new Runnable(this, shell, folder, result){
                    final /* synthetic */ 14 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ IFolder val$folder;
                    private final /* synthetic */ int[] val$result;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$folder = iFolder;
                        this.val$result = nArray;
                    }

                    public final void run() {
                        RemoveLinkedFolderDialog dialog = new RemoveLinkedFolderDialog(this.val$shell != null ? this.val$shell : JavaPlugin.getActiveWorkbenchShell(), this.val$folder);
                        int status = dialog.open();
                        this.val$result[0] = status == 0 ? dialog.getRemoveStatus() : 0;
                    }
                });
                return result[0];
            }
        };
    }

    public static IAddLibrariesQuery getDefaultLibrariesQuery(final Shell shell) {
        return new IAddLibrariesQuery(){

            public IClasspathEntry[] doQuery(IJavaProject project, IClasspathEntry[] entries) {
                IClasspathEntry[][] selected = new IClasspathEntry[1][];
                Display.getDefault().syncExec(new Runnable(this, shell, selected, project, entries){
                    final /* synthetic */ 16 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ IClasspathEntry[][] val$selected;
                    private final /* synthetic */ IJavaProject val$project;
                    private final /* synthetic */ IClasspathEntry[] val$entries;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$selected = iClasspathEntryArray;
                        this.val$project = iJavaProject;
                        this.val$entries = iClasspathEntryArray2;
                    }

                    public void run() {
                        Shell sh = this.val$shell != null ? this.val$shell : JavaPlugin.getActiveWorkbenchShell();
                        this.val$selected[0] = BuildPathDialogAccess.chooseContainerEntries(sh, this.val$project, this.val$entries);
                    }
                });
                if (selected[0] == null) {
                    return new IClasspathEntry[0];
                }
                return selected[0];
            }
        };
    }

    private static class RemoveLinkedFolderDialog
    extends MessageDialog {
        private int fRemoveStatus = 2;
        private Button fRemoveBuildPathAndFolder;
        private Button fRemoveBuildPath;
        private SelectionListener selectionListener = new SelectionAdapter(this){
            final /* synthetic */ RemoveLinkedFolderDialog this$1;
            {
                this.this$1 = removeLinkedFolderDialog;
            }

            public final void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    RemoveLinkedFolderDialog.access$1(this.this$1, button == RemoveLinkedFolderDialog.access$0(this.this$1) ? 2 : 1);
                }
            }
        };

        RemoveLinkedFolderDialog(Shell shell, IFolder folder) {
            super(shell, NewWizardMessages.ClasspathModifierQueries_confirm_remove_linked_folder_label, null, MessageFormat.format(NewWizardMessages.ClasspathModifierQueries_confirm_remove_linked_folder_message, folder.getFullPath()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            Assert.isTrue(folder.isLinked());
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.fRemoveBuildPathAndFolder = new Button(composite, 16);
            this.fRemoveBuildPathAndFolder.addSelectionListener(this.selectionListener);
            this.fRemoveBuildPathAndFolder.setText(NewWizardMessages.ClasspathModifierQueries_delete_linked_folder);
            this.fRemoveBuildPathAndFolder.setFont(parent.getFont());
            this.fRemoveBuildPath = new Button(composite, 16);
            this.fRemoveBuildPath.addSelectionListener(this.selectionListener);
            this.fRemoveBuildPath.setText(NewWizardMessages.ClasspathModifierQueries_do_not_delete_linked_folder);
            this.fRemoveBuildPath.setFont(parent.getFont());
            this.fRemoveBuildPathAndFolder.setSelection(this.fRemoveStatus == 2);
            this.fRemoveBuildPath.setSelection(this.fRemoveStatus == 1);
            return composite;
        }

        public final int getRemoveStatus() {
            return this.fRemoveStatus;
        }

        static /* synthetic */ Button access$0(RemoveLinkedFolderDialog removeLinkedFolderDialog) {
            return removeLinkedFolderDialog.fRemoveBuildPathAndFolder;
        }

        static /* synthetic */ void access$1(RemoveLinkedFolderDialog removeLinkedFolderDialog, int n) {
            removeLinkedFolderDialog.fRemoveStatus = n;
        }
    }

    public static abstract class OutputFolderValidator {
        protected IClasspathEntry[] fEntries;
        protected List fElements;

        public OutputFolderValidator(List newElements, IJavaProject project) throws JavaModelException {
            this.fEntries = project.getRawClasspath();
            this.fElements = newElements;
        }

        public abstract boolean validate(IPath var1);
    }

    public static interface ILinkToQuery {
        public boolean doQuery();

        public IFolder getCreatedFolder();

        public OutputFolderQuery getOutputFolderQuery();
    }

    public static abstract class OutputFolderQuery {
        protected IPath fDesiredOutputLocation;

        public OutputFolderQuery(IPath outputLocation) {
            if (outputLocation != null) {
                this.fDesiredOutputLocation = outputLocation.makeAbsolute();
            }
        }

        public IPath getDesiredOutputLocation() {
            return this.fDesiredOutputLocation;
        }

        public abstract IPath getOutputLocation();

        public abstract boolean removeProjectFromClasspath();

        public abstract boolean doQuery(boolean var1, OutputFolderValidator var2, IJavaProject var3) throws JavaModelException;
    }

    public static interface IInclusionExclusionQuery {
        public boolean doQuery(CPListElement var1, boolean var2);

        public IPath[] getInclusionPattern();

        public IPath[] getExclusionPattern();
    }

    public static interface IOutputLocationQuery {
        public boolean doQuery(CPListElement var1);

        public IPath getOutputLocation();

        public OutputFolderQuery getOutputFolderQuery(IPath var1) throws JavaModelException;
    }

    public static interface IRemoveLinkedFolderQuery {
        public static final int REMOVE_CANCEL = 0;
        public static final int REMOVE_BUILD_PATH = 1;
        public static final int REMOVE_BUILD_PATH_AND_FOLDER = 2;

        public int doQuery(IFolder var1);
    }

    public static interface IFolderCreationQuery {
        public boolean doQuery();

        public boolean isSourceFolder();

        public IFolder getCreatedFolder();
    }

    public static interface IAddArchivesQuery {
        public IPath[] doQuery();
    }

    public static interface IAddLibrariesQuery {
        public IClasspathEntry[] doQuery(IJavaProject var1, IClasspathEntry[] var2);
    }
}

