/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.internal.proxy;

import java.util.Properties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.internet.internal.proxy.Encoder;
import org.eclipse.wst.internet.internal.proxy.InternetPlugin;
import org.eclipse.wst.internet.internal.proxy.NonProxyHostsComposite;

public class InternetPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button proxyCheckBox_;
    private Text hostnameTextField_;
    private Text portTextField_;
    private Button socksCheckBox_;
    private Button nameCheckBox_;
    private Text userNameTextField_;
    private Text passwordTextField_;
    private NonProxyHostsComposite hostsList_;

    protected Control createContents(Composite superparent) {
        Composite parent = new Composite(superparent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        this.proxyCheckBox_ = this.createCheckBox(parent, InternetPlugin.getMessage("%CHECKBOX_PREFERENCE_ENABLE_PROXY"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.proxyCheckBox_.setLayoutData((Object)gd);
        this.proxyCheckBox_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                boolean selected = InternetPreferencePage.this.proxyCheckBox_.getSelection();
                InternetPreferencePage.this.hostnameTextField_.setEnabled(selected);
                InternetPreferencePage.this.portTextField_.setEnabled(selected);
                InternetPreferencePage.this.hostsList_.setEnabled(selected);
                InternetPreferencePage.this.socksCheckBox_.setEnabled(selected);
                InternetPreferencePage.this.socksCheckBox_.setSelection(false);
                InternetPreferencePage.this.nameCheckBox_.setEnabled(selected);
                InternetPreferencePage.this.nameCheckBox_.setSelection(false);
                InternetPreferencePage.this.userNameTextField_.setEnabled(false);
                InternetPreferencePage.this.passwordTextField_.setEnabled(false);
            }
        });
        this.createLabel(parent, InternetPlugin.getMessage("%LABEL_PREFERENCE_HOSTNAME"));
        this.hostnameTextField_ = this.createTextField(parent);
        this.createLabel(parent, InternetPlugin.getMessage("%LABEL_PREFERENCE_PORT"));
        this.portTextField_ = this.createTextField(parent);
        this.createLabel(parent, InternetPlugin.getMessage("%LABEL_PREFERENCE_NON_PROXY_HOSTNAMES"));
        this.hostsList_ = new NonProxyHostsComposite(parent, 0);
        GridData data = new GridData(768);
        this.hostsList_.setLayoutData(data);
        this.createLabel(parent, "");
        this.createLabel(parent, "");
        this.socksCheckBox_ = this.createCheckBox(parent, InternetPlugin.getMessage("%CHECKBOX_PREFERENCE_USE_SOCKS"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.socksCheckBox_.setLayoutData((Object)gd);
        this.socksCheckBox_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                boolean selected = InternetPreferencePage.this.socksCheckBox_.getSelection();
                InternetPreferencePage.this.nameCheckBox_.setEnabled(!selected);
                if (!InternetPreferencePage.this.nameCheckBox_.getEnabled()) {
                    InternetPreferencePage.this.nameCheckBox_.setSelection(false);
                    InternetPreferencePage.this.userNameTextField_.setEnabled(false);
                    InternetPreferencePage.this.passwordTextField_.setEnabled(false);
                }
            }
        });
        Label label = this.createLabel(parent, "");
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.nameCheckBox_ = this.createCheckBox(parent, InternetPlugin.getMessage("%CHECKBOX_PREFERENCE_ENABLE_NAME"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.nameCheckBox_.setLayoutData((Object)gd);
        this.nameCheckBox_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                boolean selected = InternetPreferencePage.this.nameCheckBox_.getSelection();
                InternetPreferencePage.this.userNameTextField_.setEnabled(selected);
                InternetPreferencePage.this.passwordTextField_.setEnabled(selected);
            }
        });
        this.createLabel(parent, InternetPlugin.getMessage("%LABEL_PREFERENCE_USERNAME"));
        this.userNameTextField_ = this.createTextField(parent);
        this.createLabel(parent, InternetPlugin.getMessage("%LABEL_PREFERENCE_PASSWORD"));
        this.passwordTextField_ = this.createTextField(parent);
        this.passwordTextField_.setEchoChar('*');
        this.initializeValues();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.proxyCheckBox_, "org.eclipse.wst.internet.proxy.inpp0010");
        helpSystem.setHelp((Control)this.hostnameTextField_, "org.eclipse.wst.internet.proxy.inpp0020");
        helpSystem.setHelp((Control)this.portTextField_, "org.eclipse.wst.internet.proxy.inpp0030");
        helpSystem.setHelp((Control)this.socksCheckBox_, "org.eclipse.wst.internet.proxy.inpp0040");
        helpSystem.setHelp((Control)this.nameCheckBox_, "org.eclipse.wst.internet.proxy.inpp0110");
        helpSystem.setHelp((Control)this.userNameTextField_, "org.eclipse.wst.internet.proxy.inpp0120");
        helpSystem.setHelp((Control)this.passwordTextField_, "org.eclipse.wst.internet.proxy.inpp0130");
        helpSystem.setHelp((Control)this.hostsList_, "org.eclipse.wst.internet.proxy.inpp0140");
        Dialog.applyDialogFont((Control)superparent);
        return parent;
    }

    private Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data);
        return text;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Button createCheckBox(Composite parent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        return button;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        InternetPlugin.getInstance().savePluginPreferences();
        return true;
    }

    public void init(IWorkbench workbench) {
    }

    public IPreferenceStore getPreferenceStore() {
        return InternetPlugin.getInstance().getPreferenceStore();
    }

    private void initializeDefaults() {
        this.hostnameTextField_.setText("");
        this.portTextField_.setText("");
        this.userNameTextField_.setText("");
        this.passwordTextField_.setText("");
        this.hostsList_.setList("localhost");
        this.proxyCheckBox_.setSelection(false);
        this.socksCheckBox_.setSelection(false);
        this.nameCheckBox_.setSelection(false);
        this.hostnameTextField_.setEnabled(false);
        this.portTextField_.setEnabled(false);
        this.socksCheckBox_.setEnabled(false);
        this.nameCheckBox_.setEnabled(false);
        this.userNameTextField_.setEnabled(false);
        this.passwordTextField_.setEnabled(false);
        this.hostsList_.setEnabled(false);
    }

    private void initializeValues() {
        Properties sysProps = System.getProperties();
        String host = "";
        String port = "";
        boolean socksSet = false;
        IPreferenceStore store = this.getPreferenceStore();
        String storeUserName = store.getString("userNameText");
        String storePassword = store.getString("passwordText");
        String storeHost = store.getString("hostnameText");
        String storePort = store.getString("portText");
        String storeNonProxy = store.getString("nonProxyHostsText");
        if (sysProps.containsKey("proxyHost") && sysProps.containsKey("proxyPort")) {
            host = (String)sysProps.get("proxyHost");
            port = (String)sysProps.get("proxyPort");
        } else if (sysProps.containsKey("socksProxyHost") && sysProps.containsKey("socksProxyPort")) {
            host = (String)sysProps.get("socksProxyHost");
            port = (String)sysProps.get("socksProxyPort");
            socksSet = true;
        } else {
            host = storeHost;
            port = storePort;
        }
        this.hostnameTextField_.setText(host);
        this.portTextField_.setText(port);
        String nonProxyHosts = (String)sysProps.get("http.nonProxyHosts");
        if (nonProxyHosts == null || nonProxyHosts.equals("")) {
            nonProxyHosts = storeNonProxy;
        }
        if (nonProxyHosts == null || nonProxyHosts.equals("")) {
            nonProxyHosts = "localhost";
        }
        this.hostsList_.setList(nonProxyHosts);
        String userName = "";
        String password = "";
        boolean httpProxySet = false;
        if (sysProps.containsKey("http.proxyUserName") && sysProps.containsKey("http.proxyPassword")) {
            userName = (String)sysProps.get("http.proxyUserName");
            password = (String)sysProps.get("http.proxyPassword");
            httpProxySet = true;
        } else {
            userName = storeUserName;
            password = storePassword;
        }
        this.userNameTextField_.setText(Encoder.isEncoded(userName) ? Encoder.decode(userName) : userName);
        this.passwordTextField_.setText(Encoder.isEncoded(password) ? Encoder.decode(password) : password);
        boolean checkBoxState = sysProps.containsKey("proxySet") ? Boolean.valueOf((String)sysProps.get("proxySet")) : false;
        boolean checkBoxState2 = socksSet;
        boolean checkBoxState3 = httpProxySet;
        this.proxyCheckBox_.setSelection(checkBoxState);
        this.socksCheckBox_.setSelection(checkBoxState2);
        this.nameCheckBox_.setSelection(checkBoxState3);
        this.hostnameTextField_.setEnabled(checkBoxState);
        this.portTextField_.setEnabled(checkBoxState);
        this.socksCheckBox_.setEnabled(checkBoxState);
        this.nameCheckBox_.setEnabled(checkBoxState & !checkBoxState2);
        this.userNameTextField_.setEnabled(checkBoxState3);
        this.passwordTextField_.setEnabled(checkBoxState3);
        this.hostsList_.setEnabled(checkBoxState);
    }

    private void storeValues() {
        boolean isProxyPropertiesUpdated;
        IPreferenceStore store = this.getPreferenceStore();
        String userName = store.getString("userNameText");
        String password = store.getString("passwordText");
        String oldHostsList = store.getString("nonProxyHostsText");
        String newHostsList = this.hostsList_.getList();
        boolean bl = this.proxyCheckBox_.getSelection() == store.getBoolean("proxyCheckBox") && this.hostnameTextField_.getText().equals(store.getString("hostnameText")) && this.portTextField_.getText().equals(store.getString("portText")) && this.socksCheckBox_.getSelection() == store.getBoolean("socksCheckBox") && this.nameCheckBox_.getSelection() == store.getBoolean("nameCheckBox") && this.userNameTextField_.getText().equals(Encoder.isEncoded(userName) ? Encoder.decode(userName) : userName) && this.passwordTextField_.getText().equals(Encoder.isEncoded(password) ? Encoder.decode(password) : password) && newHostsList.equals(oldHostsList) ? false : (isProxyPropertiesUpdated = true);
        if (isProxyPropertiesUpdated) {
            store.setValue("hostnameText", this.hostnameTextField_.getText());
            store.setValue("portText", this.portTextField_.getText());
            store.setValue("userNameText", Encoder.encode(this.userNameTextField_.getText()));
            store.setValue("passwordText", Encoder.encode(this.passwordTextField_.getText()));
            store.setValue("proxyCheckBox", this.proxyCheckBox_.getSelection());
            store.setValue("socksCheckBox", this.socksCheckBox_.getSelection());
            store.setValue("nameCheckBox", this.nameCheckBox_.getSelection());
            store.setValue("nonProxyHostsText", newHostsList);
            InternetPlugin.getInstance().updateProxyProperties();
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.internet.proxy.inpp0010");
    }
}

