/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.core.internal.ExternalLaunchConfigurationDelegate;
import org.eclipse.jst.server.generic.core.internal.GenericServerBehaviour;
import org.eclipse.jst.server.generic.core.internal.GenericServerCoreMessages;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.jst.server.generic.internal.xml.Resolver;
import org.eclipse.jst.server.generic.servertype.definition.External;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.util.SocketUtil;

public class ExternalServerBehaviour
extends GenericServerBehaviour {
    private ILaunchConfigurationWorkingCopy wc;
    private String mode;
    private ILaunch launch;
    private IProgressMonitor monitor;

    protected void initialize(IProgressMonitor monitor) {
        if (this.getServer().getServerState() == 4) {
            ServerPort[] ports = this.getServer().getServerPorts(null);
            int i = 0;
            while (i < ports.length) {
                ServerPort sp = ports[i];
                if (SocketUtil.isPortInUse((int)sp.getPort(), (int)5)) {
                    Trace.trace(Trace.WARNING, "Port " + sp.getPort() + " is currently in use");
                    Status status = new Status(2, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.bind((String)GenericServerCoreMessages.errorPortInUse, (Object)Integer.toString(sp.getPort()), (Object)sp.getName()), null);
                    this.setServerStatus((IStatus)status);
                    this.setServerState(0);
                    return;
                }
                ++i;
            }
        }
    }

    public void stop(boolean force) {
        this.resetStatus(this.getServer().getServerState());
        super.stop(force);
    }

    protected void setupLaunch(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        int state = this.getServer().getServerState();
        super.setupLaunch(launch, launchMode, monitor);
        this.resetStatus(state);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void setServerStarted() {
        if (this.wc != null) {
            try {
                try {
                    ExternalLaunchConfigurationDelegate.startDebugging(this.wc, this.mode, this.launch, this.monitor);
                }
                catch (CoreException ce) {
                    this.setMode("run");
                    final Status status = new Status(4, "org.eclipse.jst.server.generic.core", 1, GenericServerCoreMessages.errorStartingExternalDebugging, (Throwable)ce);
                    CorePlugin.getDefault().getLog().log((IStatus)status);
                    Trace.trace(Trace.SEVERE, GenericServerCoreMessages.errorStartingExternalDebugging, ce);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ErrorDialog.openError((Shell)new Shell(PlatformUI.getWorkbench().getDisplay()), null, null, (IStatus)status);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.clearDebuggingConfig();
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.clearDebuggingConfig();
            }
        }
        this.setServerState(2);
    }

    private void resetStatus(int state) {
        if (state == 0) {
            this.setServerStatus(null);
        }
    }

    protected void terminate() {
        int state = this.getServer().getServerState();
        if (state == 4) {
            return;
        }
        this.shutdown(state);
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        this.clearDebuggingConfig();
        ServerRuntime serverDef = this.getServerDefinition();
        Resolver resolver = serverDef.getResolver();
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, resolver.resolveProperties(serverDef.getStart().getWorkingDirectory()));
        String external = resolver.resolveProperties(this.getExternalForOS(serverDef.getStart().getExternal()));
        workingCopy.setAttribute("org.eclipse.jst.server.generic.core.COMMANDLINE", external);
        workingCopy.setAttribute("org.eclipse.jst.server.generic.core.DEBUG_PORT", resolver.resolveProperties(serverDef.getStart().getDebugPort()));
        workingCopy.setAttribute("org.eclipse.jst.server.generic.core.EXECUTABLE_NAME", external);
    }

    private String getExternalForOS(List externals) {
        String currentOS = System.getProperty("os.name").toLowerCase();
        String matchingExternal = null;
        Iterator i = externals.iterator();
        while (i.hasNext()) {
            External external = (External)i.next();
            String externalOS = external.getOs();
            if (externalOS == null) {
                if (matchingExternal != null) continue;
                matchingExternal = external.getValue();
                continue;
            }
            if (!currentOS.startsWith(externalOS.toLowerCase())) continue;
            matchingExternal = external.getValue();
            break;
        }
        return matchingExternal;
    }

    protected String getConfigTypeID() {
        return "org.eclipse.jst.server.generic.core.ExternalLaunchConfigurationType";
    }

    protected String getStopLaunchName() {
        return GenericServerCoreMessages.externalStopLauncher;
    }

    protected void setupStopLaunchConfiguration(GenericServerRuntime runtime, ILaunchConfigurationWorkingCopy wc) {
        this.clearDebuggingConfig();
        ServerRuntime serverDef = this.getServerDefinition();
        Resolver resolver = serverDef.getResolver();
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, resolver.resolveProperties(serverDef.getStop().getWorkingDirectory()));
        String external = resolver.resolveProperties(this.getExternalForOS(serverDef.getStop().getExternal()));
        wc.setAttribute("org.eclipse.jst.server.generic.core.COMMANDLINE", external);
        wc.setAttribute("org.eclipse.jst.server.generic.core.EXECUTABLE_NAME", external);
        wc.setAttribute("server-id", this.getServer().getId());
    }

    protected synchronized void setDebuggingConfig(ILaunchConfigurationWorkingCopy wc, String mode, ILaunch launch, IProgressMonitor monitor) {
        this.wc = wc;
        this.mode = mode;
        this.launch = launch;
        this.monitor = monitor;
    }

    private synchronized void clearDebuggingConfig() {
        this.wc = null;
        this.mode = null;
        this.launch = null;
        this.monitor = null;
    }
}

