/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.internal.xml;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.internal.core.util.ExtensionPointUtil;
import org.eclipse.jst.server.generic.internal.servertype.definition.util.ServerTypeResourceFactoryImpl;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.osgi.framework.Bundle;

public class XMLUtils {
    private ArrayList definitions;

    public XMLUtils() {
        this.refresh();
    }

    private void refresh() {
        this.definitions = new ArrayList();
        IExtension[] extensions = ExtensionPointUtil.getGenericServerDefinitionExtensions();
        int i = 0;
        while (extensions != null && i < extensions.length) {
            java.net.URI definitionFile = null;
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = ExtensionPointUtil.getConfigurationElements(extension);
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                definitionFile = this.getDefinitionFile(element);
                ServerRuntime runtime = this.readFile(definitionFile);
                if (runtime != null) {
                    runtime.setId(element.getAttribute("id"));
                    runtime.setConfigurationElementNamespace(element.getNamespace());
                    this.definitions.add(runtime);
                }
                ++j;
            }
            ++i;
        }
    }

    private java.net.URI getDefinitionFile(IConfigurationElement element) {
        Bundle bundle = Platform.getBundle((String)element.getNamespace());
        String definitionFile = element.getAttribute("definitionfile");
        URL url = bundle.getEntry(definitionFile);
        try {
            java.net.URI uri = new java.net.URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery());
            return uri;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private ServerRuntime readFile(java.net.URI file) {
        ServerRuntime def;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ServerTypeResourceFactoryImpl());
        URI fileURI = URI.createURI((String)file.toString());
        Resource resource = null;
        try {
            resource = resourceSet.getResource(fileURI, true);
        }
        catch (WrappedException e) {
            CorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.server.generic.core", 1, "Error loading the server type definition", (Throwable)e));
        }
        if (resource != null && (def = (ServerRuntime)resource.getContents().get(0)) != null) {
            def.setFilename(file.toString());
            return def;
        }
        return null;
    }

    public ArrayList getServerTypeDefinitions() {
        return this.definitions;
    }

    public ServerRuntime getServerTypeDefinition(String id) {
        Iterator defs = this.getServerTypeDefinitions().iterator();
        while (defs.hasNext()) {
            ServerRuntime elem = (ServerRuntime)defs.next();
            if (!id.equals(elem.getId())) continue;
            return elem;
        }
        return null;
    }

    private void setDefinitions(ArrayList definitions) {
        this.definitions = definitions;
    }
}

