/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.ProgressUtil;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.osgi.util.NLS;

public class FileUtil {
    private static final int BUFFER = 10240;
    private static byte[] buf = new byte[10240];

    private FileUtil() {
    }

    public static void copyDirectory(String from, String to, IProgressMonitor monitor) {
        try {
            File fromDir = new File(from);
            File toDir = new File(to);
            File[] files = fromDir.listFiles();
            toDir.mkdir();
            int size = files.length;
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{from, to}), size * 50);
            int i = 0;
            while (i < size) {
                File current = files[i];
                String fromFile = current.getAbsolutePath();
                String toFile = to;
                if (!toFile.endsWith(File.separator)) {
                    toFile = String.valueOf(toFile) + File.separator;
                }
                toFile = String.valueOf(toFile) + current.getName();
                if (current.isFile()) {
                    FileUtil.copyFile(fromFile, toFile);
                    monitor.worked(50);
                } else if (current.isDirectory()) {
                    monitor.subTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{fromFile, toFile}));
                    FileUtil.copyDirectory(fromFile, toFile, ProgressUtil.getSubMonitorFor(monitor, 50));
                }
                if (monitor.isCanceled()) {
                    return;
                }
                ++i;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error copying directory", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IStatus copyFile(InputStream in, String to) {
        Status status;
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(to);
                int avail = in.read(buf);
                while (true) {
                    if (avail <= 0) {
                        status = new Status(0, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.copyingTask, (Object[])new String[]{to}), null);
                        Object var4_7 = null;
                        break;
                    }
                    ((OutputStream)out).write(buf, 0, avail);
                    avail = in.read(buf);
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error copying file", e);
                Status status2 = new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
                Object var4_8 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out == null) return status2;
                    ((OutputStream)out).close();
                    return status2;
                }
                catch (Exception exception) {}
                return status2;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            try {}
            catch (Exception exception) {}
            if (in != null) {
                in.close();
            }
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            if (out == null) throw throwable;
            ((OutputStream)out).close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (in != null) {
            in.close();
        }
        try {}
        catch (Exception exception) {}
        if (out == null) return status;
        ((OutputStream)out).close();
        return status;
    }

    public static IStatus copyFile(String from, String to) {
        try {
            return FileUtil.copyFile(new FileInputStream(from), to);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error copying file", e);
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public static IStatus copyFile(URL from, String to) {
        try {
            return FileUtil.copyFile(from.openStream(), to);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error copying file", e);
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public static void deleteDirectory(File dir, IProgressMonitor monitor) {
        try {
            if (!dir.exists() || !dir.isDirectory()) {
                return;
            }
            File[] files = dir.listFiles();
            int size = files.length;
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{dir.getAbsolutePath()}), size * 10);
            int i = 0;
            while (i < size) {
                File current = files[i];
                if (current.isFile()) {
                    current.delete();
                    monitor.worked(10);
                } else if (current.isDirectory()) {
                    monitor.subTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{current.getAbsolutePath()}));
                    FileUtil.deleteDirectory(current, ProgressUtil.getSubMonitorFor(monitor, 10));
                }
                ++i;
            }
            dir.delete();
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error deleting directory " + dir.getAbsolutePath(), e);
        }
    }

    public static void smartCopyDirectory(String from, String to, IProgressMonitor monitor) {
        try {
            int toSize;
            File fromDir = new File(from);
            File toDir = new File(to);
            File[] fromFiles = fromDir.listFiles();
            int fromSize = fromFiles.length;
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{from, to}), 550);
            File[] toFiles = null;
            if (toDir.exists() && toDir.isDirectory()) {
                toFiles = toDir.listFiles();
                toSize = toFiles.length;
                int i = 0;
                while (i < toSize) {
                    String name = toFiles[i].getName();
                    boolean isDir = toFiles[i].isDirectory();
                    boolean found = false;
                    int j = 0;
                    while (j < fromSize) {
                        if (name.equals(fromFiles[j].getName()) && isDir == fromFiles[j].isDirectory()) {
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        if (isDir) {
                            FileUtil.deleteDirectory(toFiles[i], (IProgressMonitor)new NullProgressMonitor());
                        } else {
                            toFiles[i].delete();
                        }
                    }
                    if (monitor.isCanceled()) {
                        return;
                    }
                    ++i;
                }
            } else {
                if (toDir.isFile()) {
                    toDir.delete();
                }
                toDir.mkdir();
            }
            monitor.worked(50);
            toFiles = toDir.listFiles();
            toSize = toFiles.length;
            int dw = 0;
            if (toSize > 0) {
                dw = 500 / toSize;
            }
            int i = 0;
            while (i < fromSize) {
                File current = fromFiles[i];
                boolean copy = true;
                if (!current.isDirectory()) {
                    String name = current.getName();
                    long mod = current.lastModified();
                    int j = 0;
                    while (j < toSize) {
                        if (name.equals(toFiles[j].getName()) && mod <= toFiles[j].lastModified()) {
                            copy = false;
                        }
                        ++j;
                    }
                }
                if (copy) {
                    String fromFile = current.getAbsolutePath();
                    String toFile = to;
                    if (!toFile.endsWith(File.separator)) {
                        toFile = String.valueOf(toFile) + File.separator;
                    }
                    toFile = String.valueOf(toFile) + current.getName();
                    if (current.isFile()) {
                        FileUtil.copyFile(fromFile, toFile);
                        monitor.worked(dw);
                    } else if (current.isDirectory()) {
                        monitor.subTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{fromFile, toFile}));
                        FileUtil.smartCopyDirectory(fromFile, toFile, ProgressUtil.getSubMonitorFor(monitor, dw));
                    }
                }
                if (monitor.isCanceled()) {
                    return;
                }
                ++i;
            }
            monitor.worked(500 - dw * toSize);
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error smart copying directory " + from + " - " + to, e);
        }
    }
}

