/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.xml.XMLElement;
import org.eclipse.jst.server.tomcat.core.internal.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Factory {
    protected String packageName;
    protected Document document;

    protected Attr createAttribute(String s, Element element) {
        Attr attr = this.document.createAttribute(s);
        element.setAttributeNode(attr);
        return attr;
    }

    protected XMLElement createElement(int index, String s, Node node) {
        if (index < 0) {
            return this.createElement(s, node);
        }
        Element element = this.document.createElement(s);
        try {
            Node child = node.getFirstChild();
            int i = 0;
            while (i < index) {
                child = child.getNextSibling();
                ++i;
            }
            node.insertBefore(element, child);
        }
        catch (Exception exception) {
            node.appendChild(element);
        }
        return this.newInstance(element);
    }

    protected XMLElement createElement(String s, Node node) {
        Element element = this.document.createElement(s);
        node.appendChild(element);
        return this.newInstance(element);
    }

    public byte[] getContents() throws IOException {
        return XMLUtil.getContents(this.document);
    }

    public Document getDocument() {
        return this.document;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public XMLElement loadDocument(InputStream in) throws IOException {
        try {
            this.document = XMLUtil.getDocumentBuilder().parse(new InputSource(in));
            Element element = this.document.getDocumentElement();
            return this.newInstance(element);
        }
        catch (Exception exception) {
            Trace.trace(Trace.WARNING, "Error loading document", exception);
            throw new IOException("Could not load document");
        }
    }

    protected XMLElement newInstance(Element element) {
        String s = element.getNodeName();
        try {
            s = String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
            int i = s.indexOf("-");
            while (i >= 0) {
                s = String.valueOf(s.substring(0, i)) + s.substring(i + 1, i + 2).toUpperCase() + s.substring(i + 2);
                i = s.indexOf("-");
            }
            i = s.indexOf(":");
            while (i >= 0) {
                s = String.valueOf(s.substring(0, i)) + s.substring(i + 1, i + 2).toUpperCase() + s.substring(i + 2);
                i = s.indexOf(":");
            }
            if (this.packageName != null) {
                s = String.valueOf(this.packageName) + "." + s;
            }
            Class<?> class1 = Class.forName(s);
            XMLElement xmlElement = (XMLElement)class1.newInstance();
            xmlElement.setElement(element);
            xmlElement.setFactory(this);
            return xmlElement;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void save(String filename) throws IOException {
        XMLUtil.save(filename, this.document);
    }

    public void setDocument(Document d) {
        this.document = d;
    }

    public void setPackageName(String s) {
        this.packageName = s;
    }
}

