/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.internal.common.ClasspathModel;
import org.eclipse.jst.j2ee.internal.earcreation.EAREditModel;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;

class JARDependencyTraverser {
    private IProject archiveProject;
    private IProject earProject;
    private Map result;
    private EAREditModel earEditModel;

    public JARDependencyTraverser(IProject anArchiveProject, IProject anEarProject) {
        this.archiveProject = anArchiveProject;
        this.earProject = anEarProject;
    }

    public Map run() {
        Map map;
        block6: {
            EARNatureRuntime[] earNatures = J2EEProjectUtilities.getReferencingEARProjects(this.archiveProject);
            if (earNatures == null || earNatures.length == 0 || earNatures.length == 1 && earNatures[0].getProject() == this.earProject) {
                return Collections.EMPTY_MAP;
            }
            this.result = new HashMap();
            EARNatureRuntime runtime = EARNatureRuntime.getRuntime(this.earProject);
            if (runtime == null) {
                return Collections.EMPTY_MAP;
            }
            this.earEditModel = runtime.getEarEditModelForRead(this);
            try {
                int i = 0;
                while (i < earNatures.length) {
                    if (earNatures[i].getProject() != this.earProject) {
                        this.traverseClasspath(earNatures[i]);
                    }
                    ++i;
                }
                map = this.result;
                Object var4_5 = null;
                if (this.earEditModel == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var4_6 = null;
                    if (this.earEditModel == null) break block7;
                    this.earEditModel.releaseAccess(this);
                }
                throw throwable;
            }
            this.earEditModel.releaseAccess(this);
        }
        return map;
    }

    private void traverseClasspath(EARNatureRuntime anEARNature) {
        ClasspathModel model = new ClasspathModel(null);
        model.setProject(this.archiveProject);
        ClassPathSelection cpSelection = model.getClassPathSelection();
        Archive anArchive = model.getArchive();
        RuntimeClasspathEntry[] entries = anArchive.getDependencyClassPath();
        Archive referencedArchive = null;
        int i = 0;
        while (i < entries.length) {
            IResource resource;
            ClasspathElement elmt;
            String uri;
            RuntimeClasspathEntry entry = entries[i];
            referencedArchive = entry.getReferencedArchive();
            if (!entry.isWebLib() && referencedArchive != null && (uri = referencedArchive.getURI()) != null && (elmt = cpSelection.getClasspathElement(uri)) != null && (resource = elmt.getResource()) != null) {
                this.addResult(resource, uri);
            }
            ++i;
        }
    }

    private void addResult(IResource res, String uri) {
        if (this.result.containsKey(res)) {
            return;
        }
        boolean exists = false;
        switch (res.getType()) {
            case 1: {
                exists = this.containsJARFile((IFile)res, uri);
                break;
            }
            case 4: {
                exists = this.earEditModel.hasMappingToProject((IProject)res);
                break;
            }
            default: {
                return;
            }
        }
        if (!exists) {
            this.result.put(res, uri);
        }
    }

    private boolean containsJARFile(IFile file, String uri) {
        Path path = null;
        try {
            path = new Path(uri);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        IFile existing = this.earProject.getFile((IPath)path);
        return existing != null && existing.exists();
    }
}

