/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.componentcore.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ApplicationResource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.J2EEConstants;
import org.eclipse.jst.j2ee.internal.archive.operations.EARComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.util.IArtifactEditFactory;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class EARArtifactEdit
extends EnterpriseArtifactEdit
implements IArtifactEditFactory {
    public static final Class ADAPTER_TYPE;
    public static String TYPE_ID;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ADAPTER_TYPE = clazz;
        TYPE_ID = "jst.ear";
    }

    public EARArtifactEdit() {
    }

    public EARArtifactEdit(ComponentHandle aHandle, boolean toAccessAsReadOnly) throws IllegalArgumentException {
        super(aHandle, toAccessAsReadOnly);
    }

    public static EARArtifactEdit getEARArtifactEditForRead(ComponentHandle aHandle) {
        EARArtifactEdit artifactEdit = null;
        try {
            if (EARArtifactEdit.isValidEARModule(aHandle.createComponent())) {
                artifactEdit = new EARArtifactEdit(aHandle, true);
            }
        }
        catch (Exception exception) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static EARArtifactEdit getEARArtifactEditForWrite(ComponentHandle aHandle) {
        EARArtifactEdit artifactEdit = null;
        try {
            if (EARArtifactEdit.isValidEARModule(aHandle.createComponent())) {
                artifactEdit = new EARArtifactEdit(aHandle, false);
            }
        }
        catch (Exception exception) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static EARArtifactEdit getEARArtifactEditForRead(IVirtualComponent aModule) {
        try {
            if (EARArtifactEdit.isValidEARModule(aModule)) {
                IProject project = aModule.getProject();
                ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)project);
                return new EARArtifactEdit(nature, aModule, true);
            }
        }
        catch (UnresolveableURIException unresolveableURIException) {}
        return null;
    }

    public static EARArtifactEdit getEARArtifactEditForWrite(IVirtualComponent aModule) {
        try {
            if (EARArtifactEdit.isValidEARModule(aModule)) {
                IProject project = aModule.getProject();
                ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)project);
                return new EARArtifactEdit(nature, aModule, false);
            }
        }
        catch (UnresolveableURIException unresolveableURIException) {}
        return null;
    }

    public static boolean isValidEARModule(IVirtualComponent aModule) throws UnresolveableURIException {
        if (!EARArtifactEdit.isValidEditableModule((IVirtualComponent)aModule)) {
            return false;
        }
        return TYPE_ID.equals(aModule.getComponentTypeId());
    }

    public EARArtifactEdit(ArtifactEditModel model) {
        super(model);
    }

    public EARArtifactEdit(ModuleCoreNature aNature, IVirtualComponent aModule, boolean toAccessAsReadOnly) {
        super(aNature, aModule, toAccessAsReadOnly);
    }

    public int getJ2EEVersion() {
        return this.getApplicationXmiResource().getJ2EEVersionID();
    }

    public ApplicationResource getApplicationXmiResource() {
        return (ApplicationResource)this.getDeploymentDescriptorResource();
    }

    public Application getApplication() {
        return (Application)this.getDeploymentDescriptorRoot();
    }

    public Resource getDeploymentDescriptorResource() {
        return this.getArtifactEditModel().getResource(J2EEConstants.APPLICATION_DD_URI_OBJ);
    }

    protected void addApplicationIfNecessary(XMLResource aResource) {
        if (aResource != null) {
            if (aResource.getContents() == null || aResource.getContents().isEmpty()) {
                Application newApp = ApplicationFactory.eINSTANCE.createApplication();
                aResource.getContents().add((Object)newApp);
            }
            Application application = (Application)aResource.getContents().get(0);
            URI moduleURI = this.getArtifactEditModel().getModuleURI();
            try {
                application.setDisplayName(StructureEdit.getDeployedName((URI)moduleURI));
            }
            catch (UnresolveableURIException unresolveableURIException) {}
            aResource.setID((EObject)application, "Application_ID");
        }
    }

    public boolean uriExists(String currentURI) {
        if (currentURI != null) {
            IVirtualComponent comp = ComponentCore.createComponent((IProject)this.getComponentHandle().getProject(), (String)this.getComponentHandle().getName());
            IVirtualReference[] refComponents = comp.getReferences();
            if (refComponents.length == 0) {
                return false;
            }
            int i = 0;
            while (i < refComponents.length) {
                if (refComponents[i].getRuntimePath().equals((Object)currentURI)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public EObject createModelRoot() {
        return this.createModelRoot(this.getJ2EEVersion());
    }

    public EObject createModelRoot(int version) {
        ApplicationResource res = (ApplicationResource)this.getDeploymentDescriptorResource();
        res.setModuleVersionID(version);
        this.addApplicationIfNecessary((XMLResource)res);
        return ((ApplicationResource)this.getDeploymentDescriptorResource()).getRootObject();
    }

    public List getUtilityModuleReferences() {
        ArrayList<String> utilityModuleTypes = new ArrayList<String>();
        utilityModuleTypes.add("jst.utility");
        return this.getComponentReferences(utilityModuleTypes);
    }

    public String getModuleURI(IVirtualComponent moduleComp) {
        IVirtualComponent comp = this.getModule(moduleComp.getName());
        if (comp != null) {
            if (comp.getComponentTypeId().equals("jst.ejb") || comp.getComponentTypeId().equals("jst.appclient") || comp.getComponentTypeId().equals("jst.utility")) {
                return comp.getName().concat(".jar");
            }
            if (comp.getComponentTypeId().equals("jst.web")) {
                return comp.getName().concat(".war");
            }
            if (comp.getComponentTypeId().equals("jst.connector")) {
                return comp.getName().concat(".rar");
            }
        }
        return null;
    }

    public IVirtualComponent getModule(String moduleName) {
        if (moduleName == null) {
            return null;
        }
        if (moduleName.endsWith(".jar") || moduleName.endsWith(".war") || moduleName.endsWith(".rar")) {
            moduleName = moduleName.substring(0, moduleName.length() - ".jar".length());
        }
        List references = this.getComponentReferences();
        int i = 0;
        while (i < references.size()) {
            IVirtualReference ref = (IVirtualReference)references.get(i);
            IVirtualComponent component = ref.getReferencedComponent();
            if (component.getName().equals(moduleName)) {
                return component;
            }
            ++i;
        }
        return null;
    }

    public List getJ2EEModuleReferences() {
        ArrayList<String> j2eeTypes = new ArrayList<String>();
        j2eeTypes.add("jst.appclient");
        j2eeTypes.add("jst.connector");
        j2eeTypes.add("jst.ejb");
        j2eeTypes.add("jst.web");
        return this.getComponentReferences(j2eeTypes);
    }

    public List getComponentReferences() {
        return this.getComponentReferences(Collections.EMPTY_LIST);
    }

    private List getComponentReferences(List componentTypes) {
        ArrayList<IVirtualReference> components = new ArrayList<IVirtualReference>();
        IVirtualComponent earComponent = this.getComponent();
        if (earComponent.getComponentTypeId().equals("jst.ear")) {
            IVirtualReference[] refComponents = earComponent.getReferences();
            int i = 0;
            while (i < refComponents.length) {
                IVirtualComponent module = refComponents[i].getReferencedComponent();
                if (module.getProject() != null && module.getProject().isAccessible()) {
                    if (componentTypes == null || componentTypes.size() == 0) {
                        components.add(refComponents[i]);
                    } else if (componentTypes.contains(module.getComponentTypeId())) {
                        components.add(refComponents[i]);
                    }
                }
                ++i;
            }
        }
        return components;
    }

    public ArtifactEdit createArtifactEditForRead(IVirtualComponent aComponent) {
        return EARArtifactEdit.getEARArtifactEditForRead(aComponent);
    }

    public ArtifactEdit createArtifactEditForWrite(IVirtualComponent aComponent) {
        return EARArtifactEdit.getEARArtifactEditForWrite(aComponent);
    }

    public Archive asArchive(boolean includeSource) throws OpenFailureException {
        EARComponentLoadStrategyImpl loader = new EARComponentLoadStrategyImpl(this.getComponent());
        loader.setExportSource(includeSource);
        String uri = this.getComponent().getComponentHandle().toString();
        return CommonarchiveFactory.eINSTANCE.openEARFile((LoadStrategy)loader, uri);
    }
}

