/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.operations;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassOperation;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class NewJavaClassDataModel
extends ArtifactEditOperationDataModel {
    public static final String CLASS_NAME = "NewJavaClassDataModel.CLASS_NAME";
    public static final String SOURCE_FOLDER = "NewJavaClassDataModel.SOURCE_FOLDER";
    public static final String JAVA_PACKAGE = "NewJavaClassDataModel.JAVA_PACKAGE";
    public static final String SUPERCLASS = "NewJavaClassDataModel.SUPERCLASS";
    public static final String MODIFIER_PUBLIC = "NewJavaClassDataModel.MODIFIER_PUBLIC";
    public static final String MODIFIER_ABSTRACT = "NewJavaClassDataModel.MODIFIER_ABSTRACT";
    public static final String MODIFIER_FINAL = "NewJavaClassDataModel.MODIFIER_FINAL";
    public static final String INTERFACES = "NewJavaClassDataModel.INTERFACES";
    public static final String MAIN_METHOD = "NewJavaClassDataModel.MAIN_METHOD";
    public static final String CONSTRUCTOR = "NewJavaClassDataModel.CONSTRUCTOR";
    public static final String ABSTRACT_METHODS = "NewJavaClassDataModel.ABSTRACT_METHODS";

    protected IStatus validateJavaSourceFolder(String folderFullPath) {
        IProject project = this.getTargetProject();
        if (project == null) {
            String msg = J2EECommonMessages.getResourceString("ERR_JAVA_CLASS_FOLDER_NOT_EXIST");
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (!project.isAccessible()) {
            String msg = J2EECommonMessages.getResourceString("ERR_JAVA_CLASS_FOLDER_NOT_EXIST");
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                String msg = J2EECommonMessages.getResourceString("ERR_JAVA_CLASS_NOT_JAVA_PROJECT");
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        }
        catch (CoreException e) {
            Logger.getLogger().log((Throwable)e);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    protected IFolder getDefaultJavaSourceFolder() {
        IProject project = this.getTargetProject();
        if (project == null) {
            return null;
        }
        IContainer output = JemProjectUtilities.getJavaProjectOutputContainer((IProject)project);
        List sources = JemProjectUtilities.getSourceContainers((IProject)project);
        if (sources == null || sources.isEmpty() || ((IContainer)sources.get(0)).getType() != 2) {
            return null;
        }
        if (output != null && sources.contains(output)) {
            return (IFolder)output;
        }
        return (IFolder)sources.get(0);
    }

    public WTPOperation getDefaultOperation() {
        return new NewJavaClassOperation((WTPOperationDataModel)this);
    }

    public IPackageFragmentRoot getJavaPackageFragmentRoot() {
        IFolder sourcefolder;
        IProject project = this.getTargetProject();
        IJavaProject aJavaProject = JemProjectUtilities.getJavaProject((IProject)project);
        if (aJavaProject != null && (sourcefolder = this.getJavaSourceFolder()) != null) {
            return aJavaProject.getPackageFragmentRoot((IResource)sourcefolder);
        }
        return null;
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(SOURCE_FOLDER);
        this.addValidBaseProperty(JAVA_PACKAGE);
        this.addValidBaseProperty(CLASS_NAME);
        this.addValidBaseProperty(SUPERCLASS);
        this.addValidBaseProperty(MODIFIER_PUBLIC);
        this.addValidBaseProperty(MODIFIER_ABSTRACT);
        this.addValidBaseProperty(MODIFIER_FINAL);
        this.addValidBaseProperty(INTERFACES);
        this.addValidBaseProperty(MAIN_METHOD);
        this.addValidBaseProperty(CONSTRUCTOR);
        this.addValidBaseProperty(ABSTRACT_METHODS);
    }

    protected Object getDefaultProperty(String propertyName) {
        IFolder sourceFolder;
        if (propertyName.equals(SOURCE_FOLDER) && (sourceFolder = this.getDefaultJavaSourceFolder()) != null && sourceFolder.exists()) {
            return sourceFolder.getFullPath().toOSString();
        }
        if (propertyName.equals(SUPERCLASS)) {
            return new String("java.lang.Object");
        }
        if (propertyName.equals(MODIFIER_PUBLIC)) {
            return new Boolean(true);
        }
        if (propertyName.equals(CONSTRUCTOR)) {
            return new Boolean(true);
        }
        if (propertyName.equals(ABSTRACT_METHODS)) {
            return new Boolean(true);
        }
        return super.getDefaultProperty(propertyName);
    }

    protected IStatus doValidateProperty(String propertyName) {
        IStatus result = super.doValidateProperty(propertyName);
        if (!result.isOK()) {
            return result;
        }
        if (propertyName.equals(SOURCE_FOLDER)) {
            return this.validateFolder(this.getStringProperty(propertyName));
        }
        if (propertyName.equals(JAVA_PACKAGE)) {
            return this.validateJavaPackage(this.getStringProperty(propertyName));
        }
        if (propertyName.equals(CLASS_NAME) && (result = this.validateJavaClassName(this.getStringProperty(propertyName))).isOK()) {
            result = this.canCreateTypeInClasspath(this.getStringProperty(CLASS_NAME));
        }
        if (propertyName.equals(SUPERCLASS)) {
            return this.validateSuperclass(this.getStringProperty(propertyName));
        }
        if (propertyName.equals(MODIFIER_ABSTRACT) || propertyName.equals(MODIFIER_FINAL)) {
            return this.validateModifier(propertyName, this.getBooleanProperty(propertyName));
        }
        return result;
    }

    private IStatus validateFolder(String folderFullPath) {
        if (folderFullPath == null || folderFullPath.length() == 0) {
            String msg = J2EECommonMessages.getResourceString("ERR_JAVA_CLASS_FOLDER_NAME_EMPTY");
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (!new Path(folderFullPath).isAbsolute()) {
            String msg = J2EECommonMessages.getResourceString("ERR_JAVA_CLASS_FOLDER_NOT_ABSOLUTE");
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return this.validateJavaSourceFolder(folderFullPath);
    }

    private IStatus validateJavaPackage(String packName) {
        if (packName != null && packName.trim().length() > 0) {
            IStatus javaStatus = JavaConventions.validatePackageName((String)packName);
            if (javaStatus.getSeverity() == 4) {
                String msg = String.valueOf(J2EECommonMessages.getResourceString("ERR_JAVA_PACAKGE_NAME_INVALID")) + javaStatus.getMessage();
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
            if (javaStatus.getSeverity() == 2) {
                String msg = String.valueOf(J2EECommonMessages.getResourceString("ERR_JAVA_PACKAGE_NAME_WARNING")) + javaStatus.getMessage();
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    protected IStatus validateJavaClassName(String className) {
        if (className.lastIndexOf(46) != -1) {
            String msg = J2EECommonMessages.getResourceString("ERR_JAVA_CLASS_NAME_QUALIFIED");
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        IStatus javaStatus = JavaConventions.validateJavaTypeName((String)className);
        if (javaStatus.getSeverity() == 4) {
            String msg = String.valueOf(J2EECommonMessages.getResourceString("ERR_JAVA_CLASS_NAME_INVALID")) + javaStatus.getMessage();
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (javaStatus.getSeverity() == 2) {
            String msg = String.valueOf(J2EECommonMessages.getResourceString("ERR_JAVA_CLASS_NAME_WARNING")) + javaStatus.getMessage();
            return WTPCommonPlugin.createWarningStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateSuperclass(String superclassName) {
        IStatus status;
        if (superclassName == null || superclassName.trim().length() == 0) {
            String msg = J2EECommonMessages.getResourceString("ERR_JAVA_CLASS_NAME_EMPTY");
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (superclassName.equals("java.lang.Object")) {
            return WTPCommonPlugin.OK_STATUS;
        }
        String className = superclassName;
        int index = superclassName.lastIndexOf(".");
        if (index != -1) {
            className = superclassName.substring(index + 1);
        }
        if ((status = this.validateJavaClassName(className)).isOK() && this.canCreateTypeInClasspath(className).isOK()) {
            String msg = J2EECommonMessages.getResourceString("ERR_JAVA_CLASS_SUPERCLASS_NOT_EXIST");
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return status;
    }

    private IStatus validateModifier(String propertyName, boolean prop) {
        if (prop) {
            if (propertyName.equals(MODIFIER_ABSTRACT) && this.getBooleanProperty(MODIFIER_FINAL)) {
                String msg = J2EECommonMessages.getResourceString("ERR_BOTH_FINAL_AND_ABSTRACT");
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
            if (propertyName.equals(MODIFIER_FINAL) && this.getBooleanProperty(MODIFIER_ABSTRACT)) {
                String msg = J2EECommonMessages.getResourceString("ERR_BOTH_FINAL_AND_ABSTRACT");
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    public final String getQualifiedClassName() {
        String packageName = this.getStringProperty(JAVA_PACKAGE);
        String className = this.getStringProperty(CLASS_NAME);
        if (packageName != null && packageName.trim().length() > 0) {
            return String.valueOf(packageName) + "." + className;
        }
        return className;
    }

    private IStatus canCreateTypeInClasspath(String className) {
        IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)this.getTargetProject());
        try {
            ICompilationUnit cu;
            IResource resource;
            Path path = new Path(String.valueOf(this.getStringProperty(SOURCE_FOLDER)) + "//" + this.getStringProperty(JAVA_PACKAGE));
            IPackageFragment pack = javaProject.findPackageFragment((IPath)path);
            if (pack != null && (resource = (cu = pack.getCompilationUnit(String.valueOf(className) + ".java")).getResource()).exists()) {
                String msg = J2EECommonMessages.getResourceString("ERR_JAVA_CLASS_NAME_EXIST");
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
            return WTPCommonPlugin.OK_STATUS;
        }
        catch (Exception e) {
            Logger.getLogger().log((Throwable)e);
            return WTPCommonPlugin.OK_STATUS;
        }
    }

    protected final IFolder getJavaSourceFolder() {
        List sources = this.getAllSourceFolders();
        if (sources == null || sources.isEmpty() || ((IContainer)sources.get(0)).getType() != 2) {
            return null;
        }
        String folderFullPath = this.getStringProperty(SOURCE_FOLDER);
        int i = 0;
        while (i < sources.size()) {
            IFolder folder = (IFolder)sources.get(i);
            if (folder.getFullPath().equals((Object)new Path(folderFullPath))) {
                return folder;
            }
            ++i;
        }
        return null;
    }

    private List getAllSourceFolders() {
        IProject project = this.getTargetProject();
        if (project == null) {
            return null;
        }
        List sources = JemProjectUtilities.getSourceContainers((IProject)project);
        return sources;
    }

    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean result = super.doSetProperty(propertyName, propertyValue);
        if (result && "ArtifactEditOperationDataModel.MODULE_NAME".equals(propertyName)) {
            this.setProperty(SOURCE_FOLDER, this.getDefaultJavaSourceFolder().getFullPath().toOSString());
        }
        return result;
    }
}

