/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.delete;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.internal.J2EEEditModel;
import org.eclipse.jst.j2ee.internal.delete.DeleteModuleDependencyOperation;
import org.eclipse.jst.j2ee.internal.delete.DeleteOptions;
import org.eclipse.jst.j2ee.internal.earcreation.EAREditModel;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.earcreation.RemoveModuleFromEARProjectCommand;
import org.eclipse.jst.j2ee.internal.earcreation.RemoveUtilityJARMapCommand;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.integration.ComposedEditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.LooseComposedEditModel;

public class DeleteModuleOperation
extends WTPOperation {
    protected DeleteOptions options;
    protected Map deferredCommands;
    protected IProgressMonitor monitor;
    protected DeleteModuleDependencyOperation deleteModuleDependencyOperation;
    protected LooseComposedEditModel deleteEditModel;
    protected List dirtyEarModels;
    protected static String EDIT_MODEL_KEY = "DELETE_MODULES";

    public DeleteModuleOperation(DeleteOptions options) {
        this.options = options;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IProgressMonitor aMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.monitor = aMonitor;
        try {
            this.buildDeleteCommandsIfNecessary();
            if (this.options.shouldDeleteModuleDependencies()) {
                this.deleteModuleDependencies();
            }
            this.checkIfEarsAreDirty();
            this.executeDeferredCommands();
            this.saveModelsIfNecessary();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.releaseModels();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.releaseModels();
            return;
        }
    }

    protected void checkIfEarsAreDirty() {
        this.dirtyEarModels = new ArrayList();
        if (this.deferredCommands == null) {
            return;
        }
        Iterator models = this.deferredCommands.keySet().iterator();
        while (models.hasNext()) {
            EAREditModel model = (EAREditModel)((Object)models.next());
            if (!model.isDirty() || this.dirtyEarModels.contains((Object)model)) continue;
            this.dirtyEarModels.add(model);
        }
    }

    protected void buildDeleteCommandsIfNecessary() {
        if (this.deferredCommands != null && !this.deferredCommands.isEmpty()) {
            return;
        }
        this.deferredCommands = new HashMap();
        List earProjects = EARNatureRuntime.getAllEARProjectsInWorkbench();
        int i = 0;
        while (i < earProjects.size()) {
            IProject p = (IProject)earProjects.get(i);
            if (this.options.getSelectedProjects().contains(p)) {
                return;
            }
            EARNatureRuntime runtime = EARNatureRuntime.getRuntime(p);
            if (runtime != null) {
                this.buildDeleteCommands(runtime);
            }
            ++i;
        }
    }

    protected void buildDeleteCommands(EARNatureRuntime runtime) {
        ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>();
        EAREditModel model = runtime.getEarEditModelForWrite((Object)this);
        List projects = this.options.getModuleAndUtilityProjects();
        try {
            if (this.options.shouldDeleteModules()) {
                int i = 0;
                while (i < projects.size()) {
                    IProject project = (IProject)projects.get(i);
                    Module m = runtime.getModule(project);
                    if (m != null) {
                        commands.add(new RemoveModuleFromEARProjectCommand(m, runtime.getProject()));
                    } else {
                        String uri = runtime.getJARUri(project);
                        if (uri != null) {
                            commands.add(new RemoveUtilityJARMapCommand(runtime.getProject(), uri, project));
                        }
                    }
                    ++i;
                }
            }
            if (!commands.isEmpty()) {
                this.deferredCommands.put(model, commands);
            } else {
                model.releaseAccess((Object)this);
            }
        }
        catch (RuntimeException e) {
            model.releaseAccess((Object)this);
            throw e;
        }
        catch (Error err) {
            model.releaseAccess((Object)this);
            throw err;
        }
    }

    protected void releaseModels() {
        if (this.deleteEditModel != null) {
            this.deleteEditModel.releaseAccess((Object)this);
            this.deleteEditModel = null;
        }
        if (this.deferredCommands != null) {
            Iterator iter = this.deferredCommands.keySet().iterator();
            while (iter.hasNext()) {
                EditModel editModel = (EditModel)iter.next();
                editModel.releaseAccess((Object)this);
                iter.remove();
            }
        }
    }

    public void release() {
        this.releaseModels();
    }

    protected void saveModelsIfNecessary() {
        if (this.deferredCommands == null) {
            return;
        }
        Iterator models = this.deferredCommands.keySet().iterator();
        while (models.hasNext()) {
            EAREditModel model = (EAREditModel)((Object)models.next());
            if (!model.isDirty()) continue;
            if (this.dirtyEarModels.contains((Object)model)) {
                model.saveIfNecessary((Object)this);
                continue;
            }
            model.save((Object)this);
        }
    }

    protected void deleteModuleDependencies() throws InvocationTargetException, InterruptedException {
        this.getDeleteModuleDependencyOperation().run(this.monitor);
    }

    protected DeleteModuleDependencyOperation getDeleteModuleDependencyOperation() {
        if (this.deleteModuleDependencyOperation == null) {
            ArrayList<EARNatureRuntime> earEditModels = new ArrayList<EARNatureRuntime>();
            Iterator iter = this.deferredCommands.keySet().iterator();
            while (iter.hasNext()) {
                earEditModels.add(((EAREditModel)((Object)iter.next())).getEARNature());
            }
            this.deleteModuleDependencyOperation = new DeleteModuleDependencyOperation(earEditModels, new HashSet(this.options.getModuleAndUtilityProjects()));
        }
        return this.deleteModuleDependencyOperation;
    }

    protected void executeDeferredCommands() {
        Iterator it = this.deferredCommands.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            List commands = (List)entry.getValue();
            this.executeCommands(commands);
        }
    }

    protected void executeCommands(List commands) {
        int i = 0;
        while (i < commands.size()) {
            Command cmd = (Command)commands.get(i);
            cmd.execute();
            ++i;
        }
    }

    protected List getAffectedNonResourceFiles() {
        if (this.options.shouldDeleteModuleDependencies()) {
            return this.getDeleteModuleDependencyOperation().getAffectedFiles();
        }
        return Collections.EMPTY_LIST;
    }

    public ComposedEditModel getDeleteEditModel() {
        if (this.deleteEditModel == null) {
            this.initializeDeleteEditModel();
        }
        return this.deleteEditModel;
    }

    protected void initializeDeleteEditModel() {
        if (this.options.getAllProjectsToDelete().size() == 0) {
            throw new RuntimeException(J2EECreationResourceHandler.getString("DeleteModuleOperation_UI_0"));
        }
        this.buildDeleteCommandsIfNecessary();
        IProject project = null;
        project = (IProject)this.options.getAllProjectsToDelete().get(0);
        this.deleteEditModel = new LooseComposedEditModel(EDIT_MODEL_KEY, (EMFWorkbenchContext)WorkbenchResourceHelper.getEMFContext((IProject)project)){

            public List getNonResourceFiles() {
                List result = super.getNonResourceFiles();
                result.addAll(DeleteModuleOperation.this.getAffectedNonResourceFiles());
                return result;
            }
        };
        Iterator it = this.deferredCommands.keySet().iterator();
        while (it.hasNext()) {
            this.deleteEditModel.addChild((EditModel)((J2EEEditModel)((Object)it.next())));
        }
    }

    public IStatus getStatus() {
        return this.deleteModuleDependencyOperation.getStatus();
    }
}

