/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deploy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.common.componentcore.util.ComponentUtilities;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.deploy.DeployerRegistryReader;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IFlexibleProject;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emf.utilities.ICommand;
import org.eclipse.wst.server.core.IRuntime;

public class DeployerRegistry {
    private static DeployerRegistry INSTANCE;
    private HashMap deployModuleExtensions = new HashMap();

    public void register(ICommand deployer, List serverTargets, List natures) {
        Iterator iter = natures.iterator();
        while (iter.hasNext()) {
            String natureID = (String)iter.next();
            Iterator iterator = serverTargets.iterator();
            while (iterator.hasNext()) {
                String runtimeID = (String)iterator.next();
                HashMap targetDeployers = this.getDeployModuleExtensions(natureID);
                this.getTargetDeployers(targetDeployers, runtimeID).add(deployer);
            }
        }
    }

    private List getDeployers(String natureID, String serverTarget) {
        HashMap targetDeployers = this.getDeployModuleExtensions(natureID);
        return this.getTargetDeployers(targetDeployers, serverTarget);
    }

    public static DeployerRegistry instance() {
        if (INSTANCE == null) {
            INSTANCE = new DeployerRegistry();
            DeployerRegistry.readRegistry();
        }
        return INSTANCE;
    }

    private static void readRegistry() {
        DeployerRegistryReader reader = new DeployerRegistryReader();
        reader.readRegistry();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getSelectedModules(Object[] mySelections) {
        ArrayList<EObject> modules = new ArrayList<EObject>();
        int i = 0;
        while (true) {
            block15: {
                if (i >= mySelections.length) {
                    return modules;
                }
                Object object = mySelections[i];
                if (object instanceof EObject) {
                    object = ProjectUtilities.getProject((Object)object);
                }
                if (!(object instanceof IProject)) break block15;
                IFlexibleProject flexProj = ComponentCore.createFlexibleProject((IProject)((IProject)object));
                IVirtualComponent[] components = flexProj.getComponents();
                int j = 0;
                while (j < components.length) {
                    block12: {
                        Object var10_10;
                        EnterpriseArtifactEdit edit;
                        block14: {
                            block13: {
                                IVirtualComponent component = components[j];
                                edit = null;
                                try {
                                    edit = (EnterpriseArtifactEdit)ComponentUtilities.getArtifactEditForRead((IVirtualComponent)component);
                                    EObject root = edit.getDeploymentDescriptorRoot();
                                    if (modules.contains(root)) {
                                        var10_10 = null;
                                        if (edit == null) break block12;
                                        break block13;
                                    }
                                    if (component.getComponentTypeId().equals("jst.ear")) {
                                        modules.add(0, root);
                                        break block14;
                                    } else {
                                        modules.add(root);
                                    }
                                    break block14;
                                }
                                catch (Throwable throwable) {
                                    var10_10 = null;
                                    if (edit != null) {
                                        edit.dispose();
                                    }
                                    throw throwable;
                                }
                            }
                            edit.dispose();
                            break block12;
                        }
                        var10_10 = null;
                        if (edit != null) {
                            edit.dispose();
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private List getTargetDeployers(HashMap targetDeployers, String serverTarget) {
        if (targetDeployers.get(serverTarget) == null) {
            targetDeployers.put(serverTarget, new ArrayList());
        }
        return (List)targetDeployers.get(serverTarget);
    }

    private HashMap getDeployModuleExtensions(String natureID) {
        if (this.getDeployModuleExtensions().get(natureID) == null) {
            this.getDeployModuleExtensions().put(natureID, new HashMap());
        }
        return (HashMap)this.getDeployModuleExtensions().get(natureID);
    }

    public HashMap getDeployModuleExtensions() {
        return this.deployModuleExtensions;
    }

    public void setDeployModuleExtensions(HashMap deployExtensions) {
        this.deployModuleExtensions = deployExtensions;
    }

    public List getDeployModuleExtensions(EObject module, IRuntime runtime) {
        IVirtualComponent comp = ComponentUtilities.findComponent((EObject)module);
        String typeID = comp.getComponentTypeId();
        String runtimeID = runtime.getRuntimeType().getId();
        return this.getDeployers(typeID, runtimeID);
    }
}

