/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deployables;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

public abstract class J2EEFlexProjDeployable
extends ProjectModule
implements IJ2EEModule {
    private String factoryId;
    protected IVirtualComponent component = null;
    private boolean outputMembersAdded = false;

    public J2EEFlexProjDeployable(IProject project, String aFactoryId, IVirtualComponent aComponent) {
        super(project);
        this.factoryId = aFactoryId;
        this.component = aComponent;
    }

    public String getJ2EESpecificationVersion() {
        return "1.2";
    }

    public IPath getLocation() {
        IPath path = null;
        if (ModuleCoreNature.getModuleCoreNature((IProject)this.project) != null && this.component != null) {
            IFolder outputContainer = StructureEdit.getOutputContainerRoot((IVirtualComponent)this.component);
            path = outputContainer.getRawLocation();
        }
        return path;
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public boolean isBinary() {
        return false;
    }

    public String getModuleTypeName() {
        return this.getName();
    }

    public String getModuleTypeVersion() {
        return this.getVersion();
    }

    public ComponentHandle getComponentHandle() {
        return this.component.getComponentHandle();
    }

    public String getVersion() {
        return "1.2";
    }

    public String getType() {
        return "j2ee.ear";
    }

    public IModuleType getModuleType() {
        return new IModuleType(){

            public String getId() {
                return J2EEFlexProjDeployable.this.getType();
            }

            public String getName() {
                return J2EEFlexProjDeployable.this.getModuleTypeName();
            }

            public String getVersion() {
                return J2EEFlexProjDeployable.this.getModuleTypeVersion();
            }
        };
    }

    public IModuleResource[] members() throws CoreException {
        this.outputMembersAdded = false;
        return super.members();
    }

    public IPath getRootFolder() {
        IPath path = null;
        if (ModuleCoreNature.getModuleCoreNature((IProject)this.project) != null && this.component != null) {
            IFolder outputContainer = StructureEdit.getOutputContainerRoot((IVirtualComponent)this.component);
            path = outputContainer.getProjectRelativePath();
        }
        return path;
    }

    protected IContainer getContainerResource(IResource resource) {
        IJavaElement element;
        if (resource instanceof IFolder && (element = JavaCore.create((IFolder)((IFolder)resource))) != null && element.getElementType() == 3) {
            return this.addOutputFolderIfNecessary(element);
        }
        return (IContainer)resource;
    }

    private IContainer addOutputFolderIfNecessary(IJavaElement je) {
        if (!this.outputMembersAdded) {
            this.outputMembersAdded = true;
            IPath javaOutputPath = null;
            try {
                IPackageFragmentRoot root;
                if (je.getElementType() == 3 && (root = (IPackageFragmentRoot)je).getKind() == 1) {
                    IClasspathEntry ce = root.getRawClasspathEntry();
                    javaOutputPath = ce.getOutputLocation();
                    javaOutputPath = javaOutputPath.removeFirstSegments(1);
                    return this.getProject().getFolder(javaOutputPath);
                }
            }
            catch (JavaModelException e) {
                Logger.getLogger().log((Object)e.getMessage());
            }
        }
        return null;
    }
}

