/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.earcreation;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.EARProjectMap;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.ModuleMapping;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.UtilityJARMapping;

public class ModuleMapHelper {
    protected ModuleMapHelper() {
    }

    public static ModuleMapping getModuleMapping(Module module, EARProjectMap projectMap) {
        if (module == null) {
            return null;
        }
        List maps = ModuleMapHelper.getModuleMappings(projectMap);
        int i = 0;
        while (i < maps.size()) {
            ModuleMapping map = (ModuleMapping)maps.get(i);
            if (module.equals(map.getModule())) {
                return map;
            }
            ++i;
        }
        return null;
    }

    public static List getModuleMappings(EARProjectMap map) {
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        return map.getMappings();
    }

    public static UtilityJARMapping getUtilityJARMapping(String uri, EARProjectMap projectMap) {
        if (uri == null || projectMap == null) {
            return null;
        }
        List maps = ModuleMapHelper.getUtilityJARMappings(projectMap);
        int i = 0;
        while (i < maps.size()) {
            UtilityJARMapping map = (UtilityJARMapping)maps.get(i);
            if (uri.equals(map.getUri())) {
                return map;
            }
            ++i;
        }
        return null;
    }

    public static List getUtilityJARMappings(EARProjectMap map) {
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        return map.getUtilityJARMappings();
    }

    public static EARProjectMap getEARProjectMap(Resource res) {
        if (res == null || res.getContents().isEmpty()) {
            return null;
        }
        return (EARProjectMap)res.getContents().get(0);
    }

    public static List getAllMappedJARs(EARFile ear) {
        if (ear == null) {
            return Collections.EMPTY_LIST;
        }
        Resource res = null;
        try {
            res = ear.getMofResource("META-INF/.modulemaps");
        }
        catch (Exception ex) {
            Logger.getLogger().logError((Throwable)ex);
            return Collections.EMPTY_LIST;
        }
        EARProjectMap map = ModuleMapHelper.getEARProjectMap(res);
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        List moduleMaps = ModuleMapHelper.getModuleMappings(map);
        int i = 0;
        while (i < moduleMaps.size()) {
            ModuleMapping mMap = (ModuleMapping)moduleMaps.get(i);
            Module m = mMap.getModule();
            if (m != null) {
                ModuleMapHelper.addArchiveIfNotNull(result, m.getUri(), ear);
            }
            ++i;
        }
        List utilMaps = ModuleMapHelper.getUtilityJARMappings(map);
        int i2 = 0;
        while (i2 < utilMaps.size()) {
            UtilityJARMapping uMap = (UtilityJARMapping)utilMaps.get(i2);
            ModuleMapHelper.addArchiveIfNotNull(result, uMap.getUri(), ear);
            ++i2;
        }
        return result;
    }

    protected static void addArchiveIfNotNull(List result, String uri, EARFile ear) {
        Archive anArchive = ModuleMapHelper.getArchive(uri, ear);
        if (anArchive != null) {
            result.add(anArchive);
        }
    }

    protected static Archive getArchive(String uri, EARFile ear) {
        if (uri == null || uri.trim().length() == 0) {
            return null;
        }
        try {
            return (Archive)ear.getFile(uri);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger().logError((Throwable)ex);
        }
        catch (ClassCastException ex2) {
            Logger.getLogger().logError((Throwable)ex2);
        }
        return null;
    }

    public static IProject getProject(String uri, EARFile ear) {
        if (uri == null || uri.length() == 0 || ear == null) {
            return null;
        }
        Resource res = null;
        try {
            res = ear.getMofResource("META-INF/.modulemaps");
        }
        catch (Exception exception) {
            return null;
        }
        EARProjectMap map = ModuleMapHelper.getEARProjectMap(res);
        if (map == null) {
            return null;
        }
        String projectName = null;
        UtilityJARMapping uMap = ModuleMapHelper.getUtilityJARMapping(uri, map);
        if (uMap != null) {
            projectName = uMap.getProjectName();
        } else {
            ModuleMapping mMap;
            Module m = ear.getDeploymentDescriptor().getFirstModule(uri);
            if (m != null && (mMap = ModuleMapHelper.getModuleMapping(m, map)) != null) {
                projectName = mMap.getProjectName();
            }
        }
        if (projectName != null && projectName.trim().length() > 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName.trim());
        }
        return null;
    }
}

