/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.MinimizeLib;
import org.eclipse.jst.j2ee.internal.project.J2EENature;

public class MinimizeLib {
    static boolean DEBUG = true;

    public static void minimize(IJavaProject project) {
        IFolder classesFolder;
        if (DEBUG) {
            System.out.println(String.valueOf(J2EEPluginResourceHandler.getString("Minimizing_project_UI_")) + project.getElementName());
        }
        if (!(classesFolder = project.getProject().getFolder("imported_classes")).exists()) {
            if (DEBUG) {
                System.out.println(String.valueOf(J2EEPluginResourceHandler.getString("No_library_folder_UI_")) + classesFolder.getFullPath());
            }
            return;
        }
        HashSet<String> sourceTypeNames = new HashSet<String>(1000);
        J2EENature nature = J2EENature.getRegisteredRuntime(project.getProject());
        if (nature == null) {
            if (DEBUG) {
                System.out.println(String.valueOf(J2EEPluginResourceHandler.getString("Not_a_J2EE_project_UI_")) + project.getProject());
            }
            return;
        }
        List sourceFolders = JemProjectUtilities.getSourceContainers((IProject)project.getProject());
        Iterator iter = sourceFolders.iterator();
        while (iter.hasNext()) {
            IFolder srcFolder = (IFolder)iter.next();
            try {
                IPackageFragmentRoot srcRoot = project.getPackageFragmentRoot((IResource)srcFolder);
                IJavaElement[] pkgs = srcRoot.getChildren();
                int i = 0;
                while (i < pkgs.length) {
                    if (pkgs[i] instanceof IPackageFragment) {
                        IPackageFragment pkg = (IPackageFragment)pkgs[i];
                        ICompilationUnit[] cus = pkg.getCompilationUnits();
                        int j = 0;
                        while (j < cus.length) {
                            ICompilationUnit cu = cus[j];
                            sourceTypeNames.addAll(Arrays.asList(MinimizeLib.extractTypeNames(cu)));
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        if (sourceTypeNames.isEmpty()) {
            if (DEBUG) {
                System.out.println(J2EEPluginResourceHandler.getString("No_source_types_UI_"));
            }
            return;
        }
        Iterator it = sourceTypeNames.iterator();
        while (it.hasNext()) {
            String sourceTypeName = (String)it.next();
            if (sourceTypeName.indexOf(36) < 0) continue;
            throw new RuntimeException(J2EEPluginResourceHandler.getString("Some_source_types_have___$___in_their_name_ERROR_"));
        }
        try {
            class Visitor
            implements IResourceVisitor {
                private final /* synthetic */ Set val$sourceTypeNames;

                Visitor(Set set) {
                    this.val$sourceTypeNames = set;
                }

                public boolean visit(IResource res) throws CoreException {
                    if (res.getType() == 1) {
                        IFile file = (IFile)res;
                        String ext = res.getFileExtension();
                        if (ext != null && ext.equals("class")) {
                            String baseTypeName;
                            IPath pkgPath = file.getFullPath().removeFirstSegments(2).removeLastSegments(1);
                            String pkgName = pkgPath.toString().replace('/', '.');
                            String string = baseTypeName = pkgName.length() == 0 ? MinimizeLib.baseTypeName(file) : String.valueOf(pkgName) + "." + MinimizeLib.baseTypeName(file);
                            if (MinimizeLib.DEBUG) {
                                System.out.println("Have source for " + baseTypeName + "? " + (this.val$sourceTypeNames.contains(baseTypeName) ? "Yes" : "No"));
                            }
                            if (this.val$sourceTypeNames.contains(baseTypeName)) {
                                MinimizeLib.deleteClassFile(file);
                            }
                        }
                    }
                    return true;
                }
            }
            classesFolder.accept((IResourceVisitor)new Visitor(sourceTypeNames));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    static void deleteClassFile(IFile classFile) {
        if (DEBUG) {
            System.out.println("Delete " + classFile.getFullPath());
        }
        try {
            classFile.delete(true, false, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    static String baseTypeName(IFile classFile) {
        String fileName = classFile.getName();
        int x = fileName.lastIndexOf(".class");
        if (x < 0) {
            throw new IllegalArgumentException();
        }
        String binaryTypeName = fileName.substring(0, x);
        int d = binaryTypeName.indexOf("$");
        if (d < 0) {
            return binaryTypeName;
        }
        return binaryTypeName.substring(0, d);
    }

    static String[] extractTypeNames(ICompilationUnit cu) {
        ArrayList<String> typeNames = new ArrayList<String>();
        try {
            IPackageDeclaration[] pds = cu.getPackageDeclarations();
            String packageName = pds.length == 0 ? "" : pds[0].getElementName();
            IType[] types = cu.getTypes();
            int k = 0;
            while (k < types.length) {
                IType type = types[k];
                String name = type.getElementName();
                String fqTypeName = packageName.length() == 0 ? name : String.valueOf(packageName) + "." + name;
                typeNames.add(fqTypeName);
                ++k;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        String[] result = new String[typeNames.size()];
        typeNames.toArray(result);
        return result;
    }
}

