/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.project;

import java.util.ArrayList;
import org.eclipse.jst.common.componentcore.util.ComponentUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.internal.archive.operations.JavaComponentLoadStrategyImpl;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class J2EEComponentUtilities
extends ComponentUtilities {
    public static IVirtualComponent[] getReferencingEARComponents(IVirtualComponent component) {
        ArrayList<IVirtualComponent> result = new ArrayList<IVirtualComponent>();
        IVirtualComponent[] refComponents = component.getReferencingComponents();
        int i = 0;
        while (i < refComponents.length) {
            if (refComponents[i].getComponentTypeId().equals("jst.ear")) {
                result.add(refComponents[i]);
            }
            ++i;
        }
        return result.toArray(new IVirtualComponent[result.size()]);
    }

    public static boolean isStandaloneComponent(IVirtualComponent component) {
        return J2EEComponentUtilities.getReferencingEARComponents(component).length <= 0;
    }

    public static Archive asArchive(String jarUri, IVirtualComponent component, boolean exportSource) throws OpenFailureException {
        JavaComponentLoadStrategyImpl strat = new JavaComponentLoadStrategyImpl(component);
        strat.setExportSource(exportSource);
        return CommonarchiveFactoryImpl.getActiveFactory().primOpenArchive((LoadStrategy)strat, jarUri);
    }

    public static boolean isWebComponent(IVirtualComponent component) {
        return component.getComponentTypeId().equals("jst.web");
    }

    public static boolean isStandaloneWebComponent(IVirtualComponent component) {
        return component.getComponentTypeId().equals("jst.web") && J2EEComponentUtilities.isStandaloneComponent(component);
    }
}

