/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.project;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.ApplicationClientNatureRuntime;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.AppClient12ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.EjbJar11ImportStrategyImpl;
import org.eclipse.jst.j2ee.internal.common.impl.J2EEResouceFactorySaxRegistry;
import org.eclipse.jst.j2ee.internal.common.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.internal.project.J2EEModuleNature;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.eclipse.jst.j2ee.internal.project.J2EEWorkbenchURIConverterImpl;
import org.eclipse.jst.j2ee.internal.project.ZipFileEntryInputStream;

public class J2EEModuleWorkbenchURIConverterImpl
extends J2EEWorkbenchURIConverterImpl {
    protected IPath inputJARLocation;
    protected IPath inputJARProjectRelativePath;

    public J2EEModuleWorkbenchURIConverterImpl(J2EEModuleNature aNature, ResourceSetWorkbenchSynchronizer aSynchronizer) {
        super(aNature, aSynchronizer);
    }

    protected void initialize() {
        this.recomputeInputsIfNecessary();
        super.initialize();
    }

    protected ArchiveTypeDiscriminator getArchiveDiscriminator() {
        if (this.nature.getNatureID().equals("org.eclipse.jst.j2ee.ejb.EJBNature")) {
            return EjbJar11ImportStrategyImpl.getDiscriminator();
        }
        if (this.nature instanceof ApplicationClientNatureRuntime) {
            return AppClient12ImportStrategyImpl.getDiscriminator();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isJ2EEArchive(IResource resource) {
        boolean bl;
        String uri = resource.getLocation().toOSString();
        ArchiveTypeDiscriminator disc = this.getArchiveDiscriminator();
        if (disc == null) {
            return false;
        }
        Archive anArchive = null;
        try {
            try {
                anArchive = this.getArchiveFactory().primOpenArchive(uri);
                bl = disc.canImport(anArchive);
                Object var5_6 = null;
                if (anArchive == null) return bl;
            }
            catch (OpenFailureException openFailureException) {
                Object var5_7 = null;
                if (anArchive == null) return false;
                anArchive.close();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (anArchive == null) throw throwable;
            anArchive.close();
            throw throwable;
        }
        anArchive.close();
        return bl;
    }

    protected CommonarchiveFactory getArchiveFactory() {
        return CommonarchiveFactory.eINSTANCE;
    }

    public boolean recomputeInputsIfNecessary() {
        boolean containersChanged = this.recomputeContainersIfNecessary();
        boolean inputJARChanged = this.recomputeInputJARLocation();
        return containersChanged || inputJARChanged;
    }

    public boolean recomputeContainersIfNecessary() {
        IContainer newInput;
        boolean changed;
        IContainer input = this.getInputContainer();
        boolean bl = changed = !this.objectsEqual(input, newInput = this.nature.getEMFRoot());
        if (changed && this.getNature() != null && this.getNature().getProject() != null && this.getNature().getProject().isAccessible()) {
            EList resources = this.getNature().getResourceSet().getResources();
            this.deNormalize((List)resources);
            this.getInputContainers().clear();
            this.setOutputContainer(null);
            this.resetNormalizedResourceCache();
            if (newInput != null) {
                this.addInputContainer(newInput);
            }
            this.normalize((List)resources);
        }
        return changed;
    }

    private void resetNormalizedResourceCache() {
        ResourceSet set;
        J2EENature aNature = this.getNature();
        if (aNature != null && (set = aNature.getResourceSet()) instanceof ProjectResourceSet) {
            ((ProjectResourceSet)set).resetNormalizedURICache();
        }
    }

    public boolean recomputeInputJARLocation() {
        if (!((J2EEModuleNature)this.nature).canBeBinary()) {
            return false;
        }
        IPath existing = this.inputJARLocation;
        IPath newLoc = null;
        boolean changed = false;
        IResource resource = null;
        if (JemProjectUtilities.isBinaryProject((IProject)this.nature.getProject())) {
            resource = this.getInputJARResource();
            IPath iPath = newLoc = resource == null ? null : resource.getLocation();
        }
        if (!this.objectsEqual(existing, newLoc)) {
            changed = true;
            this.inputJARLocation = newLoc;
            this.inputJARProjectRelativePath = resource == null ? null : resource.getProjectRelativePath();
            this.nature.getResourceSet().setResourceFactoryRegistry((Resource.Factory.Registry)(this.inputJARLocation == null ? J2EEResourceFactoryRegistry.INSTANCE : J2EEResouceFactorySaxRegistry.INSTANCE));
        }
        return changed;
    }

    protected IResource getInputJARResource() {
        IProject project = this.nature.getProject();
        if (project == null) {
            return null;
        }
        List jarPaths = JemProjectUtilities.getLocalJARPathsFromClasspath((IProject)project);
        int i = 0;
        while (i < jarPaths.size()) {
            IPath path = (IPath)jarPaths.get(i);
            IResource resource = project.findMember(path);
            if (resource != null && resource.exists() && resource instanceof IFile && this.isJ2EEArchive(resource)) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    public InputStream createInputStream(URI uri) throws IOException {
        if (this.isBinary()) {
            return this.createBinaryInputStream(uri);
        }
        return super.createInputStream(uri);
    }

    protected InputStream createBinaryInputStream(URI uri) throws IOException {
        ZipFileEntryInputStream zipFileEntryInputStream;
        block4: {
            if (!((URIConverterImpl.URIMap)this.getURIMap()).getURI(uri).equals((Object)uri)) {
                return super.createInputStream(uri);
            }
            ZipFile zip = null;
            boolean forceClose = true;
            try {
                zip = new ZipFile(this.inputJARLocation.toOSString());
                InputStream result = this.searchZipFile(zip, uri.toString());
                if (result == null) {
                    throw new FileNotFoundException(uri.toString());
                }
                ZipFileEntryInputStream inputStream = new ZipFileEntryInputStream(result, zip);
                forceClose = false;
                zipFileEntryInputStream = inputStream;
                Object var6_7 = null;
                if (!forceClose || zip == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var6_8 = null;
                    if (!forceClose || zip == null) break block5;
                    zip.close();
                }
                throw throwable;
            }
            zip.close();
        }
        return zipFileEntryInputStream;
    }

    public IPath getInputJARLocation() {
        return this.inputJARLocation;
    }

    public IPath getInputJARProjectRelativePath() {
        return this.inputJARProjectRelativePath;
    }

    protected boolean isBroken() {
        return super.isBroken() && this.getInputJARLocation() == null;
    }

    protected boolean isBinary() {
        return this.inputJARLocation != null;
    }

    public boolean canGetUnderlyingResource(String aFileName) {
        if (this.isBinary()) {
            return this.hasZipEntry(aFileName);
        }
        return super.canGetUnderlyingResource(aFileName);
    }

    protected boolean isClasspathChanged(IResourceDelta delta) {
        IResourceDelta child = delta.findMember((IPath)new Path(".classpath"));
        return child != null && child.getFlags() != 131072;
    }

    /*
     * Exception decompiling
     */
    private boolean hasZipEntry(String aFileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 67->70)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected InputStream searchZipFile(ZipFile zip, String filename) throws IOException {
        ZipEntry entry = zip.getEntry(filename);
        if (entry == null) {
            return null;
        }
        return zip.getInputStream(entry);
    }

    protected boolean shouldNotifyChangedListeners(IResourceDelta delta) {
        return (this.isClasspathChanged(delta) || super.shouldNotifyChangedListeners(delta)) && this.recomputeInputsIfNecessary();
    }
}

