/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.reference;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.EJBLocalRef;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.MessageDestinationRef;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.common.operations.J2EEModelModifierOperationDataModel;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceExtManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceHelper;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public abstract class ReferenceDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String OWNER = "ReferenceDataModel.OWNER";
    public static final String REF_NAME = "ReferenceDataModel.REF_NAME";
    public static final String DESCRIPTION = "ReferenceDataModel.DESCRIPTION";
    public static final String MODULE_TYPE = "ReferenceDataModel.MODULE_TYPE";
    public static final String J2EE_VERSION = "ReferenceDataModel.J2EE_VERSION";
    public static final int EJB_TYPE = 0;
    public static final int APP_CLIENT_TYPE = 1;
    public static final int WEB_TYPE = 2;
    protected int ownerType;

    protected void init() {
        super.init();
    }

    protected void initializeOwnerNature() {
        IProject ownerProject;
        EObject owner = (EObject)this.getProperty(OWNER);
        if (owner != null && (ownerProject = ProjectUtilities.getProject((EObject)owner)) != null) {
            if (owner instanceof EnterpriseBean) {
                this.ownerType = 0;
            } else if (owner instanceof ApplicationClient) {
                this.ownerType = 1;
            } else if (owner instanceof WebApp) {
                this.ownerType = 2;
            }
        }
    }

    protected void initValidBaseProperties() {
        this.addValidBaseProperty(OWNER);
        this.addValidBaseProperty(REF_NAME);
        this.addValidBaseProperty(DESCRIPTION);
        this.addValidBaseProperty(J2EE_VERSION);
        this.addValidBaseProperty(MODULE_TYPE);
        super.initValidBaseProperties();
    }

    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean doSet = super.doSetProperty(propertyName, propertyValue);
        if (OWNER.equals(propertyName)) {
            try {
                this.initializeOwnerNature();
                this.notifyDefaultChange(MODULE_TYPE);
                this.notifyDefaultChange(J2EE_VERSION);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return doSet;
    }

    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(MODULE_TYPE)) {
            return this.calculateOwnerModuleType();
        }
        if (propertyName.equals(J2EE_VERSION)) {
            int version = this.calculateJ2EEVersionForOwnerModule();
            return new Integer(version);
        }
        return super.getDefaultProperty(propertyName);
    }

    private Object calculateOwnerModuleType() {
        IProject ownerProject;
        EObject owner = (EObject)this.getProperty(OWNER);
        if (owner != null && (ownerProject = ProjectUtilities.getProject((EObject)owner)) != null) {
            if (owner instanceof EnterpriseBean) {
                return "ejb-jar_ID";
            }
            if (owner instanceof ApplicationClient) {
                return "Application-client_ID";
            }
            if (owner instanceof WebApp) {
                return "WebApp_ID";
            }
        }
        return null;
    }

    private int calculateJ2EEVersionForOwnerModule() {
        String moduleType = this.getStringProperty(MODULE_TYPE);
        if (moduleType == null) {
            return -1;
        }
        if (moduleType.equals("ejb-jar_ID")) {
            switch (((EnterpriseBean)this.getProperty(OWNER)).getVersionID()) {
                case 10: {
                    return 12;
                }
                case 11: {
                    return 12;
                }
                case 20: {
                    return 13;
                }
                case 21: {
                    return 14;
                }
            }
            return 14;
        }
        if (moduleType.equals("WebApp_ID")) {
            switch (((WebApp)this.getProperty(OWNER)).getVersionID()) {
                case 22: {
                    return 12;
                }
                case 23: {
                    return 13;
                }
                case 24: {
                    return 14;
                }
            }
            return 14;
        }
        if (moduleType.equals("Application-client_ID")) {
            return ((ApplicationClient)this.getProperty(OWNER)).getVersionID();
        }
        return -1;
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (OWNER.equals(propertyName) && this.getProperty(OWNER) == null) {
            return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.getString("ReferenceDataModel_UI_3"));
        }
        if (REF_NAME.equals(propertyName)) {
            String nameValue = this.getStringProperty(propertyName);
            if (nameValue == null || nameValue.trim().equals("")) {
                return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.getString("ReferenceDataModel_UI_5"));
            }
            if (!this.validateReferenceDoesNotExist(nameValue.trim())) {
                return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.getString("ReferenceDataModel_UI_6"));
            }
        }
        return super.doValidateProperty(propertyName);
    }

    public boolean validateReferenceDoesNotExist(String nameValue) {
        if (this.ownerType == 0) {
            EnterpriseBean bean = (EnterpriseBean)this.getProperty(OWNER);
            if (this.checkResourceRefExists(bean.getResourceRefs(), nameValue)) {
                return false;
            }
            if (this.checkResourceEnvRefExists(bean.getResourceEnvRefs(), nameValue)) {
                return false;
            }
            if (this.checkEJBLocalRefExists(bean.getEjbLocalRefs(), nameValue)) {
                return false;
            }
            if (this.checkEJBRefExists(bean.getEjbRefs(), nameValue)) {
                return false;
            }
            if (this.checkSecurityRoleRefExists(bean.getSecurityRoleRefs(), nameValue)) {
                return false;
            }
            if (bean.getVersionID() >= 21) {
                if (this.checkServiceRefExists((List)bean.getServiceRefs(), nameValue)) {
                    return false;
                }
                if (this.checkMessageDestRefExists(bean.getMessageDestinationRefs(), nameValue)) {
                    return false;
                }
            } else {
                WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
                List temp = serviceHelper.get13ServiceRefs((EObject)bean);
                if (temp != null && !temp.isEmpty() && this.checkServiceRefExists(temp, nameValue)) {
                    return false;
                }
            }
        } else if (this.ownerType == 1) {
            ApplicationClient appClient = (ApplicationClient)this.getProperty(OWNER);
            if (this.checkResourceRefExists(appClient.getResourceRefs(), nameValue)) {
                return false;
            }
            if (this.checkResourceEnvRefExists(appClient.getResourceEnvRefs(), nameValue)) {
                return false;
            }
            if (this.checkEJBRefExists(appClient.getEjbReferences(), nameValue)) {
                return false;
            }
            if (appClient.getVersionID() >= 14) {
                if (this.checkServiceRefExists((List)appClient.getServiceRefs(), nameValue)) {
                    return false;
                }
                if (this.checkMessageDestRefExists(appClient.getMessageDestinationRefs(), nameValue)) {
                    return false;
                }
            } else {
                WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
                List temp = serviceHelper.get13ServiceRefs((EObject)appClient);
                if (temp != null && !temp.isEmpty() && this.checkServiceRefExists(temp, nameValue)) {
                    return false;
                }
            }
        } else if (this.ownerType == 2) {
            WebApp webApp = (WebApp)this.getProperty(OWNER);
            if (this.checkResourceRefExists(webApp.getResourceRefs(), nameValue)) {
                return false;
            }
            if (this.checkResourceEnvRefExists(webApp.getResourceEnvRefs(), nameValue)) {
                return false;
            }
            if (this.checkEJBLocalRefExists(webApp.getEjbLocalRefs(), nameValue)) {
                return false;
            }
            if (this.checkEJBRefExists(webApp.getEjbRefs(), nameValue)) {
                return false;
            }
            if (webApp.getVersionID() >= 24) {
                if (this.checkServiceRefExists((List)webApp.getServiceRefs(), nameValue)) {
                    return false;
                }
                if (this.checkMessageDestRefExists(webApp.getMessageDestinationRefs(), nameValue)) {
                    return false;
                }
            } else {
                WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
                List temp = serviceHelper.get13ServiceRefs((EObject)webApp);
                if (temp != null && !temp.isEmpty() && this.checkServiceRefExists(temp, nameValue)) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkSecurityRoleRefExists(EList list, String refName) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                SecurityRoleRef ref = (SecurityRoleRef)list.get(i);
                if (ref.getName() != null && ref.getName().equals(refName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean checkEJBRefExists(EList list, String refName) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                EjbRef ref = (EjbRef)list.get(i);
                if (ref.getName() != null && ref.getName().equals(refName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean checkEJBLocalRefExists(EList list, String refName) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                EJBLocalRef ref = (EJBLocalRef)list.get(i);
                if (ref.getName() != null && ref.getName().equals(refName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean checkServiceRefExists(List list, String refName) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                ServiceRef ref = (ServiceRef)list.get(i);
                if (ref.getServiceRefName() != null && ref.getServiceRefName().equals(refName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean checkResourceEnvRefExists(EList list, String refName) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                ResourceEnvRef ref = (ResourceEnvRef)list.get(i);
                if (ref.getName() != null && ref.getName().equals(refName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean checkResourceRefExists(EList list, String refName) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                ResourceRef ref = (ResourceRef)list.get(i);
                if (ref.getName() != null && ref.getName().equals(refName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean checkMessageDestRefExists(EList list, String refName) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                MessageDestinationRef ref = (MessageDestinationRef)list.get(i);
                if (ref.getName() != null && ref.getName().equals(refName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

