/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.rename;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.earcreation.EAREditModel;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.jst.j2ee.internal.project.J2EEModuleNature;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.rename.ClasspathRenameInfo;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;

public class RenameModuleDependencyOperation
extends WTPOperation {
    protected List earEditModels;
    protected Set projects;
    protected IProject renamedProject = null;
    protected Map renameInfos;
    protected IProgressMonitor monitor;
    protected static String MOD_DEP_RENAME_ERRORS = J2EECreationResourceHandler.getString("Errors_occurred_renaming_module_dependencies_UI_");

    public RenameModuleDependencyOperation(List earEditModels, Set projects, IProject renamedProject) {
        this.earEditModels = earEditModels;
        this.projects = projects;
        this.renamedProject = renamedProject;
    }

    protected Map getRenameInfos() {
        if (this.renameInfos == null) {
            this.renameInfos = new HashMap();
        }
        return this.renameInfos;
    }

    protected ClasspathRenameInfo getRenameInfo(IProject referencingProject) {
        ClasspathRenameInfo info = (ClasspathRenameInfo)this.getRenameInfos().get(referencingProject);
        if (info != null) {
            return info;
        }
        info = new ClasspathRenameInfo(referencingProject);
        this.renameInfos.put(referencingProject, info);
        return info;
    }

    protected void execute(IProgressMonitor aMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.monitor = aMonitor;
        this.gatherRenameInfoIfNecessary();
        this.executeRenameInfo();
    }

    protected void gatherRenameInfo() {
        int i = 0;
        while (i < this.earEditModels.size()) {
            EAREditModel model = (EAREditModel)((Object)this.earEditModels.get(i));
            this.gatherRenameInfo(model);
            ++i;
        }
    }

    protected void gatherRenameInfo(EAREditModel editModel) {
        EARNatureRuntime runtime = editModel.getEARNature();
        Map urisToNatures = runtime.getModuleProjects();
        Iterator iterator = this.projects.iterator();
        while (iterator.hasNext()) {
            IProject project = (IProject)iterator.next();
            this.gatherRenameInfo(runtime, urisToNatures, project);
        }
    }

    protected void gatherRenameInfo(EARNatureRuntime runtime, Map urisToNatures, IProject referencedProject) {
        Module m = runtime.getModule(referencedProject);
        if (m == null) {
            return;
        }
        Iterator it = urisToNatures.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String uri = (String)entry.getKey();
            J2EENature nature = (J2EENature)((Object)entry.getValue());
            if (nature == null || referencedProject.equals((Object)nature.getProject())) continue;
            this.gatherRenameInfo(uri, nature, referencedProject, m.getUri());
        }
    }

    protected void gatherRenameInfo(String testUri, J2EENature testNature, IProject referencedProject, String moduleUri) {
        ArchiveManifest mf = J2EEProjectUtilities.readManifest(testNature.getProject());
        if (mf == null) {
            return;
        }
        String[] classpath = J2EEProjectUtilities.readManifest(testNature.getProject()).getClassPathTokenized();
        int i = 0;
        while (i < classpath.length) {
            String resolved = ArchiveUtil.deriveEARRelativeURI((String)classpath[i], (String)moduleUri);
            if (moduleUri.equals(resolved)) {
                ClasspathRenameInfo info = this.getRenameInfo(testNature.getProject());
                info.getManifestEntries().add(classpath[i]);
                info.getReferencedProjects().add(referencedProject);
            }
            ++i;
        }
    }

    protected void executeRenameInfo() throws InvocationTargetException {
        if (this.renameInfos == null) {
            return;
        }
        Iterator it = this.renameInfos.values().iterator();
        while (it.hasNext()) {
            ClasspathRenameInfo info = (ClasspathRenameInfo)it.next();
            IProject p = info.getTargetProject();
            J2EEModuleNature nature = (J2EEModuleNature)J2EENature.getRegisteredRuntime(p);
            if (nature == null) continue;
            if (nature.isBinaryProject()) {
                String message = J2EECreationResourceHandler.getString("Can_not_rename_module_dependency_from_project_UI_", new Object[]{p.getName()});
                this.addErrorStatus(message);
                continue;
            }
            try {
                this.replaceManifest(nature, info);
                this.replaceBuildPath(nature, info);
            }
            catch (Exception ex) {
                throw new WFTWrappedException((Throwable)ex);
            }
        }
    }

    protected void replaceManifest(J2EENature nature, ClasspathRenameInfo info) throws IOException {
        ArchiveManifest mf = J2EEProjectUtilities.readManifest(nature.getProject());
        if (mf == null) {
            return;
        }
        String[] entries = mf.getClassPathTokenized();
        StringBuffer sb = new StringBuffer();
        boolean empty = true;
        int i = 0;
        while (i < entries.length) {
            String entry = entries[i];
            if (info.getManifestEntries().contains(entry)) {
                String suffix = entry.substring(entry.lastIndexOf(46));
                entry = this.renamedProject.getName();
                entry = entry.concat(suffix);
            }
            if (!empty) {
                sb.append(" ");
            }
            empty = false;
            sb.append(entry);
            ++i;
        }
        mf.setClassPath(sb.toString());
        J2EEProjectUtilities.writeManifest(nature.getProject(), mf);
    }

    protected void replaceBuildPath(J2EENature nature, ClasspathRenameInfo info) throws JavaModelException {
        IJavaProject javaP = JemProjectUtilities.getJavaProject((IProject)nature.getProject());
        if (javaP == null) {
            return;
        }
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] entries = javaP.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (this.shouldKeepEntry(entry, info)) {
                result.add(entry);
            } else {
                IPath path = this.renamedProject.getFullPath();
                IClasspathEntry renamedEntry = JavaCore.newProjectEntry((IPath)path, (boolean)true);
                result.add(renamedEntry);
            }
            ++i;
        }
        IClasspathEntry[] toArray = result.toArray(new IClasspathEntry[result.size()]);
        javaP.setRawClasspath(toArray, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
    }

    protected boolean shouldKeepEntry(IClasspathEntry entry, ClasspathRenameInfo info) {
        if (entry.getEntryKind() != 2) {
            return true;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().toString());
        return !info.getReferencedProjects().contains(project);
    }

    protected List getAffectedFiles() {
        this.gatherRenameInfoIfNecessary();
        if (this.renameInfos == null || this.renameInfos.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IFile> result = new ArrayList<IFile>();
        Iterator it = this.renameInfos.values().iterator();
        while (it.hasNext()) {
            ClasspathRenameInfo info = (ClasspathRenameInfo)it.next();
            IProject p = info.getTargetProject();
            IFile aFile = J2EEProjectUtilities.getManifestFile(p);
            if (aFile == null || !aFile.exists()) continue;
            result.add(aFile);
            result.addAll(ProjectUtilities.getFilesAffectedByClasspathChange((IProject)p));
        }
        return result;
    }

    protected void gatherRenameInfoIfNecessary() {
        if (this.renameInfos == null || this.renameInfos.isEmpty()) {
            int i = 0;
            while (i < this.earEditModels.size()) {
                EAREditModel model = (EAREditModel)((Object)this.earEditModels.get(i));
                this.gatherRenameInfo(model);
                ++i;
            }
        }
    }

    protected void addErrorStatus(String message) {
        IStatus newStatus = J2EEPlugin.newErrorStatus(message, null);
        this.addStatus(newStatus);
    }
}

