/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.servertarget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jst.j2ee.internal.servertarget.ITargetRuntimeExtensionHandler;
import org.eclipse.jst.j2ee.internal.servertarget.TargetRuntimeExtension;

public class TargetRuntimeExtensionHandlerReader
extends RegistryReader {
    static TargetRuntimeExtensionHandlerReader instance = null;
    protected ITargetRuntimeExtensionHandler targetRuntimeExtHandler;
    protected String HANDLER_EXT_Id = "targetRuntimeExtensionHandler";
    protected TargetRuntimeExtension extension = null;
    protected String HANDLER_CLASSNAME = "className";
    protected String HANDLER_GROUP_ID = "groupID";
    protected HashMap handlerExtensions = null;

    public TargetRuntimeExtensionHandlerReader(IPluginRegistry registry, String plugin, String extensionPoint) {
        super(plugin, extensionPoint);
    }

    public TargetRuntimeExtensionHandlerReader() {
        super("org.eclipse.jst.j2ee", "TargetRuntimeExtHandler");
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(this.HANDLER_EXT_Id)) {
            return false;
        }
        String group = element.getAttribute(this.HANDLER_GROUP_ID);
        String className = element.getAttribute(this.HANDLER_CLASSNAME);
        if (group == null) {
            this.logMissingAttribute(element, "Missing group target runtime extension specification.");
            return false;
        }
        try {
            Plugin plugin = element.getDeclaringExtension().getDeclaringPluginDescriptor().getPlugin();
            this.extension = new TargetRuntimeExtension(plugin, element, group, className);
            this.addExtensionPoint(this.extension);
            return true;
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            return false;
        }
    }

    protected void addExtensionPoint(TargetRuntimeExtension newExtension) {
        if (this.handlerExtensions == null) {
            this.handlerExtensions = new HashMap();
        }
        Collection<TargetRuntimeExtension> temp = null;
        Object holder = this.handlerExtensions.get(newExtension.getGroupId());
        if (temp == null) {
            temp = new ArrayList<TargetRuntimeExtension>();
            temp.add(newExtension);
        } else {
            this.handlerExtensions.remove(newExtension.getGroupId());
            temp = (Collection)holder;
            temp.add(newExtension);
        }
        this.handlerExtensions.put(newExtension.getGroupId(), temp);
    }

    public static TargetRuntimeExtensionHandlerReader getInstance() {
        if (instance == null) {
            instance = new TargetRuntimeExtensionHandlerReader();
        }
        return instance;
    }

    public ITargetRuntimeExtensionHandler getEJBExtHandler() {
        if (this.targetRuntimeExtHandler == null && this.handlerExtensions != null) {
            TargetRuntimeExtension codegenExt = null;
            ArrayList ibmExtensions = (ArrayList)this.handlerExtensions.get("IBM");
            if (ibmExtensions != null) {
                int i = 0;
                while (i < ibmExtensions.size()) {
                    Object obj = ibmExtensions.get(i);
                    if (obj instanceof TargetRuntimeExtension) {
                        codegenExt = (TargetRuntimeExtension)obj;
                        break;
                    }
                    ++i;
                }
            }
            if (codegenExt != null) {
                IConfigurationElement cElement = codegenExt.configElement;
                try {
                    this.targetRuntimeExtHandler = (ITargetRuntimeExtensionHandler)cElement.createExecutableExtension("run");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.targetRuntimeExtHandler;
    }
}

